/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.PseudoSplitter;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class SplitterWithSecondHideable {
    @NotNull
    private final PseudoSplitter mySplitter;
    @NotNull
    private final AbstractTitledSeparatorWithIcon myTitledSeparator;
    @NotNull
    private final OnOffListener<Integer> myListener;
    @NotNull
    private final JPanel myFictivePanel;
    private float myPreviousProportion;

    public SplitterWithSecondHideable(boolean vertical, @NotNull String separatorText, @NotNull JComponent firstComponent, @NotNull OnOffListener<Integer> listener2) {
        if (separatorText == null) {
            SplitterWithSecondHideable.$$$reportNull$$$0(0);
        }
        if (firstComponent == null) {
            SplitterWithSecondHideable.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            SplitterWithSecondHideable.$$$reportNull$$$0(2);
        }
        this.myListener = listener2;
        this.myFictivePanel = JBUI.Panels.simplePanel();
        this.myTitledSeparator = new MyTitledSeparator(separatorText, vertical);
        this.mySplitter = new MySplitter(vertical);
        this.mySplitter.setDoubleBuffered(true);
        this.mySplitter.setFirstComponent(firstComponent);
        this.mySplitter.setSecondComponent((JComponent)this.myFictivePanel);
        this.mySplitter.setProportion(1.0f);
    }

    public void setText(String value) {
        this.myTitledSeparator.setText(value);
    }

    @NotNull
    public Splitter getComponent() {
        PseudoSplitter pseudoSplitter = this.mySplitter;
        if (pseudoSplitter == null) {
            SplitterWithSecondHideable.$$$reportNull$$$0(3);
        }
        return pseudoSplitter;
    }

    protected abstract RefreshablePanel createDetails();

    protected abstract float getSplitterInitialProportion();

    public float getUsedProportion() {
        return this.isOn() ? this.mySplitter.getProportion() : this.myPreviousProportion;
    }

    public void initOn() {
        this.myTitledSeparator.initOn();
    }

    public void on() {
        this.myTitledSeparator.on();
    }

    public void off() {
        this.myTitledSeparator.off();
    }

    public boolean isOn() {
        return this.myTitledSeparator.myOn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separatorText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/SplitterWithSecondHideable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/SplitterWithSecondHideable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MySplitter
    extends PseudoSplitter {
        @NotNull
        private final MouseEventHandler myMouseListener;

        public MySplitter(boolean vertical) {
            super(vertical);
            this.myMouseListener = new MouseEventHandler(){

                public void mouseEntered(MouseEvent event) {
                    ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.setCursor(new Cursor(SplitterWithSecondHideable.this.isOn() ? 9 : 0));
                    super.mouseEntered(event);
                }

                public void mouseExited(MouseEvent event) {
                    ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.setCursor(new Cursor(0));
                    super.mouseExited(event);
                }

                protected void handle(MouseEvent event) {
                    if (event.getID() == 506 || event.getID() == 503) {
                        ((MyDivider)MySplitter.this.myDivider).processMouseMotionEvent(event);
                    } else {
                        ((MyDivider)MySplitter.this.myDivider).processMouseEvent(event);
                    }
                }
            };
            ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.addMouseListener((MouseListener)this.myMouseListener);
            ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.addMouseMotionListener((MouseMotionListener)this.myMouseListener);
        }

        protected Divider createDivider() {
            MyDivider divider = new MyDivider();
            divider.add(SplitterWithSecondHideable.this.myTitledSeparator, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
            return divider;
        }

        public int getDividerWidth() {
            return this.isVertical() ? SplitterWithSecondHideable.this.myTitledSeparator.getHeight() : SplitterWithSecondHideable.this.myTitledSeparator.getWidth();
        }

        private class MyDivider
        extends Splitter.DividerImpl {
            private MyDivider() {
                super((Splitter)MySplitter.this);
            }

            public void processMouseMotionEvent(MouseEvent e) {
                super.processMouseMotionEvent(e);
            }

            public void processMouseEvent(MouseEvent e) {
                super.processMouseEvent(e);
            }
        }
    }

    private class MyTitledSeparator
    extends AbstractTitledSeparatorWithIcon {
        public MyTitledSeparator(String separatorText, boolean vertical) {
            if (separatorText == null) {
                MyTitledSeparator.$$$reportNull$$$0(0);
            }
            super(AllIcons.General.ComboArrowRight, vertical ? AllIcons.General.ComboArrowDown : AllIcons.General.ComboArrowRightPassive, separatorText);
        }

        @Override
        protected RefreshablePanel createPanel() {
            return SplitterWithSecondHideable.this.createDetails();
        }

        @Override
        protected void initOnImpl() {
            float proportion = SplitterWithSecondHideable.this.myPreviousProportion > 0.0f ? SplitterWithSecondHideable.this.myPreviousProportion : SplitterWithSecondHideable.this.getSplitterInitialProportion();
            SplitterWithSecondHideable.this.mySplitter.setSecondComponent((JComponent)this.myDetailsComponent.getPanel());
            SplitterWithSecondHideable.this.mySplitter.setResizeEnabled(true);
            SwingUtilities.invokeLater(() -> {
                SplitterWithSecondHideable.this.mySplitter.fixFirst(proportion);
                SplitterWithSecondHideable.this.mySplitter.invalidate();
                SplitterWithSecondHideable.this.mySplitter.validate();
                SplitterWithSecondHideable.this.mySplitter.repaint();
            });
        }

        @Override
        protected void onImpl() {
            float proportion = SplitterWithSecondHideable.this.myPreviousProportion > 0.0f ? SplitterWithSecondHideable.this.myPreviousProportion : SplitterWithSecondHideable.this.getSplitterInitialProportion();
            int firstSize = SplitterWithSecondHideable.this.mySplitter.isVertical() ? SplitterWithSecondHideable.this.mySplitter.getFirstComponent().getHeight() : SplitterWithSecondHideable.this.mySplitter.getFirstComponent().getWidth();
            SplitterWithSecondHideable.this.mySplitter.fixFirst();
            SplitterWithSecondHideable.this.myListener.on((int)((1.0f - proportion) * (float)firstSize / proportion));
            SplitterWithSecondHideable.this.mySplitter.setSecondComponent((JComponent)this.myDetailsComponent.getPanel());
            SplitterWithSecondHideable.this.mySplitter.revalidate();
            SplitterWithSecondHideable.this.mySplitter.repaint();
            SplitterWithSecondHideable.this.mySplitter.setResizeEnabled(true);
        }

        @Override
        protected void offImpl() {
            int previousSize = SplitterWithSecondHideable.this.mySplitter.isVertical() ? SplitterWithSecondHideable.this.mySplitter.getSecondComponent().getHeight() : SplitterWithSecondHideable.this.mySplitter.getSecondComponent().getWidth();
            SplitterWithSecondHideable.this.mySplitter.setSecondComponent((JComponent)SplitterWithSecondHideable.this.myFictivePanel);
            SplitterWithSecondHideable.this.myPreviousProportion = SplitterWithSecondHideable.this.mySplitter.getProportion();
            SplitterWithSecondHideable.this.mySplitter.freeAll();
            SplitterWithSecondHideable.this.mySplitter.setProportion(1.0f);
            SplitterWithSecondHideable.this.mySplitter.revalidate();
            SplitterWithSecondHideable.this.mySplitter.repaint();
            SplitterWithSecondHideable.this.myListener.off(previousSize);
            SplitterWithSecondHideable.this.mySplitter.setResizeEnabled(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorText", "com/intellij/ui/SplitterWithSecondHideable$MyTitledSeparator", "<init>"));
        }
    }

    public static interface OnOffListener<T> {
        public void on(T var1);

        public void off(T var1);
    }
}

