/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.jediterm.terminal.TerminalDataStream;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;

public class AppendableTerminalDataStream
implements TerminalDataStream,
Appendable {
    private LinkedBlockingDeque<Character> myQueue = new LinkedBlockingDeque(10000000);

    public char getChar() throws IOException {
        try {
            return this.myQueue.take().charValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void pushChar(char c) throws IOException {
        this.myQueue.push(Character.valueOf(c));
    }

    public String readNonControlCharacters(int maxLength) throws IOException {
        Character c;
        StringBuilder sb = new StringBuilder();
        while (sb.length() < maxLength && (c = this.myQueue.peek()) != null && c.charValue() >= ' ') {
            sb.append(this.myQueue.poll());
        }
        return sb.toString();
    }

    public void pushBackBuffer(char[] chars, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.myQueue.addFirst(Character.valueOf(chars[length - i - i]));
        }
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        for (int i = 0; i < csq.length(); ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        try {
            this.myQueue.put(Character.valueOf(c));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return this;
    }
}

