/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.state;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.spellchecker.dictionary.AggregatedDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.spellchecker.state.CachedDictionaryState;
import com.intellij.spellchecker.state.DictionaryStateListener;
import com.intellij.spellchecker.state.ProjectDictionaryState;
import org.jetbrains.annotations.NotNull;

public class AggregatedDictionaryState {
    private AggregatedDictionary dictionary;
    private final ProjectDictionaryState myProjectDictionaryState;

    public AggregatedDictionaryState(@NotNull Project project) {
        if (project == null) {
            AggregatedDictionaryState.$$$reportNull$$$0(0);
        }
        CachedDictionaryState cachedDictionaryState = (CachedDictionaryState)ServiceManager.getService(CachedDictionaryState.class);
        this.myProjectDictionaryState = (ProjectDictionaryState)ServiceManager.getService((Project)project, ProjectDictionaryState.class);
        String currentUser = System.getProperty("user.name");
        ProjectDictionary projectDictionary = this.myProjectDictionaryState.getProjectDictionary();
        projectDictionary.setActiveName(currentUser);
        if (cachedDictionaryState.getDictionary() == null) {
            cachedDictionaryState.setDictionary(new UserDictionary("cached"));
        }
        this.dictionary = new AggregatedDictionary(projectDictionary, cachedDictionaryState.getDictionary());
        cachedDictionaryState.setDictionary(this.dictionary.getCachedDictionary());
        this.myProjectDictionaryState.setProjectDictionary(this.dictionary.getProjectDictionary());
        this.myProjectDictionaryState.addProjectDictListener(dict -> this.getDictionary().replaceAll(dict.getWords()));
    }

    @NotNull
    public AggregatedDictionary getDictionary() {
        AggregatedDictionary aggregatedDictionary = this.dictionary;
        if (aggregatedDictionary == null) {
            AggregatedDictionaryState.$$$reportNull$$$0(1);
        }
        return aggregatedDictionary;
    }

    public String toString() {
        return "AggregatedDictionaryState{dictionary=" + this.dictionary + '}';
    }

    public void addDictStateListener(DictionaryStateListener listener2) {
        this.myProjectDictionaryState.addProjectDictListener(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/state/AggregatedDictionaryState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/state/AggregatedDictionaryState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDictionary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

