/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SemanticEditorPosition {
    private final EditorEx myEditor;
    private final HighlighterIterator myIterator;
    private final CharSequence myChars;

    public SemanticEditorPosition(@NotNull EditorEx editor, int offset) {
        if (editor == null) {
            SemanticEditorPosition.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        this.myChars = editor.getDocument().getCharsSequence();
        this.myIterator = editor.getHighlighter().createIterator(offset);
    }

    public SemanticEditorPosition beforeOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(1);
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.retreat();
        }
        return this;
    }

    public SemanticEditorPosition beforeOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(2);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.retreat();
        }
        return this;
    }

    public SemanticEditorPosition afterOptionalMix(SyntaxElement ... elements) {
        if (elements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(3);
        }
        while (this.isAtAnyOf(elements)) {
            this.myIterator.advance();
        }
        return this;
    }

    public boolean isAtMultiline() {
        if (!this.myIterator.atEnd()) {
            return CharArrayUtil.containLineBreaks((CharSequence)this.myChars, (int)this.myIterator.getStart(), (int)this.myIterator.getEnd());
        }
        return false;
    }

    public SemanticEditorPosition before() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.retreat();
        }
        return this;
    }

    public SemanticEditorPosition afterOptional(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(4);
        }
        if (!this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()))) {
            this.myIterator.advance();
        }
        return this;
    }

    public SemanticEditorPosition after() {
        if (!this.myIterator.atEnd()) {
            this.myIterator.advance();
        }
        return this;
    }

    public SemanticEditorPosition beforeParentheses(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(5);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(6);
        }
        int parenLevel = 0;
        while (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            this.myIterator.retreat();
            if (rightParenthesis.equals(currElement)) {
                ++parenLevel;
                continue;
            }
            if (!leftParenthesis.equals(currElement) || --parenLevel >= 1) continue;
            break;
        }
        return this;
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(7);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(8);
        }
        return this.findLeftParenthesisBackwardsSkippingNested(leftParenthesis, rightParenthesis, (Condition<SyntaxElement>)Conditions.alwaysFalse());
    }

    public SemanticEditorPosition findLeftParenthesisBackwardsSkippingNested(@NotNull SyntaxElement leftParenthesis, @NotNull SyntaxElement rightParenthesis, @NotNull Condition<SyntaxElement> terminationCondition) {
        if (leftParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(9);
        }
        if (rightParenthesis == null) {
            SemanticEditorPosition.$$$reportNull$$$0(10);
        }
        if (terminationCondition == null) {
            SemanticEditorPosition.$$$reportNull$$$0(11);
        }
        while (!this.myIterator.atEnd() && !terminationCondition.value((Object)this.map(this.myIterator.getTokenType()))) {
            if (rightParenthesis.equals(this.map(this.myIterator.getTokenType()))) {
                this.beforeParentheses(leftParenthesis, rightParenthesis);
            } else if (leftParenthesis.equals(this.map(this.myIterator.getTokenType()))) break;
            this.myIterator.retreat();
        }
        return this;
    }

    public boolean isAfterOnSameLine(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(12);
        }
        this.myIterator.retreat();
        while (!this.myIterator.atEnd() && !this.isAtMultiline()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
            this.myIterator.retreat();
        }
        return false;
    }

    public boolean isAt(@NotNull SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            SemanticEditorPosition.$$$reportNull$$$0(13);
        }
        return !this.myIterator.atEnd() && syntaxElement.equals(this.map(this.myIterator.getTokenType()));
    }

    public boolean isAt(@NotNull IElementType elementType) {
        if (elementType == null) {
            SemanticEditorPosition.$$$reportNull$$$0(14);
        }
        return !this.myIterator.atEnd() && this.myIterator.getTokenType() == elementType;
    }

    public boolean isAtEnd() {
        return this.myIterator.atEnd();
    }

    public int getStartOffset() {
        return this.myIterator.getStart();
    }

    public boolean isAtAnyOf(SyntaxElement ... syntaxElements) {
        if (syntaxElements == null) {
            SemanticEditorPosition.$$$reportNull$$$0(15);
        }
        if (!this.myIterator.atEnd()) {
            SyntaxElement currElement = this.map(this.myIterator.getTokenType());
            for (SyntaxElement element : syntaxElements) {
                if (!element.equals(currElement)) continue;
                return true;
            }
        }
        return false;
    }

    public CharSequence getChars() {
        return this.myChars;
    }

    public int findStartOf(@NotNull SyntaxElement element) {
        if (element == null) {
            SemanticEditorPosition.$$$reportNull$$$0(16);
        }
        while (!this.myIterator.atEnd()) {
            if (element.equals(this.map(this.myIterator.getTokenType()))) {
                return this.myIterator.getStart();
            }
            this.myIterator.retreat();
        }
        return -1;
    }

    public boolean hasEmptyLineAfter(int offset) {
        for (int i = offset + 1; i < this.myIterator.getEnd(); ++i) {
            if (this.myChars.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    public EditorEx getEditor() {
        return this.myEditor;
    }

    @Nullable
    public Language getLanguage() {
        return !this.myIterator.atEnd() ? this.myIterator.getTokenType().getLanguage() : null;
    }

    public boolean isAtLanguage(@Nullable Language language) {
        if (language != null && !this.myIterator.atEnd()) {
            return language == Language.ANY || this.myIterator.getTokenType().getLanguage().is(language);
        }
        return false;
    }

    @Nullable
    public SyntaxElement getCurrElement() {
        return !this.myIterator.atEnd() ? this.map(this.myIterator.getTokenType()) : null;
    }

    public boolean matchesRule(@NotNull Rule rule) {
        if (rule == null) {
            SemanticEditorPosition.$$$reportNull$$$0(17);
        }
        return rule.check(this);
    }

    public abstract SyntaxElement map(@NotNull IElementType var1);

    public String toString() {
        return this.myIterator.getTokenType().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftParenthesis";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightParenthesis";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminationCondition";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/SemanticEditorPosition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeOptional";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeOptionalMix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "afterOptionalMix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "afterOptional";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeParentheses";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findLeftParenthesisBackwardsSkippingNested";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterOnSameLine";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isAt";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isAtAnyOf";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findStartOf";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "matchesRule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Rule {
        public boolean check(SemanticEditorPosition var1);
    }

    public static interface SyntaxElement {
    }
}

