/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="DependencyValidationManager", storages={@Storage(value="scopes", stateSplitter=ScopesStateSplitter.class)})
public class DependencyValidationManagerImpl
extends DependencyValidationManager {
    private static final NotNullLazyValue<Icon> ourSharedScopeIcon = new NotNullLazyValue<Icon>(){

        @NotNull
        protected Icon compute() {
            LayeredIcon layeredIcon = new LayeredIcon(new Icon[]{AllIcons.Ide.LocalScope, AllIcons.Nodes.Shared});
            if (layeredIcon == null) {
                1.$$$reportNull$$$0(0);
            }
            return layeredIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/DependencyValidationManagerImpl$1", "compute"));
        }
    };
    private State myState = new State();
    private final NamedScopeManager myNamedScopeManager;
    private boolean mySkipImportStatements;
    private boolean mySkipImportStatementsWasSpecified;
    @NonNls
    private static final String DENY_RULE_KEY = "deny_rule";
    @NonNls
    private static final String FROM_SCOPE_KEY = "from_scope";
    @NonNls
    private static final String TO_SCOPE_KEY = "to_scope";
    @NonNls
    private static final String IS_DENY_KEY = "is_deny";
    @NonNls
    private static final String UNNAMED_SCOPE = "unnamed_scope";
    @NonNls
    private static final String VALUE = "value";
    private final List<Pair<NamedScope, NamedScopesHolder>> myScopePairs = ContainerUtil.createLockFreeCopyOnWriteList();

    public DependencyValidationManagerImpl(Project project, NamedScopeManager namedScopeManager) {
        super(project);
        this.myNamedScopeManager = namedScopeManager;
        namedScopeManager.addScopeListener(new NamedScopesHolder.ScopeListener(){

            public void scopesChanged() {
                DependencyValidationManagerImpl.this.reloadScopes();
            }
        });
    }

    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        CustomScopesProvider[] scopesProviders;
        ArrayList<NamedScope> predefinedScopes = new ArrayList<NamedScope>();
        for (CustomScopesProvider scopesProvider : scopesProviders = (CustomScopesProvider[])CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions((AreaInstance)this.myProject)) {
            predefinedScopes.addAll(scopesProvider.getFilteredScopes());
        }
        ArrayList<NamedScope> arrayList = predefinedScopes;
        if (arrayList == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public NamedScope getPredefinedScope(@NotNull String name) {
        CustomScopesProvider[] scopesProviders;
        if (name == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(1);
        }
        for (CustomScopesProvider scopesProvider : scopesProviders = (CustomScopesProvider[])CustomScopesProvider.CUSTOM_SCOPES_PROVIDER.getExtensions((AreaInstance)this.myProject)) {
            NamedScope scope;
            NamedScope namedScope = scope = scopesProvider instanceof CustomScopesProviderEx ? ((CustomScopesProviderEx)scopesProvider).getCustomScope(name) : CustomScopesProviderEx.findPredefinedScope((String)name, (List)scopesProvider.getFilteredScopes());
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    public boolean hasRules() {
        return !this.myState.rules.isEmpty();
    }

    @Nullable
    public DependencyRule getViolatorDependencyRule(@NotNull PsiFile from, @NotNull PsiFile to) {
        if (from == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(2);
        }
        if (to == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(3);
        }
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            return dependencyRule;
        }
        return null;
    }

    @NotNull
    public DependencyRule[] getViolatorDependencyRules(@NotNull PsiFile from, @NotNull PsiFile to) {
        if (from == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(4);
        }
        if (to == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(5);
        }
        ArrayList<DependencyRule> result2 = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isForbiddenToUse(from, to)) continue;
            result2.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result2.toArray(new DependencyRule[result2.size()]);
        if (dependencyRuleArray == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(6);
        }
        return dependencyRuleArray;
    }

    @NotNull
    public DependencyRule[] getApplicableRules(@NotNull PsiFile file2) {
        if (file2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(7);
        }
        ArrayList<DependencyRule> result2 = new ArrayList<DependencyRule>();
        for (DependencyRule dependencyRule : this.myState.rules) {
            if (!dependencyRule.isApplicable(file2)) continue;
            result2.add(dependencyRule);
        }
        DependencyRule[] dependencyRuleArray = result2.toArray(new DependencyRule[result2.size()]);
        if (dependencyRuleArray == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(8);
        }
        return dependencyRuleArray;
    }

    public boolean skipImportStatements() {
        return this.mySkipImportStatements;
    }

    public void setSkipImportStatements(boolean skip) {
        this.mySkipImportStatements = skip;
    }

    @NotNull
    public Map<String, PackageSet> getUnnamedScopes() {
        Map map2 = this.myState.unnamedScopes;
        if (map2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @NotNull
    public DependencyRule[] getAllRules() {
        List rules = this.myState.rules;
        DependencyRule[] dependencyRuleArray = rules.toArray(new DependencyRule[rules.size()]);
        if (dependencyRuleArray == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(10);
        }
        return dependencyRuleArray;
    }

    public void removeAllRules() {
        this.myState.rules.clear();
    }

    private void addRule(@NotNull DependencyRule rule, @NotNull State state2) {
        if (rule == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(11);
        }
        if (state2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(12);
        }
        this.appendUnnamedScope(rule.getFromScope(), state2);
        this.appendUnnamedScope(rule.getToScope(), state2);
        state2.rules.add(rule);
    }

    public void addRule(@NotNull DependencyRule rule) {
        if (rule == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(13);
        }
        this.addRule(rule, this.myState);
    }

    private void appendUnnamedScope(@NotNull NamedScope fromScope, @NotNull State state2) {
        PackageSet packageSet;
        if (fromScope == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(14);
        }
        if (state2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(15);
        }
        if (this.getScope(fromScope.getName()) == null && (packageSet = fromScope.getValue()) != null && !state2.unnamedScopes.containsKey(packageSet.getText())) {
            state2.unnamedScopes.put(packageSet.getText(), packageSet);
        }
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"shared.scopes.node.text", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return (Icon)ourSharedScopeIcon.getValue();
    }

    public void loadState(Element element) {
        Element option = element.getChild("option");
        if (option != null && "SKIP_IMPORT_STATEMENTS".equals(option.getAttributeValue("name"))) {
            this.mySkipImportStatementsWasSpecified = !this.myProject.isDefault();
            this.mySkipImportStatements = Boolean.parseBoolean(option.getAttributeValue(VALUE));
        }
        super.loadState(element);
        NamedScope[] scopes = this.getEditableScopes();
        Arrays.sort(scopes, (s1, s2) -> {
            int i2;
            String name2;
            String name1 = s1.getName();
            if (Comparing.equal((String)name1, (String)(name2 = s2.getName()))) {
                return 0;
            }
            List order = this.myNamedScopeManager.myOrderState.myOrder;
            int i1 = order.indexOf(name1);
            return i1 > (i2 = order.indexOf(name2)) ? 1 : -1;
        });
        super.setScopes(scopes);
        State state2 = new State();
        PackageSetFactory packageSetFactory = PackageSetFactory.getInstance();
        for (Element unnamedScope : element.getChildren(UNNAMED_SCOPE)) {
            try {
                String packageSet = unnamedScope.getAttributeValue(VALUE);
                state2.unnamedScopes.put(packageSet, packageSetFactory.compile(packageSet));
            }
            catch (ParsingException parsingException) {}
        }
        this.readRules(element, state2);
        this.myState = state2;
    }

    private void readRules(@NotNull Element element, State state2) {
        if (element == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(16);
        }
        for (Element rule1 : element.getChildren(DENY_RULE_KEY)) {
            DependencyRule rule = this.readRule(rule1);
            if (rule == null) continue;
            this.addRule(rule, state2);
        }
    }

    public Element getState() {
        State state2;
        Element element = super.getState();
        assert (element != null);
        if (this.mySkipImportStatements || this.mySkipImportStatementsWasSpecified) {
            element.addContent(new Element("option").setAttribute("name", "SKIP_IMPORT_STATEMENTS").setAttribute(VALUE, Boolean.toString(this.mySkipImportStatements)));
        }
        if (!(state2 = this.myState).unnamedScopes.isEmpty()) {
            Object[] unnamedScopes = state2.unnamedScopes.keySet().toArray(new String[state2.unnamedScopes.size()]);
            Arrays.sort(unnamedScopes);
            for (Object unnamedScope : unnamedScopes) {
                element.addContent(new Element(UNNAMED_SCOPE).setAttribute(VALUE, (String)unnamedScope));
            }
        }
        DependencyValidationManagerImpl.writeRules(element, state2);
        return element;
    }

    private static void writeRules(@NotNull Element element, @NotNull State state2) {
        if (element == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(17);
        }
        if (state2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(18);
        }
        for (DependencyRule rule : state2.rules) {
            Element ruleElement = DependencyValidationManagerImpl.writeRule(rule);
            if (ruleElement == null) continue;
            element.addContent(ruleElement);
        }
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        return this.getScope(name, this.myState);
    }

    private NamedScope getScope(@Nullable String name, @NotNull State state2) {
        PackageSet packageSet;
        NamedScope scope;
        if (state2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(19);
        }
        if ((scope = super.getScope(name)) == null && (packageSet = (PackageSet)state2.unnamedScopes.get(name)) != null) {
            return new NamedScope.UnnamedScope(packageSet);
        }
        if (scope == null && Comparing.strEqual((String)name, (String)"Project")) {
            return super.getScope("All");
        }
        return scope;
    }

    @Nullable
    private static Element writeRule(DependencyRule rule) {
        NamedScope fromScope = rule.getFromScope();
        NamedScope toScope = rule.getToScope();
        if (fromScope == null || toScope == null) {
            return null;
        }
        Element ruleElement = new Element(DENY_RULE_KEY);
        ruleElement.setAttribute(FROM_SCOPE_KEY, fromScope.getName());
        ruleElement.setAttribute(TO_SCOPE_KEY, toScope.getName());
        ruleElement.setAttribute(IS_DENY_KEY, Boolean.valueOf(rule.isDenyRule()).toString());
        return ruleElement;
    }

    @Nullable
    private DependencyRule readRule(@NotNull Element ruleElement) {
        if (ruleElement == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(20);
        }
        String fromScope = ruleElement.getAttributeValue(FROM_SCOPE_KEY);
        String toScope = ruleElement.getAttributeValue(TO_SCOPE_KEY);
        String denyRule = ruleElement.getAttributeValue(IS_DENY_KEY);
        if (fromScope == null || toScope == null || denyRule == null) {
            return null;
        }
        NamedScope fromNamedScope = this.getScope(fromScope);
        NamedScope toNamedScope = this.getScope(toScope);
        if (fromNamedScope == null || toNamedScope == null) {
            return null;
        }
        return new DependencyRule(fromNamedScope, toNamedScope, Boolean.valueOf(denyRule).booleanValue());
    }

    private void reloadScopes() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            ArrayList<Pair<NamedScope, NamedScopesHolder>> scopeList = new ArrayList<Pair<NamedScope, NamedScopesHolder>>();
            DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)this);
            DependencyValidationManagerImpl.addScopesToList(scopeList, (NamedScopesHolder)this.myNamedScopeManager);
            this.myScopePairs.clear();
            this.myScopePairs.addAll(scopeList);
            Element element = new Element("rules_2_reload");
            DependencyValidationManagerImpl.writeRules(element, this.myState);
            State state2 = new State();
            this.readRules(element, state2);
            this.myState = state2;
        });
    }

    private static void addScopesToList(@NotNull List<Pair<NamedScope, NamedScopesHolder>> scopeList, @NotNull NamedScopesHolder holder) {
        if (scopeList == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(21);
        }
        if (holder == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(22);
        }
        for (NamedScope scope : holder.getScopes()) {
            scopeList.add((Pair<NamedScope, NamedScopesHolder>)Pair.create((Object)scope, (Object)holder));
        }
    }

    @NotNull
    public List<Pair<NamedScope, NamedScopesHolder>> getScopeBasedHighlightingCachedScopes() {
        List<Pair<NamedScope, NamedScopesHolder>> list2 = this.myScopePairs;
        if (list2 == null) {
            DependencyValidationManagerImpl.$$$reportNull$$$0(23);
        }
        return list2;
    }

    public void fireScopeListeners() {
        super.fireScopeListeners();
        this.reloadScopes();
    }

    public void setScopes(NamedScope[] scopes) {
        super.setScopes(scopes);
        List order = this.myNamedScopeManager.myOrderState.myOrder;
        order.clear();
        for (NamedScope scope : scopes) {
            order.add(scope.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/DependencyValidationManagerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromScope";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeList";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedScopes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/DependencyValidationManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getViolatorDependencyRules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableRules";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnnamedScopes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRules";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeBasedHighlightingCachedScopes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getViolatorDependencyRule";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getViolatorDependencyRules";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableRules";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "appendUnnamedScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readRules";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "writeRules";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readRule";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addScopesToList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ScopesStateSplitter
    extends MainConfigurationStateSplitter {
        ScopesStateSplitter() {
        }

        @NotNull
        protected String getSubStateFileName(@NotNull Element element) {
            if (element == null) {
                ScopesStateSplitter.$$$reportNull$$$0(0);
            }
            String string = element.getAttributeValue("name");
            if (string == null) {
                ScopesStateSplitter.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        protected String getComponentStateFileName() {
            if ("scope_settings" == null) {
                ScopesStateSplitter.$$$reportNull$$$0(2);
            }
            return "scope_settings";
        }

        @NotNull
        protected String getSubStateTagName() {
            if ("scope" == null) {
                ScopesStateSplitter.$$$reportNull$$$0(3);
            }
            return "scope";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/packageDependencies/DependencyValidationManagerImpl$ScopesStateSplitter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubStateFileName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponentStateFileName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubStateTagName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubStateFileName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class State {
        private final List<DependencyRule> rules = new ArrayList<DependencyRule>();
        private final Map<String, PackageSet> unnamedScopes = new THashMap();

        private State() {
        }
    }
}

