/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.AppTopics;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.LineSeparator;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineSeparatorPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    @NotNull
    private final TextPanel myComponent;
    private boolean myActionEnabled;

    public LineSeparatorPanel(@NotNull Project project) {
        if (project == null) {
            LineSeparatorPanel.$$$reportNull$$$0(0);
        }
        super(project);
        this.myComponent = new TextPanel.ExtraSize(){

            @Override
            protected void paintComponent(@NotNull Graphics g) {
                if (g == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.paintComponent(g);
                if (LineSeparatorPanel.this.myActionEnabled && this.getText() != null) {
                    Rectangle r = this.getBounds();
                    Insets insets = this.getInsets();
                    Icon arrows = AllIcons.Ide.Statusbar_arrows;
                    arrows.paintIcon(this, g, r.width - insets.right - arrows.getIconWidth() - 2, r.height / 2 - arrows.getIconHeight() / 2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel$1", "paintComponent"));
            }
        };
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                LineSeparatorPanel.this.update();
                LineSeparatorPanel.this.showPopup(e);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel$2", "onClick"));
            }
        }.installOn((Component)this.myComponent);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    private void update() {
        UIUtil.invokeLaterIfNeeded(() -> {
            String toDoComment;
            VirtualFile file2 = this.getSelectedFile();
            this.myActionEnabled = false;
            String lineSeparator = null;
            String toolTipText = null;
            String panelText = null;
            if (file2 != null) {
                this.myActionEnabled = file2.isWritable();
                lineSeparator = LoadTextUtil.detectLineSeparator(file2, true);
                if (lineSeparator != null) {
                    toolTipText = String.format("Line separator: %s", StringUtil.escapeLineBreak((String)lineSeparator));
                    panelText = LineSeparator.fromString((String)lineSeparator).toString();
                }
            }
            if (lineSeparator == null) {
                toolTipText = "No line separator";
                panelText = file2 != null ? "n/a" : "";
                this.myActionEnabled = false;
            }
            this.myComponent.resetColor();
            if (this.myActionEnabled) {
                toDoComment = "Click to change";
                this.myComponent.setForeground(UIUtil.getActiveTextColor());
                this.myComponent.setTextAlignment(0.0f);
            } else {
                toDoComment = "";
                this.myComponent.setForeground(UIUtil.getInactiveTextColor());
                this.myComponent.setTextAlignment(0.5f);
            }
            this.myComponent.setToolTipText(String.format("%s%n%s", toolTipText, toDoComment));
            this.myComponent.setText(panelText);
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        });
    }

    private void showPopup(MouseEvent e) {
        if (!this.myActionEnabled) {
            return;
        }
        DataContext dataContext = this.getContext();
        AnAction group = ActionManager.getInstance().getAction("ChangeLineSeparators");
        if (!(group instanceof ActionGroup)) {
            return;
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("Line Separator", (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        Dimension dimension = popup2.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup2.show(new RelativePoint(e.getComponent(), at));
        Disposer.register((Disposable)this, (Disposable)popup2);
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            LineSeparatorPanel.$$$reportNull$$$0(1);
        }
        super.install(statusBar);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    3.$$$reportNull$$$0(1);
                }
                LineSeparatorPanel.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/wm/impl/status/LineSeparatorPanel$3";
                objectArray[2] = "fileContentReloaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private DataContext getContext() {
        Editor editor = this.getEditor();
        DataContext parent = DataManager.getInstance().getDataContext((Component)this.myStatusBar);
        DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName(), new VirtualFile[]{this.getSelectedFile()}, SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), this.getProject(), SimpleDataContext.getSimpleContext(PlatformDataKeys.CONTEXT_COMPONENT.getName(), editor == null ? null : editor.getComponent(), parent)));
        if (dataContext == null) {
            LineSeparatorPanel.$$$reportNull$$$0(2);
        }
        return dataContext;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public StatusBarWidget copy() {
        return new LineSeparatorPanel(this.getProject());
    }

    @NotNull
    public String ID() {
        if ("LineSeparator" == null) {
            LineSeparatorPanel.$$$reportNull$$$0(3);
        }
        return "LineSeparator";
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            LineSeparatorPanel.$$$reportNull$$$0(4);
        }
        return null;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            LineSeparatorPanel.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            LineSeparatorPanel.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            LineSeparatorPanel.$$$reportNull$$$0(7);
        }
        this.update();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/LineSeparatorPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/LineSeparatorPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

