/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsFileStatusProvider
implements FileStatusProvider,
VcsBaseContentProvider {
    private final Project myProject;
    private final FileStatusManagerImpl myFileStatusManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final VcsConfiguration myConfiguration;
    private final VcsBaseContentProvider[] myAdditionalProviders;
    private boolean myHaveEmptyContentRevisions;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsFileStatusProvider");

    public VcsFileStatusProvider(Project project, FileStatusManagerImpl fileStatusManager, ProjectLevelVcsManager vcsManager, ChangeListManager changeListManager, VcsDirtyScopeManager dirtyScopeManager, VcsConfiguration configuration) {
        this.myProject = project;
        this.myFileStatusManager = fileStatusManager;
        this.myVcsManager = vcsManager;
        this.myChangeListManager = changeListManager;
        this.myDirtyScopeManager = dirtyScopeManager;
        this.myConfiguration = configuration;
        this.myHaveEmptyContentRevisions = true;
        this.myFileStatusManager.setFileStatusProvider(this);
        this.myAdditionalProviders = (VcsBaseContentProvider[])VcsBaseContentProvider.EP_NAME.getExtensions((AreaInstance)project);
        changeListManager.addChangeListListener((ChangeListListener)new ChangeListAdapter(){

            public void changeListAdded(ChangeList list2) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListRemoved(ChangeList list2) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListChanged(ChangeList list2) {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }

            public void changeListUpdateDone() {
                if (VcsFileStatusProvider.this.myHaveEmptyContentRevisions) {
                    VcsFileStatusProvider.this.myHaveEmptyContentRevisions = false;
                    VcsFileStatusProvider.this.fileStatusesChanged();
                }
            }

            public void unchangedFileStatusChanged() {
                VcsFileStatusProvider.this.fileStatusesChanged();
            }
        });
    }

    private void fileStatusesChanged() {
        this.myFileStatusManager.fileStatusesChanged();
    }

    @Override
    @NotNull
    public FileStatus getFileStatus(@NotNull VirtualFile virtualFile) {
        AbstractVcs vcs;
        if (virtualFile == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(0);
        }
        if ((vcs = this.myVcsManager.getVcsFor(virtualFile)) == null) {
            if (ScratchUtil.isScratch(virtualFile)) {
                FileStatus fileStatus = FileStatus.SUPPRESSED;
                if (fileStatus == null) {
                    VcsFileStatusProvider.$$$reportNull$$$0(1);
                }
                return fileStatus;
            }
            FileStatus fileStatus = FileStatusManagerImpl.getDefaultStatus(virtualFile);
            if (fileStatus == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(2);
            }
            return fileStatus;
        }
        FileStatus status = this.myChangeListManager.getStatus(virtualFile);
        if (status == FileStatus.NOT_CHANGED && VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }
        if (status == FileStatus.NOT_CHANGED) {
            FileStatus fileStatus = FileStatusManagerImpl.getDefaultStatus(virtualFile);
            if (fileStatus == null) {
                VcsFileStatusProvider.$$$reportNull$$$0(4);
            }
            return fileStatus;
        }
        FileStatus fileStatus = status;
        if (fileStatus == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(5);
        }
        return fileStatus;
    }

    private static boolean isDocumentModified(VirtualFile virtualFile) {
        if (virtualFile.isDirectory()) {
            return false;
        }
        return FileDocumentManager.getInstance().isFileModified(virtualFile);
    }

    @Override
    public void refreshFileStatusFromDocument(@NotNull VirtualFile virtualFile, @NotNull Document doc) {
        FileStatus cachedStatus;
        if (virtualFile == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(6);
        }
        if (doc == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(7);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("refreshFileStatusFromDocument: file.getModificationStamp()=" + virtualFile.getModificationStamp() + ", document.getModificationStamp()=" + doc.getModificationStamp());
        }
        if ((cachedStatus = this.myFileStatusManager.getCachedStatus(virtualFile)) == null || cachedStatus == FileStatus.NOT_CHANGED || !VcsFileStatusProvider.isDocumentModified(virtualFile)) {
            RollbackEnvironment rollbackEnvironment;
            AbstractVcs vcs = this.myVcsManager.getVcsFor(virtualFile);
            if (vcs == null) {
                return;
            }
            if (cachedStatus == FileStatus.MODIFIED && !VcsFileStatusProvider.isDocumentModified(virtualFile) && !((ReadonlyStatusHandlerImpl)ReadonlyStatusHandlerImpl.getInstance((Project)this.myProject)).getState().SHOW_DIALOG && (rollbackEnvironment = vcs.getRollbackEnvironment()) != null) {
                rollbackEnvironment.rollbackIfUnchanged(virtualFile);
            }
            this.myFileStatusManager.fileStatusChanged(virtualFile);
            ChangeProvider cp = vcs.getChangeProvider();
            if (cp != null && cp.isModifiedDocumentTrackingRequired()) {
                this.myDirtyScopeManager.fileDirty(virtualFile);
            }
        }
    }

    @Override
    @NotNull
    public ThreeState getNotChangedDirectoryParentingStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(8);
        }
        ThreeState threeState = this.myConfiguration.SHOW_DIRTY_RECURSIVELY ? this.myChangeListManager.haveChangesUnder(virtualFile) : ThreeState.NO;
        if (threeState == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(9);
        }
        return threeState;
    }

    @Override
    @Nullable
    public VcsBaseContentProvider.BaseContent getBaseRevision(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(10);
        }
        if (!this.isHandledByVcs(file2)) {
            VcsBaseContentProvider provider = this.findProviderFor(file2);
            return provider == null ? null : provider.getBaseRevision(file2);
        }
        Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(file2);
        if (change == null) {
            return null;
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision == null) {
            return null;
        }
        if (beforeRevision instanceof BinaryContentRevision) {
            return null;
        }
        return new BaseContentImpl(beforeRevision);
    }

    @Nullable
    private VcsBaseContentProvider findProviderFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(11);
        }
        for (VcsBaseContentProvider support : this.myAdditionalProviders) {
            if (!support.isSupported(file2)) continue;
            return support;
        }
        return null;
    }

    @Override
    public boolean isSupported(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(12);
        }
        return this.isHandledByVcs(file2) || this.findProviderFor(file2) != null;
    }

    private boolean isHandledByVcs(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsFileStatusProvider.$$$reportNull$$$0(13);
        }
        return file2.isInLocalFileSystem() && this.myVcsManager.getVcsFor(file2) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotChangedDirectoryParentingStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileStatus";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshFileStatusFromDocument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNotChangedDirectoryParentingStatus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBaseRevision";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findProviderFor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByVcs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BaseContentImpl
    implements VcsBaseContentProvider.BaseContent {
        @NotNull
        private final ContentRevision myContentRevision;

        public BaseContentImpl(ContentRevision contentRevision) {
            if (contentRevision == null) {
                BaseContentImpl.$$$reportNull$$$0(0);
            }
            this.myContentRevision = contentRevision;
        }

        @Override
        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myContentRevision.getRevisionNumber();
            if (vcsRevisionNumber == null) {
                BaseContentImpl.$$$reportNull$$$0(1);
            }
            return vcsRevisionNumber;
        }

        @Override
        @Nullable
        public String loadContent() {
            String content;
            try {
                content = this.myContentRevision.getContent();
            }
            catch (VcsException ex) {
                content = null;
            }
            if (content == null) {
                VcsFileStatusProvider.this.myHaveEmptyContentRevisions = true;
                return null;
            }
            return content;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRevision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$BaseContentImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsFileStatusProvider$BaseContentImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

