/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.actions.DeleteUnversionedFilesAction;
import com.intellij.openapi.vcs.changes.ui.AbstractSelectFilesDialog;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectFilesDialog
extends AbstractSelectFilesDialog<VirtualFile> {
    @NotNull
    private final VirtualFileList myFileList;
    private final boolean myDeletableFiles;

    protected SelectFilesDialog(Project project, List<VirtualFile> files, String prompt, VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean showDoNotAskOption, boolean deletableFiles) {
        super(project, false, confirmationOption, prompt, showDoNotAskOption);
        this.myDeletableFiles = deletableFiles;
        this.myFileList = new VirtualFileList(project, selectableFiles, deletableFiles, files);
    }

    @NotNull
    public static SelectFilesDialog init(Project project, List<VirtualFile> originalFiles, String prompt, VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean showDoNotAskOption, boolean deletableFiles) {
        SelectFilesDialog dialog2 = new SelectFilesDialog(project, originalFiles, prompt, confirmationOption, selectableFiles, showDoNotAskOption, deletableFiles);
        dialog2.init();
        SelectFilesDialog selectFilesDialog = dialog2;
        if (selectFilesDialog == null) {
            SelectFilesDialog.$$$reportNull$$$0(0);
        }
        return selectFilesDialog;
    }

    public Collection<VirtualFile> getSelectedFiles() {
        return this.myFileList.getIncludedChanges();
    }

    public void setSelectedFiles(@NotNull Collection<VirtualFile> selected) {
        if (selected == null) {
            SelectFilesDialog.$$$reportNull$$$0(1);
        }
        this.myFileList.setIncludedChanges(selected);
        this.myFileList.rebuildTree();
    }

    @Override
    @NotNull
    protected ChangesTree getFileList() {
        VirtualFileList virtualFileList = this.myFileList;
        if (virtualFileList == null) {
            SelectFilesDialog.$$$reportNull$$$0(2);
        }
        return virtualFileList;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createToolbarActions() {
        DefaultActionGroup defaultGroup = super.createToolbarActions();
        if (this.myDeletableFiles) {
            DeleteUnversionedFilesAction deleteAction = new DeleteUnversionedFilesAction(){

                @Override
                public void actionPerformed(AnActionEvent e) {
                    super.actionPerformed(e);
                    SelectFilesDialog.this.myFileList.refresh();
                }
            };
            defaultGroup.add((AnAction)deleteAction);
            deleteAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)this.getFileList()));
        }
        DefaultActionGroup defaultActionGroup = defaultGroup;
        if (defaultActionGroup == null) {
            SelectFilesDialog.$$$reportNull$$$0(3);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VirtualFileList
    extends ChangesTreeImpl.VirtualFiles {
        @Nullable
        private final DeleteProvider myDeleteProvider;

        public VirtualFileList(Project project, boolean selectableFiles, boolean deletableFiles, @NotNull List<VirtualFile> files) {
            if (files == null) {
                VirtualFileList.$$$reportNull$$$0(0);
            }
            super(project, selectableFiles, true, files);
            this.myDeleteProvider = deletableFiles ? new VirtualFileDeleteProvider() : null;
        }

        @Override
        @Nullable
        public Object getData(String dataId) {
            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && this.myDeleteProvider != null) {
                return this.myDeleteProvider;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                return ArrayUtil.toObjectArray(this.getSelectedChanges(), VirtualFile.class);
            }
            return super.getData(dataId);
        }

        public void refresh() {
            this.setChangesToDisplay(ContainerUtil.filter(this.getChanges(), VirtualFile::isValid));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog$VirtualFileList", "<init>"));
        }
    }
}

