/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;

public class IncomingChangeState {
    private static final Logger INCOMING_LOG = Logger.getInstance((String)"#incoming");
    private final FileStatus myStatus;
    private final FilePath myPath;
    private final String myRevision;
    private final State myState;

    public IncomingChangeState(Change change, String revision, State state2) {
        this.myRevision = revision;
        this.myStatus = change.getFileStatus();
        this.myPath = ChangesUtil.getFilePath((Change)change);
        this.myState = state2;
    }

    public static void header(String location) {
        INCOMING_LOG.debug("[------------- " + location + " --------------]");
    }

    public static void footer() {
        INCOMING_LOG.debug("----------------------------");
    }

    public void logSelf() {
        INCOMING_LOG.debug(this.myPath.getPresentableUrl() + " (" + this.myRevision + "): " + this.myStatus.getText() + " -> " + this.myState.myAccounted + " [" + this.myState.myName + "] " + this.myState.myCode);
    }

    public static enum State {
        AFTER_DOES_NOT_MATTER_NON_LOCAL("Skipped", true, 101),
        AFTER_DOES_NOT_MATTER_OUTSIDE_INCOMING("Skipped", true, 102),
        AFTER_DOES_NOT_MATTER_ALIEN_PATH("Skipped", true, 103),
        AFTER_DOES_NOT_MATTER_DELETED_FOUND_IN_INCOMING_LIST("deleted further", true, 104),
        AFTER_EXISTS_LOCALLY_AVAILABLE("change found", true, 105),
        AFTER_EXISTS_REVISION_NOT_LOADED("versioned item not found", false, 106),
        AFTER_EXISTS_NOT_LOCALLY_AVAILABLE("change not found", false, 107),
        AFTER_NOT_EXISTS_LOCALLY_AVAILABLE("not exists but locally available", true, 108),
        AFTER_NOT_EXISTS_MARKED_FOR_DELETION("marked for deletion", true, 109),
        AFTER_NOT_EXISTS_SUBSEQUENTLY_DELETED("subsequently deleted", true, 110),
        AFTER_NOT_EXISTS_OTHER("item missing", false, 111),
        BEFORE_DOES_NOT_MATTER_OUTSIDE("Skipped", true, 201),
        BEFORE_NOT_EXISTS_DELETED_LOCALLY("locally deleted", false, 202),
        BEFORE_NOT_EXISTS_ALREADY_DELETED("already deleted", true, 203),
        BEFORE_UNVERSIONED_INSTEAD_OF_VERS_DELETED("unversioned instead of versioned", true, 204),
        BEFORE_SAME_NAME_ADDED_AFTER_DELETION("item replaced", true, 205),
        BEFORE_EXISTS_BUT_SHOULD_NOT("NOT deleted", false, 206);

        private final boolean myAccounted;
        private final String myName;
        private final int myCode;

        private State(String name, boolean accounted, int code2) {
            this.myName = name;
            this.myAccounted = accounted;
            this.myCode = code2;
        }
    }
}

