/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.actions.ShortNameType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowShortenNames
extends ActionGroup {
    private final AnAction[] myChildren;

    public ShowShortenNames() {
        super("Names", true);
        ArrayList<SetShortNameTypeAction> kids = new ArrayList<SetShortNameTypeAction>(ShortNameType.values().length);
        for (ShortNameType type : ShortNameType.values()) {
            kids.add(new SetShortNameTypeAction(type));
        }
        this.myChildren = kids.toArray(new AnAction[kids.size()]);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myChildren == null) {
            ShowShortenNames.$$$reportNull$$$0(0);
        }
        return this.myChildren;
    }

    public static ShortNameType getType() {
        for (ShortNameType type : ShortNameType.values()) {
            if (!type.isSet()) continue;
            return type;
        }
        return ShortNameType.LASTNAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/ShowShortenNames", "getChildren"));
    }

    private static class SetShortNameTypeAction
    extends ToggleAction
    implements DumbAware {
        private final ShortNameType myType;

        public SetShortNameTypeAction(ShortNameType type) {
            super(type.getDescription());
            this.myType = type;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myType == ShowShortenNames.getType();
        }

        public void setSelected(AnActionEvent e, boolean enabled) {
            if (enabled) {
                this.myType.set();
            }
            AnnotateActionGroup.revalidateMarkupInAllEditors();
        }
    }
}

