/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractCommonCheckinAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonCheckinFilesAction
extends AbstractCommonCheckinAction {
    @Override
    protected String getActionName(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(0);
        }
        String actionName = Optional.ofNullable(dataContext.getProject()).map(project -> {
            if (dataContext == null) {
                CommonCheckinFilesAction.$$$reportNull$$$0(19);
            }
            return CommonCheckinFilesAction.getCommonVcs(this.getRootsStream(dataContext), project);
        }).map(AbstractVcs::getCheckinEnvironment).map(CheckinEnvironment::getCheckinOperationName).orElse(VcsBundle.message((String)"vcs.command.name.checkin", (Object[])new Object[0]));
        return this.modifyCheckinActionName(dataContext, actionName);
    }

    private String modifyCheckinActionName(@NotNull VcsContext dataContext, String checkinActionName) {
        if (dataContext == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(1);
        }
        String result2 = checkinActionName;
        List roots = this.getRootsStream(dataContext).limit(2L).collect(Collectors.toList());
        if (!roots.isEmpty()) {
            String messageKey = ((FilePath)roots.get(0)).isDirectory() ? "action.name.checkin.directory" : "action.name.checkin.file";
            result2 = VcsBundle.message((String)StringUtil.pluralize((String)messageKey, (int)roots.size()), (Object[])new Object[]{checkinActionName});
        }
        return result2;
    }

    @Override
    protected String getMnemonicsFreeActionName(@NotNull VcsContext context) {
        if (context == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(2);
        }
        return this.modifyCheckinActionName(context, VcsBundle.message((String)"vcs.command.name.checkin.no.mnemonics", (Object[])new Object[0]));
    }

    @Override
    @Nullable
    protected LocalChangeList getInitiallySelectedChangeList(@NotNull VcsContext context, @NotNull Project project) {
        if (context == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(4);
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        LocalChangeList defaultChangeList = manager.getDefaultChangeList();
        LocalChangeList result2 = null;
        for (FilePath root : this.getRoots(context)) {
            if (root.getVirtualFile() == null) continue;
            Collection changes = manager.getChangesIn(root);
            if (defaultChangeList != null && CommonCheckinFilesAction.containsAnyChange(defaultChangeList, changes)) {
                return defaultChangeList;
            }
            result2 = changes.stream().findFirst().map(arg_0 -> ((ChangeListManager)manager).getChangeList(arg_0)).orElse(null);
        }
        return (LocalChangeList)ObjectUtils.chooseNotNull(result2, (Object)defaultChangeList);
    }

    @Override
    protected boolean approximatelyHasRoots(@NotNull VcsContext dataContext) {
        if (dataContext == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(5);
        }
        FileStatusManager manager = FileStatusManager.getInstance((Project)dataContext.getProject());
        return this.getRootsStream(dataContext).map(FilePath::getVirtualFile).filter(Objects::nonNull).anyMatch(file2 -> {
            if (dataContext == null) {
                CommonCheckinFilesAction.$$$reportNull$$$0(18);
            }
            return this.isApplicableRoot((VirtualFile)file2, manager.getStatus(file2), dataContext);
        });
    }

    protected boolean isApplicableRoot(@NotNull VirtualFile file2, @NotNull FileStatus status, @NotNull VcsContext dataContext) {
        if (file2 == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(6);
        }
        if (status == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(8);
        }
        return status != FileStatus.UNKNOWN && status != FileStatus.IGNORED;
    }

    @Override
    @NotNull
    protected FilePath[] getRoots(@NotNull VcsContext context) {
        if (context == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(9);
        }
        FilePath[] filePathArray = context.getSelectedFilePaths();
        if (filePathArray == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(10);
        }
        return filePathArray;
    }

    @NotNull
    protected Stream<FilePath> getRootsStream(@NotNull VcsContext context) {
        if (context == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(11);
        }
        Stream stream = context.getSelectedFilePathsStream();
        if (stream == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(12);
        }
        return stream;
    }

    private static boolean containsAnyChange(@NotNull LocalChangeList changeList, @NotNull Collection<Change> changes) {
        if (changeList == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(13);
        }
        if (changes == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(14);
        }
        return changes.stream().anyMatch(changeList.getChanges()::contains);
    }

    @Nullable
    private static AbstractVcs getCommonVcs(@NotNull Stream<FilePath> roots, @NotNull Project project) {
        if (roots == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(15);
        }
        if (project == null) {
            CommonCheckinFilesAction.$$$reportNull$$$0(16);
        }
        return UtilKt.getIfSingle(roots.map(root -> {
            if (project == null) {
                CommonCheckinFilesAction.$$$reportNull$$$0(17);
            }
            return VcsUtil.getVcsFor((Project)project, (FilePath)root);
        }).filter(Objects::nonNull).distinct().limit(Math.min(2, ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/CommonCheckinFilesAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "modifyCheckinActionName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMnemonicsFreeActionName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInitiallySelectedChangeList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "approximatelyHasRoots";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRootsStream";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChange";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCommonVcs";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCommonVcs$2";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$approximatelyHasRoots$1";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getActionName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

