/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ShadowPainter
extends JBUI.ScaleContextSupport<JBUI.ScaleContext> {
    private final Icon myTop;
    private final Icon myTopRight;
    private final Icon myRight;
    private final Icon myBottomRight;
    private final Icon myBottom;
    private final Icon myBottomLeft;
    private final Icon myLeft;
    private final Icon myTopLeft;
    private Icon myCroppedTop = null;
    private Icon myCroppedRight = null;
    private Icon myCroppedBottom = null;
    private Icon myCroppedLeft = null;
    @Nullable
    private Color myBorderColor;

    public ShadowPainter(Icon top, Icon topRight, Icon right, Icon bottomRight, Icon bottom, Icon bottomLeft, Icon left, Icon topLeft) {
        super((JBUI.BaseScaleContext)JBUI.ScaleContext.create());
        this.myTop = top;
        this.myTopRight = topRight;
        this.myRight = right;
        this.myBottomRight = bottomRight;
        this.myBottom = bottom;
        this.myBottomLeft = bottomLeft;
        this.myLeft = left;
        this.myTopLeft = topLeft;
        this.updateIcons(null);
    }

    public ShadowPainter(Icon top, Icon topRight, Icon right, Icon bottomRight, Icon bottom, Icon bottomLeft, Icon left, Icon topLeft, @Nullable Color borderColor) {
        this(top, topRight, right, bottomRight, bottom, bottomLeft, left, topLeft);
        this.myBorderColor = borderColor;
    }

    public void setBorderColor(@Nullable Color borderColor) {
        this.myBorderColor = borderColor;
    }

    public BufferedImage createShadow(JComponent c, int width, int height) {
        BufferedImage image = c.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
        Graphics2D g = image.createGraphics();
        this.paintShadow(c, g, 0, 0, width, height);
        g.dispose();
        return image;
    }

    private void updateIcons(JBUI.ScaleContext ctx) {
        this.updateIcon(this.myTop, ctx, () -> {
            this.myCroppedTop = IconUtil.cropIcon((Icon)this.myTop, (int)1, (int)Integer.MAX_VALUE);
        });
        this.updateIcon(this.myTopRight, ctx, null);
        this.updateIcon(this.myRight, ctx, () -> {
            this.myCroppedRight = IconUtil.cropIcon((Icon)this.myRight, (int)Integer.MAX_VALUE, (int)1);
        });
        this.updateIcon(this.myBottomRight, ctx, null);
        this.updateIcon(this.myBottom, ctx, () -> {
            this.myCroppedBottom = IconUtil.cropIcon((Icon)this.myBottom, (int)1, (int)Integer.MAX_VALUE);
        });
        this.updateIcon(this.myBottomLeft, ctx, null);
        this.updateIcon(this.myLeft, ctx, () -> {
            this.myCroppedLeft = IconUtil.cropIcon((Icon)this.myLeft, (int)Integer.MAX_VALUE, (int)1);
        });
        this.updateIcon(this.myTopLeft, ctx, null);
    }

    private void updateIcon(Icon icon, JBUI.ScaleContext ctx, Runnable r) {
        if (icon instanceof JBUI.ScaleContextAware) {
            ((JBUI.ScaleContextAware)icon).updateScaleContext((JBUI.BaseScaleContext)ctx);
        }
        if (r != null) {
            r.run();
        }
    }

    public void paintShadow(Component c, Graphics2D g, int x, int y, int width, int height) {
        int _y;
        int _x;
        JBUI.ScaleContext ctx = JBUI.ScaleContext.create((Component)c);
        if (this.updateScaleContext((JBUI.BaseScaleContext)ctx)) {
            this.updateIcons(ctx);
        }
        int leftSize = this.myCroppedLeft.getIconWidth();
        int rightSize = this.myCroppedRight.getIconWidth();
        int bottomSize = this.myCroppedBottom.getIconHeight();
        int topSize = this.myCroppedTop.getIconHeight();
        int delta = this.myTopLeft.getIconHeight() + this.myBottomLeft.getIconHeight() - height;
        if (delta > 0) {
            Shape clip = g.getClip();
            int topHeight = this.myTopLeft.getIconHeight() - delta / 2;
            Area top = new Area(new Rectangle2D.Float(x, y, width, topHeight));
            if (clip != null) {
                top.intersect(new Area(clip));
            }
            g.setClip(top);
            this.myTopLeft.paintIcon(c, g, x, y);
            this.myTopRight.paintIcon(c, g, x + width - this.myTopRight.getIconWidth(), y);
            int bottomHeight = this.myBottomLeft.getIconHeight() - delta + delta / 2;
            Area bottom = new Area(new Rectangle2D.Float(x, y + topHeight, width, bottomHeight));
            if (clip != null) {
                bottom.intersect(new Area(clip));
            }
            g.setClip(bottom);
            this.myBottomLeft.paintIcon(c, g, x, y + height - this.myBottomLeft.getIconHeight());
            this.myBottomRight.paintIcon(c, g, x + width - this.myBottomRight.getIconWidth(), y + height - this.myBottomRight.getIconHeight());
            g.setClip(clip);
        } else {
            this.myTopLeft.paintIcon(c, g, x, y);
            this.myTopRight.paintIcon(c, g, x + width - this.myTopRight.getIconWidth(), y);
            this.myBottomRight.paintIcon(c, g, x + width - this.myBottomRight.getIconWidth(), y + height - this.myBottomRight.getIconHeight());
            this.myBottomLeft.paintIcon(c, g, x, y + height - this.myBottomLeft.getIconHeight());
        }
        for (_x = this.myTopLeft.getIconWidth(); _x < width - this.myTopRight.getIconWidth(); ++_x) {
            this.myCroppedTop.paintIcon(c, g, _x + x, y);
        }
        for (_x = this.myBottomLeft.getIconWidth(); _x < width - this.myBottomLeft.getIconWidth(); ++_x) {
            this.myCroppedBottom.paintIcon(c, g, _x + x, y + height - bottomSize);
        }
        for (_y = this.myTopLeft.getIconHeight(); _y < height - this.myBottomLeft.getIconHeight(); ++_y) {
            this.myCroppedLeft.paintIcon(c, g, x, _y + y);
        }
        for (_y = this.myTopRight.getIconHeight(); _y < height - this.myBottomRight.getIconHeight(); ++_y) {
            this.myCroppedRight.paintIcon(c, g, x + width - rightSize, _y + y);
        }
        if (this.myBorderColor != null) {
            g.setColor(this.myBorderColor);
            g.drawRect(x + leftSize - 1, y + topSize - 1, width - leftSize - rightSize + 1, height - topSize - bottomSize + 1);
        }
    }
}

