/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StoreUtil {
    private static final Logger LOG = Logger.getInstance(StoreUtil.class);

    private StoreUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(@NotNull IComponentStore stateStore, @Nullable Project project) {
        if (stateStore == null) {
            StoreUtil.$$$reportNull$$$0(0);
        }
        Thread currentThread = Thread.currentThread();
        ShutDownTracker.getInstance().registerStopperThread(currentThread);
        try {
            stateStore.save((List<Pair<StateStorage.SaveSession, VirtualFile>>)new SmartList());
        }
        catch (IComponentStore.SaveCancelledException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Save settings failed", e);
            } else {
                LOG.warn("Save settings failed", e);
            }
            String messagePostfix = " Please restart " + ApplicationNamesInfo.getInstance().getFullProductName() + "</p>" + (ApplicationManagerEx.getApplicationEx().isInternal() ? "<p>" + StringUtil.getThrowableText((Throwable)e) + "</p>" : "");
            PluginId pluginId = IdeErrorsDialog.findPluginId(e);
            if (pluginId == null) {
                new Notification("Settings Error", "Unable to save settings", "<p>Failed to save settings." + messagePostfix, NotificationType.ERROR).notify(project);
            } else {
                PluginManagerCore.disablePlugin(pluginId.getIdString());
                new Notification("Settings Error", "Unable to save plugin settings", "<p>The plugin <i>" + pluginId + "</i> failed to save settings and has been disabled." + messagePostfix, NotificationType.ERROR).notify(project);
            }
        }
        finally {
            ShutDownTracker.getInstance().unregisterStopperThread(currentThread);
        }
    }

    @NotNull
    public static <T> State getStateSpec(@NotNull PersistentStateComponent<T> persistentStateComponent) {
        if (persistentStateComponent == null) {
            StoreUtil.$$$reportNull$$$0(1);
        }
        State state2 = StoreUtil.getStateSpecOrError(persistentStateComponent.getClass());
        if (state2 == null) {
            StoreUtil.$$$reportNull$$$0(2);
        }
        return state2;
    }

    @NotNull
    public static State getStateSpecOrError(@NotNull Class<? extends PersistentStateComponent> componentClass) {
        State spec;
        if (componentClass == null) {
            StoreUtil.$$$reportNull$$$0(3);
        }
        if ((spec = StoreUtil.getStateSpec(componentClass)) != null) {
            State state2 = spec;
            if (state2 == null) {
                StoreUtil.$$$reportNull$$$0(4);
            }
            return state2;
        }
        PluginId pluginId = PluginManagerCore.getPluginByClassName(componentClass.getName());
        if (pluginId == null) {
            throw new RuntimeException("No @State annotation found in " + componentClass);
        }
        throw new PluginException("No @State annotation found in " + componentClass, pluginId);
    }

    @Nullable
    public static State getStateSpec(@NotNull Class<?> aClass) {
        if (aClass == null) {
            StoreUtil.$$$reportNull$$$0(5);
        }
        do {
            State stateSpec;
            if ((stateSpec = aClass.getAnnotation(State.class)) == null) continue;
            return stateSpec;
        } while ((aClass = aClass.getSuperclass()) != null);
        return null;
    }

    public static void saveDocumentsAndProjectsAndApp() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager instanceof ProjectManagerEx) {
            ((ProjectManagerEx)projectManager).flushChangedProjectFileAlarm();
        }
        for (Project openProject : projectManager.getOpenProjects()) {
            openProject.save();
        }
        ApplicationManager.getApplication().saveSettings();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateStore";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentStateComponent";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/stores/StoreUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/stores/StoreUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateSpec";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateSpecOrError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStateSpec";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStateSpecOrError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

