/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.HashMap;
import java.util.Map;

public class SimpleDataContext
implements DataContext {
    private final Map<String, Object> myDataId2Data;
    private final DataContext myParent;

    private SimpleDataContext(String dataId, Object data, DataContext parent) {
        this.myDataId2Data = new HashMap(1);
        this.myDataId2Data.put(dataId, data);
        this.myParent = parent;
    }

    private SimpleDataContext(Map<String, Object> dataid2data, DataContext parent) {
        this.myDataId2Data = dataid2data;
        this.myParent = parent;
    }

    public Object getData(String dataId) {
        Object result2;
        Object object = this.myDataId2Data.containsKey(dataId) ? this.myDataId2Data.get(dataId) : (result2 = this.myParent == null ? null : this.myParent.getData(dataId));
        if (result2 == null && PlatformDataKeys.CONTEXT_COMPONENT.getName().equals(dataId)) {
            result2 = IdeFocusManager.getGlobalInstance().getFocusOwner();
        }
        return result2;
    }

    public static DataContext getSimpleContext(String dataId, Object data, DataContext parent) {
        return new SimpleDataContext(dataId, data, parent);
    }

    public static DataContext getSimpleContext(Map<String, Object> dataId2data, DataContext parent) {
        return new SimpleDataContext(dataId2data, parent);
    }

    public static DataContext getSimpleContext(String dataId, Object data) {
        return SimpleDataContext.getSimpleContext(dataId, data, null);
    }

    public static DataContext getProjectContext(Project project) {
        return SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), project);
    }
}

