/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ToolbarUpdater;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ActionToolbarImpl
extends JPanel
implements ActionToolbar,
QuickActionProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.ActionToolbarImpl");
    private static final List<ActionToolbarImpl> ourToolbars = new LinkedList<ActionToolbarImpl>();
    private static final String RIGHT_ALIGN_KEY = "RIGHT_ALIGN";
    private final List<Rectangle> myComponentBounds;
    private JBDimension myMinimumButtonSize;
    private int myLayoutPolicy;
    private int myOrientation;
    private final ActionGroup myActionGroup;
    private final String myPlace;
    protected List<AnAction> myVisibleActions;
    private final PresentationFactory myPresentationFactory;
    private final boolean myDecorateButtons;
    private final ToolbarUpdater myUpdater;
    private boolean myAdjustTheSameSize;
    private final ActionButtonLook myButtonLook;
    private final ActionButtonLook myMinimalButtonLook;
    private final DataManager myDataManager;
    protected final ActionManagerEx myActionManager;
    private Rectangle myAutoPopupRec;
    private final DefaultActionGroup mySecondaryActions;
    private PopupStateModifier mySecondaryButtonPopupStateModifier;
    private boolean myForceMinimumSize;
    private boolean myMinimalMode;
    private boolean myForceUseMacEnhancements;
    private ActionButton mySecondaryActionsButton;
    private int myFirstOutsideIndex;
    private JBPopup myPopup;
    private JComponent myTargetComponent;
    private boolean myReservePlaceAutoPopupIcon;
    private boolean myAddSeparatorFirst;

    public static void updateAllToolbarsImmediately() {
        for (ActionToolbarImpl toolbar : new ArrayList<ActionToolbarImpl>(ourToolbars)) {
            toolbar.updateActionsImmediately();
            for (Component c : toolbar.getComponents()) {
                if (!(c instanceof ActionButton)) continue;
                ((ActionButton)c).updateToolTipText();
                ((ActionButton)c).updateIcon();
            }
        }
    }

    public ActionButton getSecondaryActionsButton() {
        return this.mySecondaryActionsButton;
    }

    public ActionToolbarImpl(String place, @NotNull ActionGroup actionGroup, boolean horizontal, @NotNull DataManager dataManager, @NotNull ActionManagerEx actionManager, @NotNull KeymapManagerEx keymapManager2) {
        if (actionGroup == null) {
            ActionToolbarImpl.$$$reportNull$$$0(0);
        }
        if (dataManager == null) {
            ActionToolbarImpl.$$$reportNull$$$0(1);
        }
        if (actionManager == null) {
            ActionToolbarImpl.$$$reportNull$$$0(2);
        }
        if (keymapManager2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(3);
        }
        this(place, actionGroup, horizontal, false, dataManager, actionManager, keymapManager2, false);
    }

    public ActionToolbarImpl(String place, @NotNull ActionGroup actionGroup, boolean horizontal, boolean decorateButtons, @NotNull DataManager dataManager, @NotNull ActionManagerEx actionManager, @NotNull KeymapManagerEx keymapManager2) {
        if (actionGroup == null) {
            ActionToolbarImpl.$$$reportNull$$$0(4);
        }
        if (dataManager == null) {
            ActionToolbarImpl.$$$reportNull$$$0(5);
        }
        if (actionManager == null) {
            ActionToolbarImpl.$$$reportNull$$$0(6);
        }
        if (keymapManager2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(7);
        }
        this(place, actionGroup, horizontal, decorateButtons, dataManager, actionManager, keymapManager2, false);
    }

    public ActionToolbarImpl(String place, @NotNull ActionGroup actionGroup, boolean horizontal, boolean decorateButtons, @NotNull DataManager dataManager, @NotNull ActionManagerEx actionManager, @NotNull KeymapManagerEx keymapManager2, boolean updateActionsNow) {
        if (actionGroup == null) {
            ActionToolbarImpl.$$$reportNull$$$0(8);
        }
        if (dataManager == null) {
            ActionToolbarImpl.$$$reportNull$$$0(9);
        }
        if (actionManager == null) {
            ActionToolbarImpl.$$$reportNull$$$0(10);
        }
        if (keymapManager2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(11);
        }
        super(null);
        this.myComponentBounds = new ArrayList<Rectangle>();
        this.myMinimumButtonSize = JBUI.emptySize();
        this.myPresentationFactory = new PresentationFactory();
        this.myButtonLook = null;
        this.myMinimalButtonLook = ActionButtonLook.INPLACE_LOOK;
        this.mySecondaryActions = new DefaultActionGroup();
        this.mySecondaryButtonPopupStateModifier = null;
        this.myForceMinimumSize = false;
        this.myFirstOutsideIndex = -1;
        this.myReservePlaceAutoPopupIcon = true;
        this.myActionManager = actionManager;
        this.myPlace = place;
        this.myActionGroup = actionGroup;
        this.myVisibleActions = new ArrayList<AnAction>();
        this.myDataManager = dataManager;
        this.myDecorateButtons = decorateButtons;
        this.myUpdater = new ToolbarUpdater(actionManager, keymapManager2, this){

            @Override
            protected void updateActionsImpl(boolean transparentOnly, boolean forced) {
                ActionToolbarImpl.this.updateActionsImpl(transparentOnly, forced);
            }
        };
        this.setLayout(new BorderLayout());
        this.setOrientation(horizontal ? 0 : 1);
        this.mySecondaryActions.getTemplatePresentation().setIcon(AllIcons.General.SecondaryGroup);
        this.mySecondaryActions.setPopup(true);
        this.myUpdater.updateActions(updateActionsNow, false);
        this.enableEvents(51L);
        this.setMiniMode(false);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        for (Component component : this.getComponents()) {
            this.tweakActionComponentUI(component);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ourToolbars.add(this);
        this.updateActionsImmediately();
    }

    private boolean doMacEnhancementsForMainToolbar() {
        return UIUtil.isUnderAquaLookAndFeel() && ("MainToolbar".equals(this.myPlace) || this.myForceUseMacEnhancements);
    }

    public void setForceUseMacEnhancements(boolean useMacEnhancements) {
        this.myForceUseMacEnhancements = useMacEnhancements;
    }

    private boolean isInsideNavBar() {
        return "NavBarToolbar".equals(this.myPlace);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ourToolbars.remove(this);
    }

    @NotNull
    public JComponent getComponent() {
        ActionToolbarImpl actionToolbarImpl = this;
        if (actionToolbarImpl == null) {
            ActionToolbarImpl.$$$reportNull$$$0(12);
        }
        return actionToolbarImpl;
    }

    public int getLayoutPolicy() {
        return this.myLayoutPolicy;
    }

    public void setLayoutPolicy(int layoutPolicy) {
        if (layoutPolicy != 0 && layoutPolicy != 1 && layoutPolicy != 2) {
            throw new IllegalArgumentException("wrong layoutPolicy: " + layoutPolicy);
        }
        this.myLayoutPolicy = layoutPolicy;
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.doMacEnhancementsForMainToolbar()) {
            Rectangle r = this.getBounds();
            UIUtil.drawGradientHToolbarBackground((Graphics)g, (int)r.width, (int)r.height);
        } else {
            super.paintComponent(g);
        }
        if (this.myLayoutPolicy == 2 && this.myAutoPopupRec != null) {
            if (this.myOrientation == 0) {
                int dy = this.myAutoPopupRec.height / 2 - AllIcons.Ide.Link.getIconHeight() / 2;
                AllIcons.Ide.Link.paintIcon(this, g, (int)this.myAutoPopupRec.getMaxX() - AllIcons.Ide.Link.getIconWidth() - 1, this.myAutoPopupRec.y + dy);
            } else {
                int dx = this.myAutoPopupRec.width / 2 - AllIcons.Ide.Link.getIconWidth() / 2;
                AllIcons.Ide.Link.paintIcon(this, g, this.myAutoPopupRec.x + dx, (int)this.myAutoPopupRec.getMaxY() - AllIcons.Ide.Link.getIconWidth() - 1);
            }
        }
    }

    public void setSecondaryButtonPopupStateModifier(PopupStateModifier popupStateModifier) {
        this.mySecondaryButtonPopupStateModifier = popupStateModifier;
    }

    private void fillToolBar(List<AnAction> actions, boolean layoutSecondaries) {
        ArrayList<AnAction> rightAligned = new ArrayList<AnAction>();
        if (this.myAddSeparatorFirst) {
            this.add(new MySeparator());
        }
        for (int i = 0; i < actions.size(); ++i) {
            AnAction action = actions.get(i);
            if (action instanceof RightAlignedToolbarAction) {
                rightAligned.add(action);
                continue;
            }
            if (layoutSecondaries && !this.myActionGroup.isPrimary(action)) {
                this.mySecondaryActions.add(action);
                continue;
            }
            if (action instanceof Separator) {
                if (i <= 0 || i >= actions.size() - 1) continue;
                this.add(new MySeparator());
                continue;
            }
            if (action instanceof CustomComponentAction) {
                this.add(this.getCustomComponent(action));
                continue;
            }
            this.add(this.createToolbarButton(action));
        }
        if (this.mySecondaryActions.getChildrenCount() > 0) {
            this.mySecondaryActionsButton = new ActionButton((AnAction)this.mySecondaryActions, this.myPresentationFactory.getPresentation((AnAction)this.mySecondaryActions), this.myPlace, this.getMinimumButtonSize()){

                @Override
                @ActionButtonComponent.ButtonState
                public int getPopState() {
                    return ActionToolbarImpl.this.mySecondaryButtonPopupStateModifier != null && ActionToolbarImpl.this.mySecondaryButtonPopupStateModifier.willModify() ? ActionToolbarImpl.this.mySecondaryButtonPopupStateModifier.getModifiedPopupState() : super.getPopState();
                }
            };
            this.mySecondaryActionsButton.setNoIconsInPopup(true);
            this.add(this.mySecondaryActionsButton);
        }
        for (AnAction action : rightAligned) {
            JComponent button;
            JComponent jComponent = button = action instanceof CustomComponentAction ? this.getCustomComponent(action) : this.createToolbarButton(action);
            if (!this.isInsideNavBar()) {
                button.putClientProperty(RIGHT_ALIGN_KEY, Boolean.TRUE);
            }
            this.add(button);
        }
    }

    private JComponent getCustomComponent(AnAction action) {
        Presentation presentation = this.myPresentationFactory.getPresentation(action);
        JComponent customComponent = (JComponent)ObjectUtils.tryCast((Object)presentation.getClientProperty("customComponent"), JComponent.class);
        if (customComponent == null) {
            customComponent = ((CustomComponentAction)action).createCustomComponent(presentation);
            presentation.putClientProperty("customComponent", (Object)customComponent);
        }
        if (customComponent instanceof JCheckBox) {
            customComponent.setBorder((Border)JBUI.Borders.emptyLeft((int)9));
        }
        this.tweakActionComponentUI(customComponent);
        return customComponent;
    }

    private void tweakActionComponentUI(@NotNull Component actionComponent) {
        if (actionComponent == null) {
            ActionToolbarImpl.$$$reportNull$$$0(13);
        }
        if ("EditorToolbar".equals(this.myPlace)) {
            actionComponent.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            actionComponent.setForeground(ColorUtil.dimmer((Color)JBColor.BLACK));
        }
    }

    private Dimension getMinimumButtonSize() {
        return this.isInsideNavBar() ? NAVBAR_MINIMUM_BUTTON_SIZE : DEFAULT_MINIMUM_BUTTON_SIZE;
    }

    public ActionButton createToolbarButton(AnAction action, ActionButtonLook look, String place, Presentation presentation, Dimension minimumSize) {
        if (action.displayTextInToolbar()) {
            int mnemonic = KeyEvent.getExtendedKeyCodeForChar(action.getTemplatePresentation().getMnemonic());
            final ActionButtonWithText buttonWithText = new ActionButtonWithText(action, presentation, place, minimumSize){

                @Override
                protected HelpTooltip.Alignment getTooltipLocation() {
                    return ActionToolbarImpl.this.tooltipLocation();
                }
            };
            if (mnemonic != 0) {
                buttonWithText.registerKeyboardAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        buttonWithText.click();
                    }
                }, KeyStroke.getKeyStroke(mnemonic, 512), 2);
            }
            this.tweakActionComponentUI(buttonWithText);
            return buttonWithText;
        }
        ActionButton actionButton = new ActionButton(action, presentation, place, minimumSize){

            @Override
            protected DataContext getDataContext() {
                return ActionToolbarImpl.this.getToolbarDataContext();
            }

            @Override
            protected HelpTooltip.Alignment getTooltipLocation() {
                return ActionToolbarImpl.this.tooltipLocation();
            }
        };
        actionButton.setLook(look);
        return actionButton;
    }

    private HelpTooltip.Alignment tooltipLocation() {
        return this.myOrientation == 1 ? HelpTooltip.Alignment.RIGHT : HelpTooltip.Alignment.BOTTOM;
    }

    private ActionButton createToolbarButton(AnAction action) {
        return this.createToolbarButton(action, this.myMinimalMode ? this.myMinimalButtonLook : (this.myDecorateButtons ? new ActionButtonLook(){

            @Override
            public void paintBorder(Graphics g, JComponent c, int state2) {
                g.setColor(JBColor.border());
                g.drawLine(c.getWidth() - 1, 0, c.getWidth() - 1, c.getHeight());
            }

            @Override
            public void paintBackground(Graphics g, JComponent component, int state2) {
                if (state2 == -1) {
                    g.setColor(component.getBackground().darker());
                    ((Graphics2D)g).fill(g.getClip());
                }
            }
        } : this.myButtonLook), this.myPlace, this.myPresentationFactory.getPresentation(action), (Dimension)this.myMinimumButtonSize.size());
    }

    @Override
    public void doLayout() {
        int componentCount;
        if (!this.isValid()) {
            this.calculateBounds(this.getSize(), this.myComponentBounds);
        }
        LOG.assertTrue((componentCount = this.getComponentCount()) <= this.myComponentBounds.size());
        for (int i = componentCount - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            component.setBounds(this.myComponentBounds.get(i));
        }
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            this.calculateBounds(this.getSize(), this.myComponentBounds);
            super.validate();
        }
    }

    private Dimension getChildPreferredSize(int index) {
        Component component = this.getComponent(index);
        return component.isVisible() ? component.getPreferredSize() : new Dimension();
    }

    private int getMaxButtonWidth() {
        int width = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Dimension dimension = this.getChildPreferredSize(i);
            width = Math.max(width, dimension.width);
        }
        return width;
    }

    public int getMaxButtonHeight() {
        int height = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Dimension dimension = this.getChildPreferredSize(i);
            height = Math.max(height, dimension.height);
        }
        return height;
    }

    private void calculateBoundsNowrapImpl(List<Rectangle> bounds) {
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds.size());
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        if (this.myAdjustTheSameSize) {
            int maxWidth = this.getMaxButtonWidth();
            int maxHeight = this.getMaxButtonHeight();
            if (this.myOrientation == 0) {
                int offset = 0;
                for (int i = 0; i < componentCount; ++i) {
                    Rectangle r = bounds.get(i);
                    r.setBounds(insets.left + offset, insets.top + (height - maxHeight) / 2, maxWidth, maxHeight);
                    offset += maxWidth;
                }
            } else {
                int offset = 0;
                for (int i = 0; i < componentCount; ++i) {
                    Rectangle r = bounds.get(i);
                    r.setBounds(insets.left + (width - maxWidth) / 2, insets.top + offset, maxWidth, maxHeight);
                    offset += maxHeight;
                }
            }
        } else if (this.myOrientation == 0) {
            int maxHeight = this.getMaxButtonHeight();
            int offset = 0;
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = this.getChildPreferredSize(i);
                Rectangle r = bounds.get(i);
                r.setBounds(insets.left + offset, insets.top + (maxHeight - d.height) / 2, d.width, d.height);
                offset += d.width;
            }
        } else {
            int maxWidth = this.getMaxButtonWidth();
            int offset = 0;
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = this.getChildPreferredSize(i);
                Rectangle r = bounds.get(i);
                r.setBounds(insets.left + (maxWidth - d.width) / 2, insets.top + offset, d.width, d.height);
                offset += d.height;
            }
        }
    }

    private void calculateBoundsAutoImp(Dimension sizeToFit, List<Rectangle> bounds) {
        boolean actualLayout;
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds.size());
        boolean bl = actualLayout = bounds == this.myComponentBounds;
        if (actualLayout) {
            this.myAutoPopupRec = null;
        }
        int autoButtonSize = AllIcons.Ide.Link.getIconWidth();
        boolean full = false;
        Insets insets = this.getInsets();
        int widthToFit = sizeToFit.width - insets.left - insets.right;
        int heightToFit = sizeToFit.height - insets.top - insets.bottom;
        if (this.myOrientation == 0) {
            int eachX = 0;
            int maxHeight = heightToFit;
            for (int i = 0; i < componentCount; ++i) {
                Component eachComp = this.getComponent(i);
                boolean isLast = i == componentCount - 1;
                Rectangle eachBound = new Rectangle(this.getChildPreferredSize(i));
                maxHeight = Math.max(eachBound.height, maxHeight);
                if (!full) {
                    boolean inside;
                    if (isLast) {
                        inside = eachX + eachBound.width <= widthToFit;
                    } else {
                        boolean bl2 = inside = eachX + eachBound.width + autoButtonSize <= widthToFit;
                    }
                    if (inside) {
                        if (eachComp == this.mySecondaryActionsButton) {
                            assert (isLast);
                            if (sizeToFit.width != Integer.MAX_VALUE) {
                                eachBound.x = sizeToFit.width - insets.right - eachBound.width;
                                eachX = (int)eachBound.getMaxX() - insets.left;
                            } else {
                                eachBound.x = insets.left + eachX;
                            }
                        } else {
                            eachBound.x = insets.left + eachX;
                            eachX += eachBound.width;
                        }
                        eachBound.y = insets.top;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    if (this.myAutoPopupRec == null) {
                        this.myAutoPopupRec = new Rectangle(insets.left + eachX, insets.top, widthToFit - eachX, heightToFit);
                        this.myFirstOutsideIndex = i;
                    }
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                bounds.get(i).setBounds(eachBound);
            }
            for (Rectangle r : bounds) {
                if (r.height >= maxHeight) continue;
                r.y += (maxHeight - r.height) / 2;
            }
        } else {
            int eachY = 0;
            for (int i = 0; i < componentCount; ++i) {
                Rectangle eachBound = new Rectangle(this.getChildPreferredSize(i));
                if (!full) {
                    boolean outside;
                    if (i < componentCount - 1) {
                        outside = eachY + eachBound.height + autoButtonSize < heightToFit;
                    } else {
                        boolean bl3 = outside = eachY + eachBound.height < heightToFit;
                    }
                    if (outside) {
                        eachBound.x = insets.left;
                        eachBound.y = insets.top + eachY;
                        eachY += eachBound.height;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    if (this.myAutoPopupRec == null) {
                        this.myAutoPopupRec = new Rectangle(insets.left, insets.top + eachY, widthToFit, heightToFit - eachY);
                        this.myFirstOutsideIndex = i;
                    }
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                bounds.get(i).setBounds(eachBound);
            }
        }
    }

    private void calculateBoundsWrapImpl(Dimension sizeToFit, List<Rectangle> bounds) {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            try {
                this.setLayoutPolicy(0);
                this.calculateBoundsNowrapImpl(bounds);
            }
            finally {
                this.setLayoutPolicy(1);
            }
            return;
        }
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds.size());
        Insets insets = this.getInsets();
        int widthToFit = sizeToFit.width - insets.left - insets.right;
        int heightToFit = sizeToFit.height - insets.top - insets.bottom;
        if (this.myAdjustTheSameSize) {
            if (this.myOrientation == 0) {
                int maxWidth = this.getMaxButtonWidth();
                int maxHeight = this.getMaxButtonHeight();
                int xOffset = 0;
                int yOffset = 0;
                int maxRowWidth = Math.max(widthToFit, componentCount * maxWidth / 3);
                for (int i = 0; i < componentCount; ++i) {
                    if (xOffset + maxWidth > maxRowWidth) {
                        xOffset = 0;
                        yOffset += maxHeight;
                    }
                    Rectangle each = bounds.get(i);
                    each.setBounds(insets.left + xOffset, insets.top + yOffset, maxWidth, maxHeight);
                    xOffset += maxWidth;
                }
            } else {
                int maxWidth = this.getMaxButtonWidth();
                int maxHeight = this.getMaxButtonHeight();
                int xOffset = 0;
                int yOffset = 0;
                int maxRowHeight = Math.max(heightToFit, componentCount * this.myMinimumButtonSize.height() / 3);
                for (int i = 0; i < componentCount; ++i) {
                    if (yOffset + maxHeight > maxRowHeight) {
                        yOffset = 0;
                        xOffset += maxWidth;
                    }
                    Rectangle each = bounds.get(i);
                    each.setBounds(insets.left + xOffset, insets.top + yOffset, maxWidth, maxHeight);
                    yOffset += maxHeight;
                }
            }
        } else if (this.myOrientation == 0) {
            int rowHeight = 0;
            Dimension[] dims = new Dimension[componentCount];
            for (int i = 0; i < componentCount; ++i) {
                dims[i] = this.getChildPreferredSize(i);
                int height = dims[i].height;
                rowHeight = Math.max(rowHeight, height);
            }
            int xOffset = 0;
            int yOffset = 0;
            int maxRowWidth = Math.max(widthToFit, componentCount * this.myMinimumButtonSize.width() / 3);
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = dims[i];
                if (xOffset + d.width > maxRowWidth) {
                    xOffset = 0;
                    yOffset += rowHeight;
                }
                Rectangle each = bounds.get(i);
                each.setBounds(insets.left + xOffset, insets.top + yOffset + (rowHeight - d.height) / 2, d.width, d.height);
                xOffset += d.width;
            }
        } else {
            int rowWidth = 0;
            Dimension[] dims = new Dimension[componentCount];
            for (int i = 0; i < componentCount; ++i) {
                dims[i] = this.getChildPreferredSize(i);
                int width = dims[i].width;
                rowWidth = Math.max(rowWidth, width);
            }
            int xOffset = 0;
            int yOffset = 0;
            int maxRowHeight = Math.max(heightToFit, componentCount * this.myMinimumButtonSize.height() / 3);
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = dims[i];
                if (yOffset + d.height > maxRowHeight) {
                    yOffset = 0;
                    xOffset += rowWidth;
                }
                Rectangle each = bounds.get(i);
                each.setBounds(insets.left + xOffset + (rowWidth - d.width) / 2, insets.top + yOffset, d.width, d.height);
                yOffset += d.height;
            }
        }
    }

    private void calculateBounds(Dimension size2Fit, List<Rectangle> bounds) {
        bounds.clear();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            bounds.add(new Rectangle());
        }
        if (this.myLayoutPolicy == 0) {
            this.calculateBoundsNowrapImpl(bounds);
        } else if (this.myLayoutPolicy == 1) {
            this.calculateBoundsWrapImpl(size2Fit, bounds);
        } else if (this.myLayoutPolicy == 2) {
            this.calculateBoundsAutoImp(size2Fit, bounds);
        } else {
            throw new IllegalStateException("unknown layoutPolicy: " + this.myLayoutPolicy);
        }
        if (this.getComponentCount() > 0 && size2Fit.width < Integer.MAX_VALUE) {
            int maxHeight = 0;
            for (int i = 0; i < bounds.size() - 2; ++i) {
                maxHeight = Math.max(maxHeight, bounds.get((int)i).height);
            }
            int rightOffset = 0;
            Insets insets = this.getInsets();
            int i = this.getComponentCount() - 1;
            int j = 1;
            while (i > 0) {
                Component component = this.getComponent(i);
                if (component instanceof JComponent && ((JComponent)component).getClientProperty(RIGHT_ALIGN_KEY) == Boolean.TRUE) {
                    Rectangle r = bounds.get(bounds.size() - j);
                    r.x = size2Fit.width - (rightOffset += bounds.get((int)i).width);
                    r.y = insets.top + (this.getHeight() - insets.top - insets.bottom - bounds.get((int)i).height) / 2;
                }
                --i;
                ++j;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        ArrayList<Rectangle> bounds = new ArrayList<Rectangle>();
        this.calculateBounds(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE), bounds);
        if (bounds.isEmpty()) {
            return JBUI.emptySize();
        }
        int xLeft = Integer.MAX_VALUE;
        int yTop = Integer.MAX_VALUE;
        int xRight = Integer.MIN_VALUE;
        int yBottom = Integer.MIN_VALUE;
        for (int i = bounds.size() - 1; i >= 0; --i) {
            Rectangle each = bounds.get(i);
            if (each.x == Integer.MAX_VALUE) continue;
            xLeft = Math.min(xLeft, each.x);
            yTop = Math.min(yTop, each.y);
            xRight = Math.max(xRight, each.x + each.width);
            yBottom = Math.max(yBottom, each.y + each.height);
        }
        Dimension dimension = new Dimension(xRight - xLeft, yBottom - yTop);
        if (this.myLayoutPolicy == 2 && this.myReservePlaceAutoPopupIcon && !this.isInsideNavBar()) {
            if (this.myOrientation == 0) {
                dimension.width += AllIcons.Ide.Link.getIconWidth();
            } else {
                dimension.height += AllIcons.Ide.Link.getIconHeight();
            }
        }
        JBInsets.addTo((Dimension)dimension, (Insets)this.getInsets());
        return dimension;
    }

    public void setForceMinimumSize(boolean force) {
        this.myForceMinimumSize = force;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.myForceMinimumSize) {
            return this.getPreferredSize();
        }
        if (this.myLayoutPolicy == 2) {
            Insets i = this.getInsets();
            return new Dimension(AllIcons.Ide.Link.getIconWidth() + i.left + i.right, this.myMinimumButtonSize.height() + i.top + i.bottom);
        }
        return super.getMinimumSize();
    }

    public void adjustTheSameSize(boolean value) {
        if (this.myAdjustTheSameSize == value) {
            return;
        }
        this.myAdjustTheSameSize = value;
        this.revalidate();
    }

    public void setMinimumButtonSize(@NotNull Dimension size) {
        if (size == null) {
            ActionToolbarImpl.$$$reportNull$$$0(14);
        }
        this.myMinimumButtonSize = JBDimension.create((Dimension)size, (boolean)true);
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ActionButton)) continue;
            ActionButton button = (ActionButton)component;
            button.setMinimumButtonSize(size);
        }
        this.revalidate();
    }

    public void setOrientation(int orientation) {
        if (0 != orientation && 1 != orientation) {
            throw new IllegalArgumentException("wrong orientation: " + orientation);
        }
        this.myOrientation = orientation;
    }

    public void updateActionsImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdater.updateActions(true, false);
    }

    private void updateActionsImpl(boolean transparentOnly, boolean forced) {
        ArrayList newVisibleActions = ContainerUtil.newArrayListWithCapacity((int)this.myVisibleActions.size());
        DataContext dataContext = this.getDataContext();
        Utils.expandActionGroup(LaterInvocator.isInModalContext(), this.myActionGroup, newVisibleActions, this.myPresentationFactory, dataContext, this.myPlace, (ActionManager)this.myActionManager, transparentOnly, false, false, true);
        if (forced || !newVisibleActions.equals(this.myVisibleActions)) {
            boolean shouldRebuildUI = newVisibleActions.isEmpty() || this.myVisibleActions.isEmpty();
            this.myVisibleActions = newVisibleActions;
            Dimension oldSize = this.getPreferredSize();
            this.removeAll();
            this.mySecondaryActions.removeAll();
            this.mySecondaryActionsButton = null;
            this.fillToolBar(this.myVisibleActions, this.getLayoutPolicy() == 2 && this.myOrientation == 0);
            Dimension newSize = this.getPreferredSize();
            ((WindowManagerEx)WindowManager.getInstance()).adjustContainerWindow(this, oldSize, newSize);
            if (shouldRebuildUI) {
                this.revalidate();
            } else {
                Container parent = this.getParent();
                if (parent != null) {
                    parent.invalidate();
                    parent.validate();
                }
            }
            this.repaint();
        }
    }

    public boolean hasVisibleActions() {
        return !this.myVisibleActions.isEmpty();
    }

    public void setTargetComponent(JComponent component) {
        this.myTargetComponent = component;
        if (this.myTargetComponent != null) {
            ActionToolbarImpl.updateWhenFirstShown(this.myTargetComponent, new ToolbarReference(this));
        }
    }

    private static void updateWhenFirstShown(JComponent targetComponent, final ToolbarReference ref) {
        Activatable.Adapter activatable = new Activatable.Adapter(){

            public void showNotify() {
                ActionToolbarImpl toolbar = (ActionToolbarImpl)ref.get();
                if (toolbar != null) {
                    toolbar.myUpdater.updateActions(false, false);
                }
            }
        };
        ref.myDisposable = (Disposable)new UiNotifyConnector(targetComponent, (Activatable)activatable){

            protected void showNotify() {
                super.showNotify();
                ref.disposeReference();
            }
        };
    }

    public DataContext getToolbarDataContext() {
        return this.getDataContext();
    }

    protected DataContext getDataContext() {
        return this.myTargetComponent != null ? this.myDataManager.getDataContext((Component)this.myTargetComponent) : ((DataManagerImpl)this.myDataManager).getDataContextTest(this);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (this.getLayoutPolicy() != 2) {
            return;
        }
        if (this.myAutoPopupRec != null && this.myAutoPopupRec.contains(e.getPoint())) {
            IdeFocusManager.getInstance(null).doWhenFocusSettlesDown(() -> this.showAutoPopup());
        }
    }

    private void showAutoPopup() {
        Point location;
        ActionGroup group;
        if (this.isPopupShowing()) {
            return;
        }
        if (this.myOrientation == 0) {
            group = this.myActionGroup;
        } else {
            DefaultActionGroup outside = new DefaultActionGroup();
            for (int i = this.myFirstOutsideIndex; i < this.myVisibleActions.size(); ++i) {
                outside.add(this.myVisibleActions.get(i));
            }
            group = outside;
        }
        PopupToolbar popupToolbar = new PopupToolbar(this.myPlace, group, true, this.myDataManager, this.myActionManager, this.myUpdater.getKeymapManager(), this){

            @Override
            protected void onOtherActionPerformed() {
                ActionToolbarImpl.this.hidePopup();
            }

            @Override
            protected DataContext getDataContext() {
                return ActionToolbarImpl.this.getDataContext();
            }
        };
        popupToolbar.setLayoutPolicy(0);
        popupToolbar.updateActionsImmediately();
        if (this.myOrientation == 0) {
            location = this.getLocationOnScreen();
        } else {
            location = this.getLocationOnScreen();
            location.y = location.y + this.getHeight() - popupToolbar.getPreferredSize().height;
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)popupToolbar, null);
        builder.setResizable(false).setMovable(true).setRequestFocus(false).setTitle(null).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelCallback(() -> {
            boolean toClose = this.myActionManager.isActionPopupStackEmpty();
            if (toClose) {
                this.myUpdater.updateActions(false, true);
            }
            return toClose;
        }).setCancelOnMouseOutCallback(new MouseChecker(){

            public boolean check(MouseEvent event) {
                return ActionToolbarImpl.this.myAutoPopupRec != null && ActionToolbarImpl.this.myActionManager.isActionPopupStackEmpty() && !new RelativeRectangle((Component)ActionToolbarImpl.this, ActionToolbarImpl.this.myAutoPopupRec).contains(new RelativePoint(event));
            }
        });
        builder.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                ActionToolbarImpl.this.processClosed();
            }
        });
        this.myPopup = builder.createPopup();
        final AnActionListener.Adapter listener2 = new AnActionListener.Adapter(){

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                JBPopup popup2 = ActionToolbarImpl.this.myPopup;
                if (popup2 != null && !popup2.isDisposed() && popup2.isVisible()) {
                    popup2.cancel();
                }
            }
        };
        ActionManager.getInstance().addAnActionListener((AnActionListener)listener2);
        Disposer.register((Disposable)this.myPopup, (Disposable)popupToolbar);
        Disposer.register((Disposable)popupToolbar, (Disposable)new Disposable(){

            public void dispose() {
                ActionManager.getInstance().removeAnActionListener((AnActionListener)listener2);
            }
        });
        this.myPopup.showInScreenCoordinates((Component)this, location);
        final Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            final ComponentAdapter componentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }
            };
            window.addComponentListener(componentAdapter);
            Disposer.register((Disposable)popupToolbar, (Disposable)new Disposable(){

                public void dispose() {
                    window.removeComponentListener(componentAdapter);
                }
            });
        }
    }

    private boolean isPopupShowing() {
        return this.myPopup != null && this.myPopup.getContent() != null;
    }

    private void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.processClosed();
        }
    }

    private void processClosed() {
        if (this.myPopup == null) {
            return;
        }
        Disposer.dispose((Disposable)this.myPopup);
        this.myPopup = null;
        this.myUpdater.updateActions(false, false);
    }

    public void setReservePlaceAutoPopupIcon(boolean reserve) {
        this.myReservePlaceAutoPopupIcon = reserve;
    }

    public void setSecondaryActionsTooltip(String secondaryActionsTooltip) {
        this.mySecondaryActions.getTemplatePresentation().setDescription(secondaryActionsTooltip);
    }

    public void setSecondaryActionsIcon(Icon icon) {
        this.mySecondaryActions.getTemplatePresentation().setIcon(icon);
    }

    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        List<AnAction> list2 = this.getActions();
        if (list2 == null) {
            ActionToolbarImpl.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    public List<AnAction> getActions() {
        AnAction[] kids;
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        ArrayList<AnAction> secondary = new ArrayList<AnAction>();
        for (AnAction each : kids = this.myActionGroup.getChildren(null)) {
            if (this.myActionGroup.isPrimary(each)) {
                result2.add(each);
                continue;
            }
            secondary.add(each);
        }
        result2.add((AnAction)new Separator());
        result2.addAll(secondary);
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            ActionToolbarImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public void setMiniMode(boolean minimalMode) {
        this.myMinimalMode = minimalMode;
        if (this.myMinimalMode) {
            this.setMinimumButtonSize((Dimension)JBUI.emptySize());
            this.setLayoutPolicy(0);
            this.setBorder((Border)JBUI.Borders.empty());
            this.setOpaque(false);
        } else {
            if (UIUtil.isUnderWin10LookAndFeel()) {
                this.setBorder(JBUI.Borders.empty((int)0));
                this.setMinimumButtonSize((Dimension)(this.myDecorateButtons ? JBUI.size((int)30, (int)20) : JBUI.size((int)25, (int)22)));
            } else {
                this.setBorder(JBUI.Borders.empty((int)2));
                this.setMinimumButtonSize((Dimension)(this.myDecorateButtons ? JBUI.size((int)30, (int)20) : DEFAULT_MINIMUM_BUTTON_SIZE));
            }
            this.setOpaque(true);
            this.setLayoutPolicy(2);
        }
        this.myUpdater.updateActions(false, true);
    }

    public void setAddSeparatorFirst(boolean addSeparatorFirst) {
        this.myAddSeparatorFirst = addSeparatorFirst;
        this.myUpdater.updateActions(false, true);
    }

    public Presentation getPresentation(AnAction action) {
        return this.myPresentationFactory.getPresentation(action);
    }

    public void clearPresentationCache() {
        this.myPresentationFactory.reset();
    }

    static {
        JBUI.addPropertyChangeListener((String)"JBUI.userScaleFactor", (PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ((JBDimension)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE).update();
                ((JBDimension)ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE).update();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapManager";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionComponent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tweakActionComponentUI";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setMinimumButtonSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PopupStateModifier {
        @ActionButtonComponent.ButtonState
        public int getModifiedPopupState();

        public boolean willModify();
    }

    static abstract class PopupToolbar
    extends ActionToolbarImpl
    implements AnActionListener,
    Disposable {
        private final JComponent myParent;

        public PopupToolbar(String place, ActionGroup actionGroup, boolean horizontal, DataManager dataManager, @NotNull ActionManagerEx actionManager, KeymapManagerEx keymapManager2, JComponent parent) {
            if (actionManager == null) {
                PopupToolbar.$$$reportNull$$$0(0);
            }
            super(place, actionGroup, horizontal, false, dataManager, actionManager, keymapManager2, true);
            this.myActionManager.addAnActionListener((AnActionListener)this);
            this.myParent = parent;
        }

        @Override
        public Container getParent() {
            Container parent = super.getParent();
            return parent != null ? parent : this.myParent;
        }

        public void dispose() {
            this.myActionManager.removeAnActionListener((AnActionListener)this);
        }

        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        }

        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            if (!this.myVisibleActions.contains(action)) {
                this.onOtherActionPerformed();
            }
        }

        protected abstract void onOtherActionPerformed();

        public void beforeEditorTyping(char c, DataContext dataContext) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$PopupToolbar", "<init>"));
        }
    }

    private final class MySeparator
    extends JComponent {
        private final JBDimension mySize;

        public MySeparator() {
            this.mySize = ActionToolbarImpl.this.myOrientation == 0 ? JBUI.size((int)6, (int)24) : JBUI.size((int)24, (int)6);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.mySize.size();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Insets i = this.getInsets();
            int gap = JBUI.scale((int)2);
            int offset = JBUI.scale((int)3);
            if (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula()) {
                if (this.getParent() != null) {
                    JBColor col = new JBColor((Color)Gray._128, (Color)Gray._111);
                    Graphics2D g2 = (Graphics2D)g;
                    if (ActionToolbarImpl.this.myOrientation == 0) {
                        UIUtil.drawDoubleSpaceDottedLine((Graphics2D)g2, (int)(i.top + gap), (int)(this.getParent().getSize().height - gap - i.top - i.bottom), (int)offset, (Color)col, (boolean)false);
                    } else {
                        UIUtil.drawDoubleSpaceDottedLine((Graphics2D)g2, (int)(i.left + gap), (int)(this.getParent().getSize().width - gap - i.left - i.right), (int)offset, (Color)col, (boolean)true);
                    }
                }
            } else {
                g.setColor(UIUtil.getSeparatorColor());
                if (this.getParent() != null) {
                    if (ActionToolbarImpl.this.myOrientation == 0) {
                        UIUtil.drawLine((Graphics)g, (int)offset, (int)gap, (int)offset, (int)(this.getParent().getSize().height - gap));
                    } else {
                        UIUtil.drawLine((Graphics)g, (int)gap, (int)offset, (int)(this.getParent().getSize().width - gap), (int)offset);
                    }
                }
            }
        }
    }

    private static class ToolbarReference
    extends WeakReference<ActionToolbarImpl> {
        private static final ReferenceQueue<ActionToolbarImpl> ourQueue = new ReferenceQueue();
        private volatile Disposable myDisposable;

        ToolbarReference(ActionToolbarImpl toolbar) {
            super(toolbar, ourQueue);
            ToolbarReference.processQueue();
        }

        private static void processQueue() {
            ToolbarReference ref;
            while ((ref = (ToolbarReference)ourQueue.poll()) != null) {
                ref.disposeReference();
            }
        }

        private void disposeReference() {
            Disposable disposable = this.myDisposable;
            if (disposable != null) {
                this.myDisposable = null;
                Disposer.dispose((Disposable)disposable);
            }
        }
    }
}

