/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.updater.StatisticsNotificationManager;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import java.awt.Window;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SendStatisticsComponent
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(SendStatisticsComponent.class);
    private static final int DELAY_IN_MIN = 10;
    private final FrameStateManager myFrameStateManager;

    public SendStatisticsComponent(@NotNull FrameStateManager frameStateManager) {
        if (frameStateManager == null) {
            SendStatisticsComponent.$$$reportNull$$$0(0);
        }
        NotificationsConfigurationImpl.remove("SendUsagesStatistics");
        NotificationsConfiguration.getNotificationsConfiguration().register("IDE Usage Statistics", NotificationDisplayType.STICKY_BALLOON, false);
        this.myFrameStateManager = frameStateManager;
    }

    private static boolean isEmpty(Window window) {
        BalloonLayout layout;
        if (window instanceof IdeFrameImpl && (layout = ((IdeFrameImpl)window).getBalloonLayout()) instanceof BalloonLayoutImpl) {
            return ((BalloonLayoutImpl)layout).isEmpty();
        }
        return false;
    }

    private void runStatisticsService() {
        final StatisticsService statisticsService = StatisticsUploadAssistant.getStatisticsService();
        if (StatisticsUploadAssistant.isShouldShowNotification()) {
            this.myFrameStateManager.addListener((FrameStateListener)new FrameStateListener.Adapter(){

                public void onFrameActivated() {
                    if (SendStatisticsComponent.isEmpty(((WindowManagerEx)WindowManager.getInstance()).getMostRecentFocusedWindow())) {
                        ApplicationManager.getApplication().invokeLater(() -> StatisticsNotificationManager.showNotification(statisticsService));
                        SendStatisticsComponent.this.myFrameStateManager.removeListener((FrameStateListener)this);
                    }
                }
            });
        } else if (StatisticsUploadAssistant.isSendAllowed() && StatisticsUploadAssistant.isTimeToSend()) {
            SendStatisticsComponent.runWithDelay(statisticsService);
        }
    }

    private static void runWithDelay(@NotNull StatisticsService statisticsService) {
        if (statisticsService == null) {
            SendStatisticsComponent.$$$reportNull$$$0(1);
        }
        JobScheduler.getScheduler().schedule(statisticsService::send, 10L, TimeUnit.MINUTES);
    }

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.runStatisticsService();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameStateManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statisticsService";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/updater/SendStatisticsComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithDelay";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

