/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.intellij.IntelliJCheckBoxUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class WinIntelliJCheckBoxUI
extends IntelliJCheckBoxUI {
    public static ComponentUI createUI(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        b.setRolloverEnabled(true);
        return new WinIntelliJCheckBoxUI();
    }

    @Override
    protected void drawCheckIcon(JComponent c, Graphics2D g, JCheckBox b, Rectangle iconRect, boolean selected, boolean enabled) {
        ButtonModel bm = b.getModel();
        boolean focused = c.hasFocus() || bm.isRollover() || WinIntelliJCheckBoxUI.isCellRollover(b);
        boolean pressed = bm.isPressed() || WinIntelliJCheckBoxUI.isCellPressed(b);
        String iconName = this.isIndeterminate(b) ? "checkBoxIndeterminate" : "checkBox";
        Icon icon = MacIntelliJIconCache.getIcon(iconName, false, selected || this.isIndeterminate(b), focused, enabled, pressed);
        int x = (iconRect.width - icon.getIconWidth()) / 2 + iconRect.x;
        int y = (iconRect.height - icon.getIconHeight()) / 2 + iconRect.y;
        icon.paintIcon(c, g, x, y);
    }

    @Override
    protected void drawText(JComponent c, Graphics2D g, JCheckBox b, FontMetrics fm, Rectangle textRect, String text) {
        textRect.y -= JBUI.scale((int)1);
        super.drawText(c, g, b, fm, textRect, text);
    }

    private static boolean isCellRollover(JCheckBox checkBox) {
        Rectangle cellPosition = (Rectangle)checkBox.getClientProperty("JCheckBox.rollOver.rectangle");
        return cellPosition != null && cellPosition.getBounds().equals(checkBox.getBounds());
    }

    private static boolean isCellPressed(JCheckBox checkBox) {
        Rectangle cellPosition = (Rectangle)checkBox.getClientProperty("JCheckBox.pressed.rectangle");
        return cellPosition != null && cellPosition.getBounds().equals(checkBox.getBounds());
    }

    @Override
    public Icon getDefaultIcon() {
        return ((EmptyIcon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)18))).asUIResource();
    }

    @Override
    protected boolean fillBackgroundForIndeterminateSameAsForSelected() {
        return false;
    }
}

