/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.ide.gdpr.ConfirmedConsent;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.Locations;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsentOptions {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.gdpr.ConsentOptions");
    private static final String CONSENTS_CONFIRMATION_PROPERTY = "jb.consents.confirmation.enabled";
    private static final String BUNDLED_RESOURCE_PATH = "/consents.json";
    private static final String STATISTICS_OPTION_ID = "rsch.send.usage.stat";
    private final IOBackend myBackend;

    ConsentOptions(IOBackend backend) {
        this.myBackend = backend;
    }

    public static ConsentOptions getInstance() {
        return InstanceHolder.ourInstance;
    }

    public Permission isSendingUsageStatsAllowed() {
        ConfirmedConsent confirmedConsent = this.getConfirmedConsent(STATISTICS_OPTION_ID);
        return confirmedConsent == null ? Permission.UNDEFINED : (confirmedConsent.isAccepted() ? Permission.YES : Permission.NO);
    }

    public boolean setSendingUsageStatsAllowed(boolean allowed) {
        Consent defConsent = this.loadDefaultConsents().get(STATISTICS_OPTION_ID);
        if (defConsent != null && !defConsent.isDeleted()) {
            this.saveConfirmedConsents(Collections.singleton(new ConfirmedConsent(defConsent.getId(), defConsent.getVersion(), allowed, 0L)));
            return true;
        }
        return false;
    }

    @Nullable
    public String getConfirmedConsentsString() {
        Map<String, Consent> defaults = this.loadDefaultConsents();
        if (!defaults.isEmpty()) {
            String str = ConsentOptions.confirmedConsentToExternalString(this.loadConfirmedConsents().values().stream().filter(c -> {
                Consent def = (Consent)defaults.get(c.getId());
                return def != null && !def.isDeleted();
            }));
            return StringUtil.isEmptyOrSpaces((String)str) ? null : str;
        }
        return null;
    }

    public void applyServerUpdates(@Nullable String json) {
        if (StringUtil.isEmptyOrSpaces((String)json)) {
            return;
        }
        try {
            Map<String, ConfirmedConsent> confirmed;
            Collection<ConsentAttributes> fromServer = ConsentOptions.fromJson(json);
            Map<String, Consent> defaults = this.loadDefaultConsents();
            if (ConsentOptions.applyServerChangesToDefaults(defaults, fromServer)) {
                this.myBackend.writeDefaultConsents(ConsentOptions.consentsToJson(defaults.values().stream()));
            }
            if (ConsentOptions.applyServerChangesToConfirmedConsents(confirmed = this.loadConfirmedConsents(), fromServer)) {
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(confirmed.values().stream()));
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    public Pair<Collection<Consent>, Boolean> getConsents() {
        Map<String, Consent> allDefaults = this.loadDefaultConsents();
        if (allDefaults.isEmpty()) {
            return Pair.create(Collections.emptyList(), (Object)Boolean.FALSE);
        }
        Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
        ArrayList<Consent> result2 = new ArrayList<Consent>();
        for (Map.Entry<String, Consent> entry : allDefaults.entrySet()) {
            Consent base = entry.getValue();
            if (base.isDeleted()) continue;
            ConfirmedConsent confirmed = allConfirmed.get(base.getId());
            result2.add(confirmed == null ? base : base.derive(confirmed.isAccepted()));
        }
        Collections.sort(result2, Comparator.comparing(o -> o.getId()));
        Boolean confirmationEnabled = Boolean.valueOf(System.getProperty(CONSENTS_CONFIRMATION_PROPERTY, "true"));
        return Pair.create(result2, (Object)(confirmationEnabled != false && ConsentOptions.needReconfirm(allDefaults, allConfirmed) ? 1 : 0));
    }

    public void setConsents(Collection<Consent> confirmedByUser) {
        this.saveConfirmedConsents(confirmedByUser.stream().map(c -> new ConfirmedConsent(c.getId(), c.getVersion(), c.isAccepted(), 0L)).collect(Collectors.toList()));
    }

    @Nullable
    private ConfirmedConsent getConfirmedConsent(String consentId) {
        Consent defConsent = this.loadDefaultConsents().get(consentId);
        if (defConsent != null && defConsent.isDeleted()) {
            return null;
        }
        return this.loadConfirmedConsents().get(consentId);
    }

    private void saveConfirmedConsents(@NotNull Collection<ConfirmedConsent> updates) {
        if (updates == null) {
            ConsentOptions.$$$reportNull$$$0(0);
        }
        if (!updates.isEmpty()) {
            try {
                Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
                long stamp = System.currentTimeMillis();
                for (ConfirmedConsent consent : updates) {
                    consent.setAcceptanceTime(stamp);
                    allConfirmed.put(consent.getId(), consent);
                }
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(allConfirmed.values().stream()));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private static boolean needReconfirm(Map<String, Consent> defaults, Map<String, ConfirmedConsent> confirmed) {
        for (Consent defConsent : defaults.values()) {
            Version defaultVersion;
            if (defConsent.isDeleted()) continue;
            ConfirmedConsent confirmedConsent = confirmed.get(defConsent.getId());
            if (confirmedConsent == null) {
                return true;
            }
            Version confirmedVersion = confirmedConsent.getVersion();
            if (!confirmedVersion.isOlder(defaultVersion = defConsent.getVersion()) || confirmedVersion.getMajor() == defaultVersion.getMajor()) continue;
            return true;
        }
        return false;
    }

    private static boolean applyServerChangesToConfirmedConsents(Map<String, ConfirmedConsent> base, Collection<ConsentAttributes> fromServer) {
        boolean changes = false;
        for (ConsentAttributes update : fromServer) {
            ConfirmedConsent change;
            ConfirmedConsent current = base.get(update.consentId);
            if (current == null || (change = new ConfirmedConsent(update)).getVersion().isOlder(current.getVersion()) || current.getAcceptanceTime() >= update.acceptanceTime) continue;
            base.put(change.getId(), change);
            changes = true;
        }
        return changes;
    }

    private static boolean applyServerChangesToDefaults(Map<String, Consent> base, Collection<ConsentAttributes> fromServer) {
        boolean changes = false;
        for (ConsentAttributes update : fromServer) {
            Consent newConsent = new Consent(update);
            Consent current = base.get(newConsent.getId());
            if (current != null && !newConsent.getVersion().isNewer(current.getVersion()) && newConsent.isDeleted() == current.isDeleted()) continue;
            base.put(newConsent.getId(), newConsent);
            changes = true;
        }
        return changes;
    }

    @NotNull
    private static Collection<ConsentAttributes> fromJson(String json) {
        block4: {
            List<ConsentAttributes> list2;
            try {
                ConsentAttributes[] data;
                ConsentAttributes[] consentAttributesArray = data = StringUtil.isEmptyOrSpaces((String)json) ? null : (ConsentAttributes[])new GsonBuilder().disableHtmlEscaping().create().fromJson(json, ConsentAttributes[].class);
                if (data == null) break block4;
                list2 = Arrays.asList(data);
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            if (list2 == null) {
                ConsentOptions.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<ConsentAttributes> list3 = Collections.emptyList();
        if (list3 == null) {
            ConsentOptions.$$$reportNull$$$0(2);
        }
        return list3;
    }

    private static String consentsToJson(Stream<Consent> consents) {
        return ConsentOptions.consentAttributesToJson(consents.map(consent -> consent.toConsentAttributes()));
    }

    private static String consentAttributesToJson(Stream<ConsentAttributes> attributes) {
        Gson gson2 = new GsonBuilder().disableHtmlEscaping().create();
        return gson2.toJson((Object)attributes.toArray());
    }

    private static String confirmedConsentToExternalString(Stream<ConfirmedConsent> consents) {
        return StringUtil.join((Collection)consents.map(c -> c.toExternalString()).collect(Collectors.toList()), (String)";");
    }

    @NotNull
    private Map<String, Consent> loadDefaultConsents() {
        HashMap<String, Consent> result2 = new HashMap<String, Consent>();
        for (ConsentAttributes attributes : ConsentOptions.fromJson(this.myBackend.readBundledConsents())) {
            result2.put(attributes.consentId, new Consent(attributes));
        }
        try {
            ConsentOptions.applyServerChangesToDefaults(result2, ConsentOptions.fromJson(this.myBackend.readDefaultConsents()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, Consent> hashMap = result2;
        if (hashMap == null) {
            ConsentOptions.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, ConfirmedConsent> loadConfirmedConsents() {
        HashMap<String, ConfirmedConsent> result2 = new HashMap<String, ConfirmedConsent>();
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.myBackend.readConfirmedConsents(), ";", false);
            while (tokenizer.hasMoreTokens()) {
                ConfirmedConsent consent = ConfirmedConsent.fromString(tokenizer.nextToken());
                if (consent == null) continue;
                result2.put(consent.getId(), consent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, ConfirmedConsent> hashMap = result2;
        if (hashMap == null) {
            ConsentOptions.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromJson";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultConsents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfirmedConsents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveConfirmedConsents";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface IOBackend {
        public void writeDefaultConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readDefaultConsents() throws IOException;

        @NotNull
        public String readBundledConsents();

        public void writeConfirmedConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readConfirmedConsents() throws IOException;
    }

    public static enum Permission {
        YES,
        NO,
        UNDEFINED;

    }

    private static final class InstanceHolder {
        static final ConsentOptions ourInstance = new ConsentOptions(new IOBackend(){
            private final File DEFAULT_CONSENTS_FILE = new File(Locations.getDataRoot(), ApplicationNamesInfo.getInstance().getLowercaseProductName() + "/consentOptions/cached");
            private final File CONFIRMED_CONSENTS_FILE = new File(Locations.getDataRoot(), "/consentOptions/accepted");

            @Override
            public void writeDefaultConsents(@NotNull String data) throws IOException {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileUtil.writeToFile((File)this.DEFAULT_CONSENTS_FILE, (String)data);
            }

            @Override
            @NotNull
            public String readDefaultConsents() throws IOException {
                String string = this.loadText(new FileInputStream(this.DEFAULT_CONSENTS_FILE));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            public String readBundledConsents() {
                String string = this.loadText(ConsentOptions.class.getResourceAsStream(ConsentOptions.BUNDLED_RESOURCE_PATH));
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            public void writeConfirmedConsents(@NotNull String data) throws IOException {
                if (data == null) {
                    1.$$$reportNull$$$0(3);
                }
                FileUtil.writeToFile((File)this.CONFIRMED_CONSENTS_FILE, (String)data);
            }

            @Override
            @NotNull
            public String readConfirmedConsents() throws IOException {
                String string = this.loadText(new FileInputStream(this.CONFIRMED_CONSENTS_FILE));
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @NotNull
            private String loadText(InputStream stream) {
                block7: {
                    if (stream == null) break block7;
                    InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(stream), StandardCharsets.UTF_8);
                    String string = new String(FileUtil.adaptiveLoadText((Reader)reader));
                    ((Reader)reader).close();
                    String string2 = string;
                    if (string2 == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return string2;
                    {
                        catch (Throwable throwable) {
                            try {
                                ((Reader)reader).close();
                                throw throwable;
                            }
                            catch (IOException e) {
                                LOG.info((Throwable)e);
                            }
                        }
                    }
                }
                if ("" == null) {
                    1.$$$reportNull$$$0(6);
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "data";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readDefaultConsents";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readBundledConsents";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "readConfirmedConsents";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "loadText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "writeDefaultConsents";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "writeConfirmedConsents";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });

        private InstanceHolder() {
        }
    }
}

