/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.DisplayChangeDetector;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.platform.win32.User32;

public class RemoteDesktopDetector
extends RemoteDesktopService {
    private static final Logger LOG = Logger.getInstance(RemoteDesktopDetector.class);
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Remote Desktop", NotificationDisplayType.BALLOON, false);
    private volatile boolean myFailureDetected;
    private volatile boolean myRemoteDesktopConnected;

    private RemoteDesktopDetector() {
        if (SystemInfo.isWindows) {
            DisplayChangeDetector.getInstance().addListener(new DisplayChangeDetector.Listener(){

                @Override
                public void displayChanged() {
                    RemoteDesktopDetector.this.updateState();
                }
            });
            this.updateState();
        }
    }

    private void updateState() {
        if (!this.myFailureDetected) {
            try {
                boolean newValue = User32.INSTANCE.GetSystemMetrics(4096) != 0;
                LOG.debug("Detected remote desktop: ", new Object[]{newValue});
                if (newValue != this.myRemoteDesktopConnected) {
                    this.myRemoteDesktopConnected = newValue;
                    if (this.myRemoteDesktopConnected) {
                        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)NOTIFICATION_GROUP.createNotification(ApplicationBundle.message((String)"remote.desktop.detected.message", (Object[])new Object[0]), NotificationType.INFORMATION).setTitle(ApplicationBundle.message((String)"remote.desktop.detected.title", (Object[])new Object[0]))));
                    }
                }
            }
            catch (Throwable e) {
                this.myRemoteDesktopConnected = false;
                this.myFailureDetected = true;
                LOG.warn("Error while calling GetSystemMetrics", e);
            }
        }
    }

    public boolean isRemoteDesktopConnected() {
        return this.myRemoteDesktopConnected;
    }
}

