/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FormatterTagHandler {
    private final CodeStyleSettings mySettings;

    public FormatterTagHandler(CodeStyleSettings settings) {
        this.mySettings = settings;
    }

    public FormatterTag getFormatterTag(Block block) {
        if (this.mySettings.FORMATTER_TAGS_ENABLED && !StringUtil.isEmpty((String)this.mySettings.FORMATTER_ON_TAG) && !StringUtil.isEmpty((String)this.mySettings.FORMATTER_OFF_TAG)) {
            if (block instanceof ASTBlock) {
                PsiElement element;
                ASTNode node = ((ASTBlock)block).getNode();
                if (node != null && (element = node.getPsi()) != null && element instanceof PsiComment) {
                    return this.getFormatterTag((PsiComment)element);
                }
            } else if (block instanceof InjectedLanguageBlockWrapper) {
                return this.getFormatterTag(((InjectedLanguageBlockWrapper)block).getOriginal());
            }
        }
        return FormatterTag.NONE;
    }

    protected FormatterTag getFormatterTag(@NotNull PsiComment comment) {
        if (comment == null) {
            FormatterTagHandler.$$$reportNull$$$0(0);
        }
        CharSequence nodeChars = comment.getNode().getChars();
        if (this.mySettings.FORMATTER_TAGS_ACCEPT_REGEXP) {
            Pattern onPattern = this.mySettings.getFormatterOnPattern();
            Pattern offPattern = this.mySettings.getFormatterOffPattern();
            if (onPattern != null && onPattern.matcher(nodeChars).find()) {
                return FormatterTag.ON;
            }
            if (offPattern != null && offPattern.matcher(nodeChars).find()) {
                return FormatterTag.OFF;
            }
        } else {
            for (int i = 0; i < nodeChars.length(); ++i) {
                if (FormatterTagHandler.isFormatterTagAt(nodeChars, i, this.mySettings.FORMATTER_ON_TAG)) {
                    return FormatterTag.ON;
                }
                if (!FormatterTagHandler.isFormatterTagAt(nodeChars, i, this.mySettings.FORMATTER_OFF_TAG)) continue;
                return FormatterTag.OFF;
            }
        }
        return FormatterTag.NONE;
    }

    private static boolean isFormatterTagAt(@NotNull CharSequence s, int pos, @NotNull String tagName) {
        int end;
        if (s == null) {
            FormatterTagHandler.$$$reportNull$$$0(1);
        }
        if (tagName == null) {
            FormatterTagHandler.$$$reportNull$$$0(2);
        }
        if (!tagName.isEmpty() && tagName.charAt(0) == s.charAt(pos) && (end = pos + tagName.length()) <= s.length()) {
            return StringUtil.equalsIgnoreCase((CharSequence)s.subSequence(pos, end), (CharSequence)tagName);
        }
        return false;
    }

    public List<TextRange> getEnabledRanges(ASTNode rootNode, TextRange initialRange) {
        EnabledRangesCollector collector = new EnabledRangesCollector(initialRange);
        rootNode.getPsi().accept((PsiElementVisitor)collector);
        return collector.getRanges();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/FormatterTagHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFormatterTag";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isFormatterTagAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class EnabledRangesCollector
    extends PsiRecursiveElementVisitor {
        private final List<FormatterTagInfo> myTagInfoList = new ArrayList<FormatterTagInfo>();
        private final TextRange myInitialRange;

        private EnabledRangesCollector(TextRange initialRange) {
            this.myInitialRange = initialRange;
        }

        public void visitComment(PsiComment comment) {
            FormatterTag tag = FormatterTagHandler.this.getFormatterTag(comment);
            switch (tag) {
                case OFF: {
                    this.myTagInfoList.add(new FormatterTagInfo(comment.getTextRange().getEndOffset(), FormatterTag.OFF));
                    break;
                }
                case ON: {
                    this.myTagInfoList.add(new FormatterTagInfo(comment.getTextRange().getEndOffset(), FormatterTag.ON));
                }
            }
        }

        private List<TextRange> getRanges() {
            ArrayList<TextRange> enabledRanges = new ArrayList<TextRange>();
            Collections.sort(this.myTagInfoList, (tagInfo1, tagInfo2) -> tagInfo1.offset - tagInfo2.offset);
            int start = this.myInitialRange.getStartOffset();
            boolean formatterEnabled = true;
            for (FormatterTagInfo tagInfo : this.myTagInfoList) {
                if (tagInfo.tag == FormatterTag.OFF && formatterEnabled) {
                    if (tagInfo.offset > start) {
                        TextRange range = new TextRange(start, tagInfo.offset);
                        enabledRanges.add(range);
                    }
                    formatterEnabled = false;
                    continue;
                }
                if (tagInfo.tag != FormatterTag.ON || formatterEnabled) continue;
                start = Math.max(tagInfo.offset, this.myInitialRange.getStartOffset());
                if (start >= this.myInitialRange.getEndOffset()) break;
                formatterEnabled = true;
            }
            if (start < this.myInitialRange.getEndOffset() && formatterEnabled) {
                enabledRanges.add(new TextRange(start, this.myInitialRange.getEndOffset()));
            }
            return enabledRanges;
        }

        private class FormatterTagInfo {
            public int offset;
            public FormatterTag tag;

            private FormatterTagInfo(int offset, FormatterTag tag) {
                this.offset = offset;
                this.tag = tag;
            }
        }
    }

    public static enum FormatterTag {
        ON,
        OFF,
        NONE;

    }
}

