/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class TestsProgressAnimator
implements Runnable,
Disposable {
    private static final int FRAMES_COUNT = 8;
    private static final int MOVIE_TIME = 800;
    private static final int FRAME_TIME = 100;
    public static final Icon[] FRAMES = new Icon[8];
    private long myLastInvocationTime = -1L;
    private Alarm myAlarm;
    private AbstractTestProxy myCurrentTestCase;
    private AbstractTestTreeBuilder myTreeBuilder;

    public TestsProgressAnimator(AbstractTestTreeBuilder builder) {
        Disposer.register((Disposable)builder, (Disposable)this);
        this.init(builder);
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 800L / 100L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[TestsProgressAnimator.getCurrentFrameIndex()];
    }

    protected void init(AbstractTestTreeBuilder treeBuilder) {
        this.myAlarm = new Alarm();
        this.myTreeBuilder = treeBuilder;
    }

    public AbstractTestProxy getCurrentTestCase() {
        return this.myCurrentTestCase;
    }

    @Override
    public void run() {
        long time;
        if (this.myCurrentTestCase != null && (time = System.currentTimeMillis()) - this.myLastInvocationTime >= 100L) {
            this.repaintSubTree();
            this.myLastInvocationTime = time;
        }
        this.scheduleRepaint();
    }

    public void setCurrentTestCase(@Nullable AbstractTestProxy currentTestCase) {
        this.myCurrentTestCase = currentTestCase;
        this.scheduleRepaint();
    }

    public void stopMovie() {
        this.repaintSubTree();
        this.setCurrentTestCase(null);
        this.cancelAlarm();
    }

    public void dispose() {
        this.myTreeBuilder = null;
        this.myCurrentTestCase = null;
        this.cancelAlarm();
    }

    private void cancelAlarm() {
        if (this.myAlarm != null) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm = null;
        }
    }

    private void repaintSubTree() {
        if (this.myTreeBuilder != null && this.myCurrentTestCase != null) {
            this.myTreeBuilder.repaintWithParents(this.myCurrentTestCase);
        }
    }

    private void scheduleRepaint() {
        if (this.myAlarm == null) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        if (this.myCurrentTestCase != null) {
            this.myAlarm.addRequest((Runnable)this, 100);
        }
    }

    static {
        TestsProgressAnimator.FRAMES[0] = AllIcons.RunConfigurations.TestInProgress1;
        TestsProgressAnimator.FRAMES[1] = AllIcons.RunConfigurations.TestInProgress2;
        TestsProgressAnimator.FRAMES[2] = AllIcons.RunConfigurations.TestInProgress3;
        TestsProgressAnimator.FRAMES[3] = AllIcons.RunConfigurations.TestInProgress4;
        TestsProgressAnimator.FRAMES[4] = AllIcons.RunConfigurations.TestInProgress5;
        TestsProgressAnimator.FRAMES[5] = AllIcons.RunConfigurations.TestInProgress6;
        TestsProgressAnimator.FRAMES[6] = AllIcons.RunConfigurations.TestInProgress7;
        TestsProgressAnimator.FRAMES[7] = AllIcons.RunConfigurations.TestInProgress8;
    }
}

