/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.errorreport.bean;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.util.ExceptionUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class ErrorBean {
    private String lastAction;
    private String pluginName;
    private String pluginVersion;
    private Integer previousException;
    private String message;
    private String stackTrace;
    private String description;
    private Integer assigneeId;
    private List<Attachment> attachments = Collections.emptyList();

    public ErrorBean(Throwable throwable, String lastAction) {
        if (throwable != null) {
            this.message = throwable.getMessage();
            this.stackTrace = ExceptionUtil.getThrowableText((Throwable)throwable);
        }
        this.lastAction = lastAction;
    }

    public Integer getPreviousException() {
        return this.previousException;
    }

    public void setPreviousException(Integer previousException) {
        this.previousException = previousException;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public String getLastAction() {
        return this.lastAction;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(@NonNls String description) {
        this.description = description;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Integer getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(Integer assigneeId) {
        this.assigneeId = assigneeId;
    }
}

