/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final List<? extends EditorEx> myEditors;
    @Nullable
    private final MergeInnerDifferences myInnerFragments;
    private int[] myLineStarts;
    private int[] myLineEnds;

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @Nullable MergeInnerDifferences innerFragments, @NotNull SimpleThreesideDiffViewer viewer) {
        if (fragment == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(0);
        }
        if (conflictType == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(1);
        }
        if (viewer == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(2);
        }
        super(conflictType);
        this.myLineStarts = new int[3];
        this.myLineEnds = new int[3];
        this.myEditors = viewer.getEditors();
        this.myInnerFragments = innerFragments;
        for (ThreeSide side : ThreeSide.values()) {
            this.myLineStarts[side.getIndex()] = fragment.getStartLine(side);
            this.myLineEnds[side.getIndex()] = fragment.getEndLine(side);
        }
        this.reinstallHighlighters();
    }

    public void destroy() {
        this.destroyHighlighters();
        this.destroyInnerHighlighters();
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(3);
        }
        return side.select(this.myLineStarts);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(4);
        }
        return side.select(this.myLineEnds);
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(5);
        }
        return false;
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(6);
        }
        Editor editor = (Editor)side.select(this.myEditors);
        if (editor == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(7);
        }
        return editor;
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.myInnerFragments;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        if (side == null) {
            SimpleThreesideDiffChange.$$$reportNull$$$0(8);
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        this.myLineStarts[sideIndex] = newRange.startLine;
        this.myLineEnds[sideIndex] = newRange.endLine;
        return newRange.damaged;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleThreesideDiffChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleThreesideDiffChange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStartLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEndLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

