/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.AllLinesIterator;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.OnesideTextDiffViewer;
import com.intellij.diff.tools.util.text.TextDiffProvider;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleOnesideDiffViewer
extends OnesideTextDiffViewer {
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final TextDiffProvider myTextDiffProvider;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;

    public SimpleOnesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, (ContentDiffRequest)request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myTextDiffProvider = DiffUtil.createTextDiffProvider(this.getProject(), this.getRequest(), this.getTextSettings(), this::rediff, (Disposable)this);
    }

    @Override
    protected void onDispose() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(4);
        }
        Runnable runnable2 = () -> {
            boolean shouldHighlight;
            this.clearDiffPresentation();
            boolean bl = shouldHighlight = this.getTextSettings().getHighlightPolicy() != HighlightPolicy.DO_NOT_HIGHLIGHT;
            if (shouldHighlight) {
                DocumentContent content = this.getContent();
                Document document = content.getDocument();
                TextDiffType type = (TextDiffType)this.getSide().select((Object)TextDiffType.DELETED, (Object)TextDiffType.INSERTED);
                this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(this.getEditor(), 0, DiffUtil.getLineCount(document), type, false));
            }
            this.myInitialScrollHelper.onRediff();
        };
        if (runnable2 == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(5);
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    private void doScrollToChange(boolean animated) {
        DiffUtil.moveCaret(this.getEditor(), 0);
        DiffUtil.scrollEditor(this.getEditor(), 0, animated);
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        if (context == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(6);
        }
        if (this.getSide().isLeft()) {
            return false;
        }
        AllLinesIterator allLinesIterator = new AllLinesIterator(this.getEditor().getDocument());
        int line = context.contextMatchCheck((Iterator)allLinesIterator);
        if (line == -1) {
            return false;
        }
        this.scrollToLine(line);
        return true;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(7);
        }
        if (request == null) {
            SimpleOnesideDiffViewer.$$$reportNull$$$0(8);
        }
        return OnesideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId)) {
            int lineCount = DiffUtil.getLineCount(this.getEditor().getDocument());
            return new LineRange(0, lineCount);
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleOnesideDiffViewer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "performRediff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRediff";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyInitialScrollHelper
    extends OnesideTextDiffViewer.MyInitialScrollPositionHelper {
        private MyInitialScrollHelper() {
            super(SimpleOnesideDiffViewer.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            SimpleOnesideDiffViewer.this.doScrollToChange(false);
            return true;
        }

        @Override
        protected boolean doScrollToFirstChange() {
            SimpleOnesideDiffViewer.this.doScrollToChange(false);
            return true;
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            return SimpleOnesideDiffViewer.this.doScrollToContext(this.myNavigationContext);
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition position = (LogicalPosition)SimpleOnesideDiffViewer.this.getSide().select((Object[])this.myCaretPosition);
            SimpleOnesideDiffViewer.this.getEditor().getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint(SimpleOnesideDiffViewer.this.getEditor(), this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret(SimpleOnesideDiffViewer.this.getEditor(), false);
            }
            return true;
        }

        @Override
        @Nullable
        protected LogicalPosition[] getCaretPositions() {
            int index = SimpleOnesideDiffViewer.this.getSide().getIndex();
            int otherIndex = SimpleOnesideDiffViewer.this.getSide().other().getIndex();
            LogicalPosition[] carets = new LogicalPosition[2];
            carets[index] = SimpleOnesideDiffViewer.this.getEditor().getCaretModel().getLogicalPosition();
            carets[otherIndex] = new LogicalPosition(0, 0);
            return carets;
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyReadOnlyLockAction() {
            super(SimpleOnesideDiffViewer.this.getContext(), SimpleOnesideDiffViewer.this.getEditableEditors());
        }
    }
}

