/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffTool {
    private static final Logger LOG = Logger.getInstance(ExternalDiffTool.class);

    public static boolean isDefault() {
        return ExternalDiffSettings.getInstance().isDiffEnabled() && ExternalDiffSettings.getInstance().isDiffDefault();
    }

    public static boolean isEnabled() {
        return ExternalDiffSettings.getInstance().isDiffEnabled();
    }

    public static void show(final @Nullable Project project, final @NotNull DiffRequestChain chain, @NotNull DiffDialogHints hints) {
        if (chain == null) {
            ExternalDiffTool.$$$reportNull$$$0(0);
        }
        if (hints == null) {
            ExternalDiffTool.$$$reportNull$$$0(1);
        }
        try {
            final Ref requestsRef = new Ref();
            final Ref exceptionRef = new Ref();
            ProgressManager.getInstance().run((Task)new Task.Modal(project, "Loading Requests", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        requestsRef.set((Object)ExternalDiffTool.collectRequests(project, chain, indicator));
                    }
                    catch (Throwable e) {
                        exceptionRef.set((Object)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/external/ExternalDiffTool$1", "run"));
                }
            });
            if (!exceptionRef.isNull()) {
                throw (Throwable)exceptionRef.get();
            }
            ArrayList<DiffRequest> showInBuiltin = new ArrayList<DiffRequest>();
            for (DiffRequest request : (List)requestsRef.get()) {
                if (ExternalDiffTool.canShow(request)) {
                    ExternalDiffTool.showRequest(project, request);
                    continue;
                }
                showInBuiltin.add(request);
            }
            if (!showInBuiltin.isEmpty()) {
                DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)new SimpleDiffRequestChain(showInBuiltin), hints);
            }
        }
        catch (ProcessCanceledException requestsRef) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)"Can't Show Diff In External Tool");
        }
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project, @NotNull DiffRequestChain chain, @NotNull ProgressIndicator indicator) {
        if (chain == null) {
            ExternalDiffTool.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            ExternalDiffTool.$$$reportNull$$$0(3);
        }
        ArrayList<DiffRequest> requests = new ArrayList<DiffRequest>();
        UserDataHolderBase context = new UserDataHolderBase();
        ArrayList<String> errorRequests = new ArrayList<String>();
        List<DiffRequestProducer> producers = Collections.singletonList(chain.getRequests().get(chain.getIndex()));
        for (DiffRequestProducer producer : producers) {
            try {
                requests.add(producer.process((UserDataHolder)context, indicator));
            }
            catch (DiffRequestProducerException e) {
                LOG.warn((Throwable)e);
                errorRequests.add(producer.getName());
            }
        }
        if (!errorRequests.isEmpty()) {
            new Notification("Diff", "Can't Load Some Changes", StringUtil.join(errorRequests, (String)"<br>"), NotificationType.ERROR).notify(project);
        }
        ArrayList<DiffRequest> arrayList = requests;
        if (arrayList == null) {
            ExternalDiffTool.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static void showRequest(@Nullable Project project, @NotNull DiffRequest request) throws ExecutionException, IOException {
        if (request == null) {
            ExternalDiffTool.$$$reportNull$$$0(5);
        }
        request.onAssigned(true);
        ExternalDiffSettings settings = ExternalDiffSettings.getInstance();
        List contents = ((ContentDiffRequest)request).getContents();
        List titles = ((ContentDiffRequest)request).getContentTitles();
        ExternalDiffToolUtil.execute(settings, contents, titles, request.getTitle());
        request.onAssigned(false);
    }

    public static boolean canShow(@NotNull DiffRequest request) {
        if (request == null) {
            ExternalDiffTool.$$$reportNull$$$0(6);
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2 && contents.size() != 3) {
            return false;
        }
        for (DiffContent content : contents) {
            if (ExternalDiffToolUtil.canCreateFile(content)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/external/ExternalDiffTool";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/external/ExternalDiffTool";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectRequests";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showRequest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canShow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

