/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.codeInsight.preview.PreviewHintProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementPreviewHintProvider
implements ElementPreviewProvider {
    private static final Logger LOG = Logger.getInstance(ElementPreviewHintProvider.class);
    private static final int HINT_HIDE_FLAGS = 122;
    @Nullable
    private LightweightHint hint;

    public boolean isSupportedFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ElementPreviewHintProvider.$$$reportNull$$$0(0);
        }
        for (PreviewHintProvider hintProvider : (PreviewHintProvider[])Extensions.getExtensions((ExtensionPointName)PreviewHintProvider.EP_NAME)) {
            if (!hintProvider.isSupportedFile(psiFile)) continue;
            return true;
        }
        return false;
    }

    public void show(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Point point, boolean keyTriggered) {
        if (element == null) {
            ElementPreviewHintProvider.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ElementPreviewHintProvider.$$$reportNull$$$0(2);
        }
        if (point == null) {
            ElementPreviewHintProvider.$$$reportNull$$$0(3);
        }
        LightweightHint newHint = ElementPreviewHintProvider.getHint(element);
        this.hideCurrentHintIfAny();
        if (newHint == null) {
            return;
        }
        this.hint = newHint;
        HintManagerImpl.getInstanceImpl().showEditorHint(newHint, editor, HintManagerImpl.getHintPosition(newHint, editor, editor.xyToLogicalPosition(point), (short)5), 122, 0, false);
    }

    private void hideCurrentHintIfAny() {
        if (this.hint != null) {
            this.hint.hide();
            this.hint = null;
        }
    }

    public void hide(@Nullable PsiElement element, @NotNull Editor editor) {
        if (editor == null) {
            ElementPreviewHintProvider.$$$reportNull$$$0(4);
        }
        this.hideCurrentHintIfAny();
    }

    @Nullable
    private static LightweightHint getHint(@NotNull PsiElement element) {
        if (element == null) {
            ElementPreviewHintProvider.$$$reportNull$$$0(5);
        }
        for (PreviewHintProvider hintProvider : (PreviewHintProvider[])Extensions.getExtensions((ExtensionPointName)PreviewHintProvider.EP_NAME)) {
            JComponent preview;
            try {
                preview = hintProvider.getPreviewComponent(element);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (preview == null) continue;
            return new LightweightHint(preview);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/preview/ElementPreviewHintProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hide";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

