/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.pluginExport;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginExportData {
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String VENDOR_NAME_PROPERTY = "vendorName";
    private static final String VENDOR_MAIL_PROPERTY = "vendorMail";
    private static final String VENDOR_URL_PROPERTY = "vendorUrl";
    private static final String VERSION_PROPERTY = "version";
    private String myDescription;
    private String myVendorName;
    private String myVendorMail;
    private String myVendorUrl;
    private String myPluginVersion;
    private String myChangeNotes;

    public PluginExportData(@NotNull Properties info) {
        if (info == null) {
            PluginExportData.$$$reportNull$$$0(0);
        }
        this.initData(info);
    }

    private void initData(@NotNull Properties info) {
        if (info == null) {
            PluginExportData.$$$reportNull$$$0(1);
        }
        this.myDescription = info.getProperty(DESCRIPTION_PROPERTY);
        this.myVendorName = info.getProperty(VENDOR_NAME_PROPERTY);
        this.myVendorMail = info.getProperty(VENDOR_MAIL_PROPERTY);
        this.myVendorUrl = info.getProperty(VENDOR_URL_PROPERTY);
        this.myPluginVersion = info.getProperty(VERSION_PROPERTY);
    }

    public String getDescription() {
        return PluginExportData.normalize(this.myDescription, "");
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getVendorName() {
        return PluginExportData.normalize(this.myVendorName, "");
    }

    public void setVendorName(String vendorName) {
        this.myVendorName = vendorName;
    }

    public String getVendorMail() {
        return PluginExportData.normalize(this.myVendorMail, "");
    }

    public void setVendorMail(String vendorMail) {
        this.myVendorMail = vendorMail;
    }

    public String getVendorUrl() {
        return PluginExportData.normalize(this.myVendorUrl, "http://");
    }

    public void setVendorUrl(String vendorUrl) {
        this.myVendorUrl = vendorUrl;
    }

    public String getPluginVersion() {
        return PluginExportData.normalize(this.myPluginVersion, "0.1");
    }

    public void setPluginVersion(String pluginVersion) {
        this.myPluginVersion = pluginVersion;
    }

    public String getChangeNotes() {
        return PluginExportData.normalize(this.myChangeNotes, "");
    }

    public void setChangeNotes(String changeNotes) {
        this.myChangeNotes = changeNotes;
    }

    public String getSinceBuild() {
        return Integer.toString(142) + ".0";
    }

    private static String normalize(@Nullable String value, @NotNull String defaultValue) {
        if (defaultValue == null) {
            PluginExportData.$$$reportNull$$$0(2);
        }
        return value == null || StringUtil.isEmptyOrSpaces((String)value) ? defaultValue : value.trim();
    }

    public boolean isEmpty() {
        return this.myDescription == null && this.myPluginVersion == null && this.myVendorUrl == null && this.myVendorMail == null && this.myVendorName == null;
    }

    public void saveToProperties(@NotNull Properties properties) {
        if (properties == null) {
            PluginExportData.$$$reportNull$$$0(3);
        }
        properties.setProperty(DESCRIPTION_PROPERTY, this.getDescription());
        properties.setProperty(VERSION_PROPERTY, this.getPluginVersion());
        properties.setProperty(VENDOR_URL_PROPERTY, this.getVendorUrl());
        properties.setProperty(VENDOR_MAIL_PROPERTY, this.getVendorMail());
        properties.setProperty(VENDOR_NAME_PROPERTY, this.getVendorName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/pluginExport/PluginExportData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "initData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "normalize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "saveToProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

