/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import gnu.trove.TIntObjectHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class WeakValueIntObjectHashMap<V> {
    private final TIntObjectHashMap<MyReference<V>> myMap = new TIntObjectHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            int key = ref.key;
            this.myMap.remove(key);
            this.keyExpired(key);
        }
        return;
    }

    protected void keyExpired(int key) {
    }

    public final V get(int key) {
        MyReference ref = (MyReference)this.myMap.get(key);
        return (V)SoftReference.dereference(ref);
    }

    public final V put(int key, @NotNull V value) {
        if (value == null) {
            WeakValueIntObjectHashMap.$$$reportNull$$$0(0);
        }
        this.processQueue();
        MyReference ref = new MyReference(key, value, this.myQueue);
        ref.name = value.toString();
        MyReference oldRef = (MyReference)this.myMap.put(key, ref);
        return (V)SoftReference.dereference(oldRef);
    }

    public final V remove(int key) {
        this.processQueue();
        MyReference ref = (MyReference)this.myMap.remove(key);
        return (V)SoftReference.dereference(ref);
    }

    public final void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    public final int size() {
        return this.myMap.size();
    }

    public final boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public final boolean containsKey(int key) {
        return this.get(key) != null;
    }

    @NotNull
    public final Collection<V> values() {
        Object[] refs;
        ArrayList result = new ArrayList();
        for (Object o : refs = this.myMap.getValues()) {
            Object value = ((MyReference)o).get();
            if (value == null) continue;
            result.add(value);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            WeakValueIntObjectHashMap.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/WeakValueIntObjectHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/WeakValueIntObjectHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReference<T>
    extends WeakReference<T> {
        private final int key;
        String name;

        private MyReference(int key, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.key = key;
        }
    }
}

