/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class RefValueHashMap<K, V>
implements Map<K, V> {
    private final Map<K, MyReference<K, V>> myMap;
    private final ReferenceQueue<V> myQueue;

    RefValueHashMap() {
        this.myQueue = new ReferenceQueue();
        this.myMap = new THashMap();
    }

    RefValueHashMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            RefValueHashMap.$$$reportNull$$$0(0);
        }
        this.myQueue = new ReferenceQueue();
        this.myMap = new THashMap(strategy);
    }

    protected abstract MyReference<K, V> createReference(@NotNull K var1, V var2, @NotNull ReferenceQueue<V> var3);

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)((Object)this.myQueue.poll())) != null) {
            Object key = ref.getKey();
            if (this.myMap.get(key) != ref) continue;
            this.myMap.remove(key);
        }
        return;
    }

    @Override
    public V get(Object key) {
        MyReference<K, V> ref = this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public V put(@NotNull K key, V value) {
        if (key == null) {
            RefValueHashMap.$$$reportNull$$$0(1);
        }
        this.processQueue();
        MyReference<K, V> reference = this.createReference(key, value, this.myQueue);
        MyReference<K, V> oldRef = this.myMap.put(key, reference);
        return oldRef != null ? (V)oldRef.get() : null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyReference<K, V> ref = this.myMap.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            RefValueHashMap.$$$reportNull$$$0(2);
        }
        throw new RuntimeException("method not implemented");
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            RefValueHashMap.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        Collection<MyReference<K, V>> refs = this.myMap.values();
        for (MyReference<K, V> ref : refs) {
            V value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            RefValueHashMap.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("method not implemented");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/RefValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/RefValueHashMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface MyReference<K, T> {
        public K getKey();

        public T get();
    }
}

