/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CachedValueImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.EditorConfigException;

public class SettingsProviderComponent
extends SimpleModificationTracker {
    private static final Key<CachedValue<List<EditorConfig.OutPair>>> CACHED_PAIRS = Key.create((String)"editorconfig.cached.pairs");
    public static final String ERROR = "___error___";
    private EditorConfig editorConfig = new EditorConfig();

    public static SettingsProviderComponent getInstance() {
        return (SettingsProviderComponent)((Object)ServiceManager.getService(SettingsProviderComponent.class));
    }

    public List<EditorConfig.OutPair> getOutPairs(Project project, VirtualFile file) {
        List result;
        String error;
        String filePath = Utils.getFilePath(project, file);
        if (filePath == null) {
            return Collections.emptyList();
        }
        CachedValue cache = (CachedValue)file.getUserData(CACHED_PAIRS);
        if (cache == null) {
            Set<String> rootDirs = this.getRootDirs(project);
            cache = new CachedValueImpl(() -> {
                try {
                    List outPairs = this.editorConfig.getProperties(filePath, rootDirs);
                    return CachedValueProvider.Result.create((Object)outPairs, (Object[])new Object[]{this});
                }
                catch (EditorConfigException error) {
                    ArrayList<EditorConfig.OutPair> errorResult = new ArrayList<EditorConfig.OutPair>();
                    errorResult.add(new EditorConfig.OutPair(ERROR, error.getMessage()));
                    return CachedValueProvider.Result.create(errorResult, (Object[])new Object[]{this});
                }
            });
            file.putUserData(CACHED_PAIRS, (Object)cache);
        }
        if (!StringUtil.isEmpty((String)(error = Utils.configValueForKey(result = (List)cache.getValue(), ERROR)))) {
            Utils.invalidConfigMessage(project, error, "", filePath);
        }
        return result;
    }

    public Set<String> getRootDirs(Project project) {
        if (!Registry.is((String)"editor.config.stop.at.project.root")) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            HashSet<String> dirs = new HashSet<String>();
            VirtualFile projectBase = project.getBaseDir();
            if (projectBase != null) {
                dirs.add(project.getBasePath());
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                        if (VfsUtilCore.isAncestor((VirtualFile)projectBase, (VirtualFile)root, (boolean)false)) continue;
                        dirs.add(root.getPath());
                    }
                }
            }
            dirs.add(PathManager.getConfigPath());
            return new CachedValueProvider.Result(dirs, new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
        });
    }
}

