/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TabbedTerminalWidget;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalWidget;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.JBTabbedTerminalWidget;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.TerminalToolWindowPanel;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class TerminalView {
    private static final String TERMINAL_FEATURE = "terminal";
    private JBTabbedTerminalWidget myTerminalWidget;
    private final Project myProject;
    private TerminalDockContainer myDockContainer;

    public TerminalView(Project project) {
        this.myProject = project;
    }

    public static TerminalView getInstance(@NotNull Project project) {
        if (project == null) {
            TerminalView.$$$reportNull$$$0(0);
        }
        return (TerminalView)project.getComponent(TerminalView.class);
    }

    public void initTerminal(final ToolWindow toolWindow) {
        LocalTerminalDirectRunner terminalRunner = LocalTerminalDirectRunner.createTerminalRunner(this.myProject);
        toolWindow.setToHideOnEmptyContent(true);
        Content content = this.createTerminalInContentPanel(terminalRunner, toolWindow);
        toolWindow.getContentManager().addContent(content);
        ((ToolWindowManagerEx)ToolWindowManager.getInstance((Project)this.myProject)).addToolWindowManagerListener(new ToolWindowManagerListener(){

            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            public void stateChanged() {
                boolean visible;
                ToolWindow window = ToolWindowManager.getInstance((Project)TerminalView.this.myProject).getToolWindow("Terminal");
                if (window != null && (visible = window.isVisible()) && toolWindow.getContentManager().getContentCount() == 0) {
                    TerminalView.this.initTerminal(window);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/terminal/TerminalView$1", "toolWindowRegistered"));
            }
        });
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                if (TerminalView.this.myTerminalWidget != null) {
                    TerminalView.this.myTerminalWidget.dispose();
                    TerminalView.this.myTerminalWidget = null;
                }
            }
        });
        if (this.myDockContainer == null) {
            this.myDockContainer = new TerminalDockContainer(toolWindow);
            Disposer.register((Disposable)this.myProject, (Disposable)this.myDockContainer);
            DockManager.getInstance((Project)this.myProject).register((DockContainer)this.myDockContainer);
        }
    }

    private Content createTerminalInContentPanel(@NotNull AbstractTerminalRunner terminalRunner, final @NotNull ToolWindow toolWindow) {
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(1);
        }
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(2);
        }
        TerminalToolWindowPanel panel = new TerminalToolWindowPanel(PropertiesComponent.getInstance((Project)this.myProject), toolWindow);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)panel), "", false);
        content.setCloseable(true);
        this.myTerminalWidget = terminalRunner.createTerminalWidget((Disposable)content);
        this.myTerminalWidget.addTabListener(new TabbedTerminalWidget.TabListener(){

            public void tabClosed(JediTermWidget terminal) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (toolWindow == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (TerminalView.this.myTerminalWidget != null) {
                        TerminalView.hideIfNoActiveSessions(toolWindow, TerminalView.this.myTerminalWidget);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "org/jetbrains/plugins/terminal/TerminalView$3", "lambda$tabClosed$0"));
            }
        });
        panel.setContent(this.myTerminalWidget.getComponent());
        panel.addFocusListener(this.createFocusListener());
        ActionToolbar toolbar = TerminalView.createToolbar(terminalRunner, this.myTerminalWidget, toolWindow);
        toolbar.getComponent().addFocusListener(this.createFocusListener());
        toolbar.setTargetComponent((JComponent)((Object)panel));
        panel.setToolbar(toolbar.getComponent());
        panel.uiSettingsChanged(null);
        content.setPreferredFocusableComponent(this.myTerminalWidget.getComponent());
        return content;
    }

    private FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component = TerminalView.this.getComponentToFocus();
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    private JComponent getComponentToFocus() {
        return this.myTerminalWidget != null ? this.myTerminalWidget.getComponent() : null;
    }

    public void openLocalSession(Project project, ToolWindow terminal) {
        LocalTerminalDirectRunner terminalRunner = LocalTerminalDirectRunner.createTerminalRunner(project);
        this.openSession(terminal, terminalRunner);
    }

    private void openSession(@NotNull ToolWindow toolWindow, @NotNull AbstractTerminalRunner terminalRunner) {
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(3);
        }
        if (terminalRunner == null) {
            TerminalView.$$$reportNull$$$0(4);
        }
        if (this.myTerminalWidget == null) {
            toolWindow.getContentManager().removeAllContents(true);
            Content content = this.createTerminalInContentPanel(terminalRunner, toolWindow);
            toolWindow.getContentManager().addContent(content);
        } else {
            terminalRunner.openSession((TerminalWidget)this.myTerminalWidget);
        }
        toolWindow.activate(() -> {}, true);
    }

    public static void recordUsage(@NotNull TtyConnector ttyConnector) {
        if (ttyConnector == null) {
            TerminalView.$$$reportNull$$$0(5);
        }
        UsageTrigger.trigger((String)("terminal." + (ttyConnector.toString().contains("Jsch") ? "ssh" : (SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux")))));
    }

    private static ActionToolbar createToolbar(@Nullable AbstractTerminalRunner terminalRunner, @NotNull JBTabbedTerminalWidget terminal, @NotNull ToolWindow toolWindow) {
        if (terminal == null) {
            TerminalView.$$$reportNull$$$0(6);
        }
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(7);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        if (terminalRunner != null) {
            group.add((AnAction)new NewSession(terminalRunner, (TerminalWidget)terminal));
            group.add((AnAction)new CloseSession(terminal, toolWindow));
        }
        return ActionManager.getInstance().createActionToolbar("Terminal", (ActionGroup)group, false);
    }

    public void createNewSession(Project project, AbstractTerminalRunner terminalRunner) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
        toolWindow.activate(() -> this.openSession(toolWindow, terminalRunner), true);
    }

    private static void hideIfNoActiveSessions(@NotNull ToolWindow toolWindow, @NotNull JBTabbedTerminalWidget terminal) {
        if (toolWindow == null) {
            TerminalView.$$$reportNull$$$0(8);
        }
        if (terminal == null) {
            TerminalView.$$$reportNull$$$0(9);
        }
        if (terminal.isNoActiveSessions()) {
            toolWindow.getContentManager().removeAllContents(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalRunner";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ttyConnector";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = TERMINAL_FEATURE;
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTerminalInContentPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openSession";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "recordUsage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolbar";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hideIfNoActiveSessions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class TerminalDockContainer
    implements DockContainer {
        private ToolWindow myTerminalToolWindow;

        public TerminalDockContainer(ToolWindow toolWindow) {
            this.myTerminalToolWindow = toolWindow;
        }

        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(this.myTerminalToolWindow.getComponent());
        }

        public RelativeRectangle getAcceptAreaFallback() {
            return this.getAcceptArea();
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(0);
            }
            DockContainer.ContentResponse contentResponse = this.isTerminalSessionContent(content) ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                TerminalDockContainer.$$$reportNull$$$0(1);
            }
            return contentResponse;
        }

        public JComponent getContainerComponent() {
            return this.myTerminalToolWindow.getComponent();
        }

        public void add(@NotNull DockableContent content, RelativePoint dropTarget) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(2);
            }
            if (this.isTerminalSessionContent(content)) {
                TerminalSessionVirtualFileImpl terminalFile = (TerminalSessionVirtualFileImpl)((Object)content.getKey());
                TerminalView.this.myTerminalWidget.addTab(terminalFile.getName(), terminalFile.getTerminal());
                terminalFile.getTerminal().setNextProvider((TerminalActionProvider)TerminalView.this.myTerminalWidget);
            }
        }

        private boolean isTerminalSessionContent(DockableContent content) {
            return content.getKey() instanceof TerminalSessionVirtualFileImpl;
        }

        public void closeAll() {
        }

        public void addListener(DockContainer.Listener listener, Disposable parent) {
        }

        public boolean isEmpty() {
            return false;
        }

        @Nullable
        public Image startDropOver(@NotNull DockableContent content, RelativePoint point) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(3);
            }
            return null;
        }

        @Nullable
        public Image processDropOver(@NotNull DockableContent content, RelativePoint point) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(4);
            }
            return null;
        }

        public void resetDropOver(@NotNull DockableContent content) {
            if (content == null) {
                TerminalDockContainer.$$$reportNull$$$0(5);
            }
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }

        public void showNotify() {
        }

        public void hideNotify() {
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalView$TerminalDockContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalView$TerminalDockContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getContentResponse";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "startDropOver";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processDropOver";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "resetDropOver";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CloseSession
    extends DumbAwareAction {
        private final JBTabbedTerminalWidget myTerminal;
        private ToolWindow myToolWindow;

        public CloseSession(@NotNull JBTabbedTerminalWidget terminal, @NotNull ToolWindow toolWindow) {
            if (terminal == null) {
                CloseSession.$$$reportNull$$$0(0);
            }
            if (toolWindow == null) {
                CloseSession.$$$reportNull$$$0(1);
            }
            super("Close Session", "Close Terminal Session", AllIcons.Actions.Delete);
            this.myTerminal = terminal;
            this.myToolWindow = toolWindow;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myTerminal.closeCurrentSession();
            TerminalView.hideIfNoActiveSessions(this.myToolWindow, this.myTerminal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = TerminalView.TERMINAL_FEATURE;
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "toolWindow";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/terminal/TerminalView$CloseSession";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NewSession
    extends DumbAwareAction {
        private final AbstractTerminalRunner myTerminalRunner;
        private final TerminalWidget myTerminal;

        public NewSession(@NotNull AbstractTerminalRunner terminalRunner, @NotNull TerminalWidget terminal) {
            if (terminalRunner == null) {
                NewSession.$$$reportNull$$$0(0);
            }
            if (terminal == null) {
                NewSession.$$$reportNull$$$0(1);
            }
            super("New Session", "Create New Terminal Session", AllIcons.General.Add);
            this.myTerminalRunner = terminalRunner;
            this.myTerminal = terminal;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myTerminalRunner.openSession(this.myTerminal);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "terminalRunner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = TerminalView.TERMINAL_FEATURE;
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/terminal/TerminalView$NewSession";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

