/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.config.AbstractTagInjection;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.intellij.plugins.intelliLang.inject.config.XmlTagInjection;
import org.intellij.plugins.intelliLang.util.StringMatcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeInjection
extends AbstractTagInjection {
    @NotNull
    @NonNls
    private StringMatcher myAttributeNameMatcher = StringMatcher.NONE;
    @NotNull
    @NonNls
    private String myAttributeNamespace = "";

    @NotNull
    public String getAttributeName() {
        String string = this.myAttributeNameMatcher.getPattern();
        if (string == null) {
            XmlAttributeInjection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setAttributeName(@NotNull String attributeName) {
        if (attributeName == null) {
            XmlAttributeInjection.$$$reportNull$$$0(1);
        }
        this.myAttributeNameMatcher = StringMatcher.create(attributeName);
    }

    @NotNull
    public String getAttributeNamespace() {
        String string = this.myAttributeNamespace;
        if (string == null) {
            XmlAttributeInjection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setAttributeNamespace(@NotNull String attributeNamespace) {
        if (attributeNamespace == null) {
            XmlAttributeInjection.$$$reportNull$$$0(3);
        }
        this.myAttributeNamespace = attributeNamespace;
    }

    public boolean isApplicable(@NotNull XmlAttributeValue value) {
        PsiElement element;
        if (value == null) {
            XmlAttributeInjection.$$$reportNull$$$0(4);
        }
        return (element = value.getParent()) instanceof XmlAttribute && this.matches((XmlAttribute)element);
    }

    public String getGeneratedName() {
        String tag = this.getTagName();
        String attributeName = this.getAttributeName();
        if (!attributeName.equals(StringMatcher.NONE.getPattern())) {
            if (tag.length() > 0) {
                return tag + "/@" + (attributeName.length() > 0 ? attributeName : "*");
            }
            return "*/@" + (attributeName.length() > 0 ? attributeName : "*");
        }
        return attributeName;
    }

    @Override
    public void generatePlaces() {
        if (StringUtil.isEmpty((String)this.getDisplayName())) {
            this.setDisplayName(this.getGeneratedName());
        }
        this.setInjectionPlaces(new InjectionPlace((ElementPattern<PsiElement>)this.getCompiler().createElementPattern(XmlAttributeInjection.getPatternString(this), this.getDisplayName()), true));
    }

    private boolean matches(@NotNull XmlAttribute attr) {
        if (attr == null) {
            XmlAttributeInjection.$$$reportNull$$$0(5);
        }
        boolean b = this.myAttributeNameMatcher.matches(attr.getLocalName()) && (attr.getName().indexOf(58) == -1 || this.myAttributeNamespace.equals(attr.getNamespace())) && this.matches(attr.getParent());
        return b && this.matchXPath((XmlElement)attr);
    }

    @Override
    public XmlAttributeInjection copy() {
        return new XmlAttributeInjection().copyFrom(this);
    }

    @Override
    public XmlAttributeInjection copyFrom(@NotNull BaseInjection o) {
        if (o == null) {
            XmlAttributeInjection.$$$reportNull$$$0(6);
        }
        super.copyFrom(o);
        if (o instanceof XmlAttributeInjection) {
            XmlAttributeInjection other = (XmlAttributeInjection)o;
            this.setApplyToSubTags(other.isApplyToSubTags());
            this.setAttributeName(other.getAttributeName());
            this.setAttributeNamespace(other.getAttributeNamespace());
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XmlAttributeInjection that = (XmlAttributeInjection)o;
        if (!this.myAttributeNameMatcher.getPattern().equals(that.myAttributeNameMatcher.getPattern())) {
            return false;
        }
        return this.myAttributeNamespace.equals(that.myAttributeNamespace);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myAttributeNameMatcher.getPattern().hashCode();
        result = 31 * result + this.myAttributeNamespace.hashCode();
        return result;
    }

    public static String getPatternString(XmlAttributeInjection injection) {
        String name = injection.getAttributeName();
        String namespace = injection.getAttributeNamespace();
        StringBuilder result = new StringBuilder("xmlAttribute()");
        if (StringUtil.isNotEmpty((String)name)) {
            InjectorUtils.appendStringPattern(result, ".withLocalName(", name, ")");
        }
        if (StringUtil.isNotEmpty((String)namespace)) {
            InjectorUtils.appendStringPattern(result, ".withNamespace(", namespace, ")");
        }
        if (StringUtil.isNotEmpty((String)injection.getTagName()) || StringUtil.isNotEmpty((String)injection.getTagNamespace())) {
            result.append(".").append(injection.isApplyToSubTags() ? "inside" : "withParent").append("(").append(XmlTagInjection.getPatternString(injection)).append(")");
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeNamespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/config/XmlAttributeInjection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeNamespace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

