/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationInfo;

public class PlatformUtils {
    public static final String PLATFORM_PREFIX_KEY = "idea.platform.prefix";
    public static final String IDEA_PREFIX = "idea";
    public static final String IDEA_CE_PREFIX = "Idea";
    public static final String APPCODE_PREFIX = "AppCode";
    public static final String CLION_PREFIX = "CLion";
    public static final String PYCHARM_PREFIX = "Python";
    public static final String PYCHARM_CE_PREFIX = "PyCharmCore";
    public static final String PYCHARM_EDU_PREFIX = "PyCharmEdu";
    public static final String RUBY_PREFIX = "Ruby";
    public static final String PHP_PREFIX = "PhpStorm";
    public static final String WEB_PREFIX = "WebStorm";
    public static final String DBE_PREFIX = "DataGrip";
    public static final String RIDER_PREFIX = "Rider";
    public static final String GOIDE_PREFIX = "GoLand";

    public static String getPlatformPrefix() {
        return PlatformUtils.getPlatformPrefix(IDEA_PREFIX);
    }

    public static String getPlatformPrefix(String defaultPrefix) {
        return System.getProperty(PLATFORM_PREFIX_KEY, defaultPrefix);
    }

    public static boolean isJetBrainsProduct() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        return appInfo != null && appInfo.getShortCompanyName().equals("JetBrains");
    }

    public static boolean isIntelliJ() {
        return PlatformUtils.isIdeaUltimate() || PlatformUtils.isIdeaCommunity();
    }

    public static boolean isIdeaUltimate() {
        return PlatformUtils.is(IDEA_PREFIX);
    }

    public static boolean isIdeaCommunity() {
        return PlatformUtils.is(IDEA_CE_PREFIX);
    }

    public static boolean isRubyMine() {
        return PlatformUtils.is(RUBY_PREFIX);
    }

    public static boolean isAppCode() {
        return PlatformUtils.is(APPCODE_PREFIX);
    }

    public static boolean isCLion() {
        return PlatformUtils.is(CLION_PREFIX);
    }

    public static boolean isCidr() {
        return PlatformUtils.isAppCode() || PlatformUtils.isCLion();
    }

    public static boolean isPyCharm() {
        return PlatformUtils.isPyCharmPro() || PlatformUtils.isPyCharmCommunity() || PlatformUtils.isPyCharmEducational();
    }

    public static boolean isPyCharmPro() {
        return PlatformUtils.is(PYCHARM_PREFIX);
    }

    public static boolean isPyCharmCommunity() {
        return PlatformUtils.is(PYCHARM_CE_PREFIX);
    }

    public static boolean isPyCharmEducational() {
        return PlatformUtils.is(PYCHARM_EDU_PREFIX);
    }

    public static boolean isPhpStorm() {
        return PlatformUtils.is(PHP_PREFIX);
    }

    public static boolean isWebStorm() {
        return PlatformUtils.is(WEB_PREFIX);
    }

    public static boolean isDatabaseIDE() {
        return PlatformUtils.is(DBE_PREFIX);
    }

    public static boolean isRider() {
        return PlatformUtils.is(RIDER_PREFIX);
    }

    public static boolean isGoIde() {
        return PlatformUtils.is(GOIDE_PREFIX);
    }

    public static boolean isCommunityEdition() {
        return PlatformUtils.isIdeaCommunity() || PlatformUtils.isPyCharmCommunity();
    }

    private static boolean is(String idePrefix) {
        return idePrefix.equals(PlatformUtils.getPlatformPrefix());
    }
}

