/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.SearchInBackgroundOption;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.SearchForUsagesRunnable;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageViewManagerImpl
extends UsageViewManager {
    private static final Logger LOG = Logger.getInstance(UsageViewManagerImpl.class);
    private final Project myProject;
    private static final Key<UsageView> USAGE_VIEW_KEY = Key.create((String)"USAGE_VIEW");

    public UsageViewManagerImpl(@NotNull Project project) {
        if (project == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    @NotNull
    public UsageView createUsageView(@NotNull UsageTarget[] targets, @NotNull Usage[] usages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> usageSearcherFactory) {
        if (targets == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(3);
        }
        UsageViewImpl usageView = new UsageViewImpl(this.myProject, presentation, targets, usageSearcherFactory);
        UsageViewManagerImpl.appendUsages(usages, usageView);
        usageView.setSearchInProgress(false);
        UsageViewImpl usageViewImpl = usageView;
        if (usageViewImpl == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(4);
        }
        return usageViewImpl;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation, Factory<UsageSearcher> factory) {
        if (searchedFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(5);
        }
        if (foundUsages == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(6);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(7);
        }
        UsageView usageView = this.createUsageView(searchedFor, foundUsages, presentation, factory);
        this.addContent((UsageViewImpl)usageView, presentation);
        this.showToolWindow(true);
        UIUtil.invokeLaterIfNeeded(() -> {
            if (!((UsageViewImpl)usageView).isDisposed()) {
                ((UsageViewImpl)usageView).expandRoot();
            }
        });
        UsageView usageView2 = usageView;
        if (usageView2 == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(8);
        }
        return usageView2;
    }

    @Override
    @NotNull
    public UsageView showUsages(@NotNull UsageTarget[] searchedFor, @NotNull Usage[] foundUsages, @NotNull UsageViewPresentation presentation) {
        if (searchedFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(9);
        }
        if (foundUsages == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(10);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(11);
        }
        UsageView usageView = this.showUsages(searchedFor, foundUsages, presentation, null);
        if (usageView == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(12);
        }
        return usageView;
    }

    void addContent(@NotNull UsageViewImpl usageView, @NotNull UsageViewPresentation presentation) {
        if (usageView == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(13);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(14);
        }
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).addContent(presentation.getTabText(), presentation.getTabName(), presentation.getToolwindowTitle(), true, usageView.getComponent(), presentation.isOpenInNewTab(), true);
        usageView.setContent(content);
        content.putUserData(USAGE_VIEW_KEY, usageView);
    }

    @Override
    public UsageView searchAndShowUsages(@NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, boolean showPanelIfOnlyOneUsage, boolean showNotFoundMessage, @NotNull UsageViewPresentation presentation, @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(15);
        }
        if (searcherFactory == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(16);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(17);
        }
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(showNotFoundMessage);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        return this.doSearchAndShow(searchFor, searcherFactory, presentation, processPresentation, listener);
    }

    private UsageView doSearchAndShow(final @NotNull UsageTarget[] searchFor, final @NotNull Factory<UsageSearcher> searcherFactory, final @NotNull UsageViewPresentation presentation, final @NotNull FindUsagesProcessPresentation processPresentation, final @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(18);
        }
        if (searcherFactory == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(19);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(20);
        }
        if (processPresentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(21);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Can't start find usages from under write action. Please consider Application.invokeLater() it instead.");
        }
        final SearchScope searchScopeToWarnOfFallingOutOf = this.getMaxSearchScopeToWarnOfFallingOutOf(searchFor);
        final AtomicReference usageViewRef = new AtomicReference();
        final long start = System.currentTimeMillis();
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, UsageViewManagerImpl.getProgressTitle(presentation), true, new SearchInBackgroundOption()){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                new SearchForUsagesRunnable(UsageViewManagerImpl.this, UsageViewManagerImpl.this.myProject, usageViewRef, presentation, searchFor, (Factory<UsageSearcher>)searcherFactory, processPresentation, searchScopeToWarnOfFallingOutOf, listener).run();
            }

            @Override
            @NotNull
            public Task.NotificationInfo getNotificationInfo() {
                UsageViewImpl usageView = (UsageViewImpl)usageViewRef.get();
                int count = usageView == null ? 0 : usageView.getUsagesCount();
                String notification = StringUtil.capitalizeWords((String)UsageViewBundle.message("usages.n", count), (boolean)true);
                LOG.debug(notification + " in " + (System.currentTimeMillis() - start) + "ms.");
                Task.NotificationInfo notificationInfo = new Task.NotificationInfo("Find Usages", "Find Usages Finished", notification);
                if (notificationInfo == null) {
                    1.$$$reportNull$$$0(1);
                }
                return notificationInfo;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/usages/impl/UsageViewManagerImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/usages/impl/UsageViewManagerImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNotificationInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        ProgressManager.getInstance().run(task);
        return (UsageView)usageViewRef.get();
    }

    @NotNull
    SearchScope getMaxSearchScopeToWarnOfFallingOutOf(@NotNull UsageTarget[] searchFor) {
        UsageTarget target;
        if (searchFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(22);
        }
        UsageTarget usageTarget = target = searchFor.length > 0 ? searchFor[0] : null;
        if (target instanceof TypeSafeDataProvider) {
            final SearchScope[] scope = new SearchScope[1];
            ((TypeSafeDataProvider)((Object)target)).calcData(UsageView.USAGE_SCOPE, new DataSink(){

                @Override
                public <T> void put(DataKey<T> key, T data) {
                    scope[0] = (SearchScope)data;
                }
            });
            SearchScope searchScope = scope[0];
            if (searchScope == null) {
                UsageViewManagerImpl.$$$reportNull$$$0(23);
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.everythingScope(this.myProject);
        if (globalSearchScope == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(24);
        }
        return globalSearchScope;
    }

    @Override
    public void searchAndShowUsages(@NotNull UsageTarget[] searchFor, @NotNull Factory<UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull UsageViewPresentation presentation, @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searchFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(25);
        }
        if (searcherFactory == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(26);
        }
        if (processPresentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(27);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(28);
        }
        this.doSearchAndShow(searchFor, searcherFactory, presentation, processPresentation, listener);
    }

    @Override
    public UsageView getSelectedUsageView() {
        Content content = com.intellij.usageView.UsageViewManager.getInstance(this.myProject).getSelectedContent();
        if (content != null) {
            return (UsageView)content.getUserData(USAGE_VIEW_KEY);
        }
        return null;
    }

    @NotNull
    public static String getProgressTitle(@NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(29);
        }
        String scopeText = presentation.getScopeText();
        String usagesString = StringUtil.capitalize((String)presentation.getUsagesString());
        String string = UsageViewBundle.message("progress.searching.for.in", usagesString, scopeText, presentation.getContextText());
        if (string == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(30);
        }
        return string;
    }

    void showToolWindow(boolean activateWindow) {
        ToolWindow toolWindow = ToolWindowManager.getInstance(this.myProject).getToolWindow(ToolWindowId.FIND);
        toolWindow.show(null);
        if (activateWindow && !toolWindow.isActive()) {
            toolWindow.activate(null);
        }
    }

    protected static void appendUsages(@NotNull Usage[] foundUsages, @NotNull UsageViewImpl usageView) {
        if (foundUsages == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(31);
        }
        if (usageView == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(32);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (foundUsages == null) {
                UsageViewManagerImpl.$$$reportNull$$$0(50);
            }
            if (usageView == null) {
                UsageViewManagerImpl.$$$reportNull$$$0(51);
            }
            for (Usage foundUsage : foundUsages) {
                usageView.appendUsage(foundUsage);
            }
        });
    }

    public static void showTooManyUsagesWarningLater(@NotNull Project project, @NotNull TooManyUsagesStatus tooManyUsagesStatus, @NotNull ProgressIndicator indicator, @NotNull UsageViewPresentation presentation, int usageCount, @Nullable UsageViewImpl usageView) {
        if (project == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(33);
        }
        if (tooManyUsagesStatus == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(34);
        }
        if (indicator == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(35);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(36);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (indicator == null) {
                UsageViewManagerImpl.$$$reportNull$$$0(46);
            }
            if (presentation == null) {
                UsageViewManagerImpl.$$$reportNull$$$0(47);
            }
            if (project == null) {
                UsageViewManagerImpl.$$$reportNull$$$0(48);
            }
            if (tooManyUsagesStatus == null) {
                UsageViewManagerImpl.$$$reportNull$$$0(49);
            }
            if (usageView != null && usageView.searchHasBeenCancelled() || indicator.isCanceled()) {
                return;
            }
            int shownUsageCount = usageView == null ? usageCount : usageView.getRoot().getRecursiveUsageCount();
            String message = UsageViewBundle.message("find.excessive.usage.count.prompt", shownUsageCount, StringUtil.pluralize((String)presentation.getUsagesWord()));
            UsageLimitUtil.Result ret = UsageLimitUtil.showTooManyUsagesWarning(project, message, presentation);
            if (ret == UsageLimitUtil.Result.ABORT) {
                if (usageView != null) {
                    usageView.cancelCurrentSearch();
                }
                indicator.cancel();
            }
            tooManyUsagesStatus.userResponded();
        });
    }

    public static long getFileLength(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(37);
        }
        long[] length = new long[]{-1L};
        ApplicationManager.getApplication().runReadAction(() -> {
            if (virtualFile2 == null) {
                UsageViewManagerImpl.$$$reportNull$$$0(45);
            }
            if (!virtualFile2.isValid()) {
                return;
            }
            length[0] = virtualFile2.getLength();
        });
        return length[0];
    }

    @NotNull
    public static String presentableSize(long bytes) {
        long megabytes = bytes / 0x100000L;
        String string = UsageViewBundle.message("find.file.size.megabytes", Long.toString(megabytes));
        if (string == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(38);
        }
        return string;
    }

    public static boolean isInScope(@NotNull Usage usage, @NotNull SearchScope searchScope) {
        VirtualFile file;
        VirtualFile virtualFile2;
        if (usage == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(39);
        }
        if (searchScope == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(40);
        }
        PsiElement element = null;
        if (usage instanceof UsageInFile) {
            virtualFile2 = ((UsageInFile)usage).getFile();
        } else if (usage instanceof PsiElementUsage) {
            element = ((PsiElementUsage)usage).getElement();
            virtualFile2 = PsiUtilCore.getVirtualFile(element);
        } else {
            virtualFile2 = file = null;
        }
        if (file != null) {
            return UsageViewManagerImpl.isFileInScope(file, searchScope);
        }
        return element != null && (searchScope instanceof EverythingGlobalScope || searchScope instanceof ProjectScopeImpl || searchScope instanceof ProjectAndLibrariesScope);
    }

    private static boolean isFileInScope(@NotNull VirtualFile file, @NotNull SearchScope searchScope) {
        if (file == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(41);
        }
        if (searchScope == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(42);
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        return searchScope.contains(file);
    }

    @NotNull
    public static String outOfScopeMessage(int nUsages, @NotNull SearchScope searchScope) {
        if (searchScope == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(43);
        }
        String string = (nUsages == 1 ? "One usage is" : nUsages + " usages are") + " out of scope '" + searchScope.getDisplayName() + "'";
        if (string == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 23: 
            case 24: 
            case 30: 
            case 38: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 23: 
            case 24: 
            case 30: 
            case 38: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 28: 
            case 29: 
            case 36: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 23: 
            case 24: 
            case 30: 
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageViewManagerImpl";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchedFor";
                break;
            }
            case 6: 
            case 10: 
            case 31: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundUsages";
                break;
            }
            case 13: 
            case 32: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 15: 
            case 18: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFor";
                break;
            }
            case 16: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcherFactory";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 34: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooManyUsagesStatus";
                break;
            }
            case 35: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageViewManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageView";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "showUsages";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxSearchScopeToWarnOfFallingOutOf";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressTitle";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "presentableSize";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "outOfScopeMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageView";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 23: 
            case 24: 
            case 30: 
            case 38: 
            case 44: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showUsages";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "searchAndShowUsages";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doSearchAndShow";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMaxSearchScopeToWarnOfFallingOutOf";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getProgressTitle";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "appendUsages";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showTooManyUsagesWarningLater";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFileLength";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isFileInScope";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "outOfScopeMessage";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFileLength$3";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showTooManyUsagesWarningLater$2";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendUsages$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 23: 
            case 24: 
            case 30: 
            case 38: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

