/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.XmlElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeValuePattern
extends XmlElementPattern<XmlAttributeValue, XmlAttributeValuePattern> {
    static final XmlAttributeValuePattern XML_ATTRIBUTE_VALUE_PATTERN = new XmlAttributeValuePattern(new InitialPatternCondition<XmlAttributeValue>(XmlAttributeValue.class){

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return o instanceof XmlAttributeValue;
        }
    });

    public XmlAttributeValuePattern(InitialPatternCondition<XmlAttributeValue> condition2) {
        super(condition2);
    }

    public XmlAttributeValuePattern withLocalName(String ... names) {
        return names.length == 1 ? this.withLocalName((ElementPattern<String>)StandardPatterns.string().equalTo(names[0])) : this.withLocalName(StandardPatterns.string().oneOf(names));
    }

    public XmlAttributeValuePattern withLocalNameIgnoreCase(String ... names) {
        return this.withLocalName(StandardPatterns.string().oneOfIgnoreCase(names));
    }

    public XmlAttributeValuePattern withLocalName(ElementPattern<String> namePattern) {
        return (XmlAttributeValuePattern)this.with(new PsiNamePatternCondition<XmlAttributeValue>("withLocalName", namePattern){

            @Override
            public String getPropertyValue(@NotNull Object o) {
                if (o == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (o instanceof XmlAttributeValue) {
                    XmlAttributeValue value = (XmlAttributeValue)o;
                    PsiElement parent = value.getParent();
                    if (parent instanceof XmlAttribute) {
                        return ((XmlAttribute)parent).getLocalName();
                    }
                    if (parent instanceof XmlProcessingInstruction) {
                        PsiElement prev = value.getPrevSibling();
                        if (!(prev instanceof XmlToken) || ((XmlToken)prev).getTokenType() != XmlTokenType.XML_EQ) {
                            return null;
                        }
                        if (!((prev = prev.getPrevSibling()) instanceof XmlToken) || ((XmlToken)prev).getTokenType() != XmlTokenType.XML_NAME) {
                            return null;
                        }
                        return prev.getText();
                    }
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/XmlAttributeValuePattern$2", "getPropertyValue"));
            }
        });
    }

    public XmlAttributeValuePattern withNamespace(String ... names) {
        return names.length == 1 ? this.withNamespace((ElementPattern<String>)StandardPatterns.string().equalTo(names[0])) : this.withNamespace(StandardPatterns.string().oneOf(names));
    }

    public XmlAttributeValuePattern withNamespace(ElementPattern<String> namePattern) {
        return (XmlAttributeValuePattern)this.with(new PsiNamePatternCondition<XmlAttributeValue>("withNamespace", namePattern){

            @Override
            public String getPropertyValue(@NotNull Object o) {
                PsiElement parent;
                if (o == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (o instanceof XmlAttributeValue && (parent = ((XmlAttributeValue)o).getParent()) instanceof XmlAttribute) {
                    return ((XmlAttribute)parent).getNamespace();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/XmlAttributeValuePattern$3", "getPropertyValue"));
            }
        });
    }

    public XmlAttributeValuePattern withValue(final StringPattern valuePattern) {
        return (XmlAttributeValuePattern)this.with(new PatternCondition<XmlAttributeValue>("withValue"){

            @Override
            public boolean accepts(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
                if (xmlAttributeValue == null) {
                    4.$$$reportNull$$$0(0);
                }
                return valuePattern.accepts(xmlAttributeValue.getValue(), context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/patterns/XmlAttributeValuePattern$4", "accepts"));
            }
        });
    }
}

