/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class LoadingDecorator {
    JLayeredPane myPane;
    LoadingLayer myLoadingLayer;
    Animator myFadeOutAnimator;
    int myDelay;
    Alarm myStartAlarm;
    boolean myStartRequest;

    public LoadingDecorator(JComponent content, @NotNull Disposable parent, int startDelayMs) {
        if (parent == null) {
            LoadingDecorator.$$$reportNull$$$0(0);
        }
        this(content, parent, startDelayMs, false);
    }

    public LoadingDecorator(JComponent content, @NotNull Disposable parent, int startDelayMs, boolean useMinimumSize) {
        if (parent == null) {
            LoadingDecorator.$$$reportNull$$$0(1);
        }
        this(content, parent, startDelayMs, useMinimumSize, new AsyncProcessIcon.Big("Loading"));
    }

    public LoadingDecorator(JComponent content, @NotNull Disposable parent, int startDelayMs, boolean useMinimumSize, @NotNull AsyncProcessIcon icon) {
        if (parent == null) {
            LoadingDecorator.$$$reportNull$$$0(2);
        }
        if (icon == null) {
            LoadingDecorator.$$$reportNull$$$0(3);
        }
        this.myPane = new MyLayeredPane(useMinimumSize ? content : null);
        this.myLoadingLayer = new LoadingLayer(icon);
        this.myDelay = startDelayMs;
        this.myStartAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parent);
        this.setLoadingText("Loading...");
        this.myFadeOutAnimator = new Animator("Loading", 10, 500, false){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                LoadingDecorator.this.myLoadingLayer.setAlpha(1.0f - (float)frame / (float)totalFrames);
            }

            @Override
            protected void paintCycleEnd() {
                LoadingDecorator.this.myLoadingLayer.setAlpha(0.0f);
                LoadingDecorator.this.hideLoadingLayer();
                LoadingDecorator.this.myLoadingLayer.setAlpha(-1.0f);
            }
        };
        Disposer.register((Disposable)parent, (Disposable)this.myFadeOutAnimator);
        this.myPane.add(content, JLayeredPane.DEFAULT_LAYER, 0);
        Disposer.register((Disposable)parent, (Disposable)this.myLoadingLayer.myProgress);
    }

    private void hideLoadingLayer() {
        this.myPane.remove(this.myLoadingLayer);
        this.myLoadingLayer.setVisible(false);
    }

    private void addLoadingLayerOnDemand() {
        if (this.myPane != this.myLoadingLayer.getParent()) {
            this.myPane.add(this.myLoadingLayer, JLayeredPane.DRAG_LAYER, 1);
        }
    }

    protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AsyncProcessIcon icon) {
        parent.setLayout(new GridBagLayout());
        Font font = text.getFont();
        text.setFont(font.deriveFont(font.getStyle(), font.getSize() + 8));
        int gap = new JLabel().getIconTextGap();
        NonOpaquePanel result = new NonOpaquePanel(new FlowLayout(1, gap * 3, 0));
        result.add(icon);
        result.add(text);
        parent.add(result);
        return result;
    }

    public JComponent getComponent() {
        return this.myPane;
    }

    public void startLoading(boolean takeSnapshot) {
        if (this.isLoading() || this.myStartRequest || this.myStartAlarm.isDisposed()) {
            return;
        }
        this.myStartRequest = true;
        if (this.myDelay > 0) {
            this.myStartAlarm.addRequest(() -> UIUtil.invokeLaterIfNeeded(() -> {
                if (!this.myStartRequest) {
                    return;
                }
                this._startLoading(takeSnapshot);
            }), this.myDelay);
        } else {
            this._startLoading(takeSnapshot);
        }
    }

    protected void _startLoading(boolean takeSnapshot) {
        this.addLoadingLayerOnDemand();
        this.myLoadingLayer.setVisible(true, takeSnapshot);
    }

    public void stopLoading() {
        this.myStartRequest = false;
        this.myStartAlarm.cancelAllRequests();
        if (!this.isLoading()) {
            return;
        }
        this.myLoadingLayer.setVisible(false, false);
    }

    public String getLoadingText() {
        return this.myLoadingLayer.myText.getText();
    }

    public void setLoadingText(String loadingText) {
        this.myLoadingLayer.myText.setText(loadingText);
    }

    public boolean isLoading() {
        return this.myLoadingLayer.isLoading();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "icon";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/ui/LoadingDecorator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLayeredPane
    extends JBLayeredPane
    implements CursorAware {
        private final JComponent myContent;

        private MyLayeredPane(JComponent content) {
            this.myContent = content;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.myContent != null && !this.isMinimumSizeSet() ? this.myContent.getMinimumSize() : super.getMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myContent != null && !this.isPreferredSizeSet() ? this.myContent.getPreferredSize() : super.getPreferredSize();
        }

        @Override
        public void doLayout() {
            super.doLayout();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component each = this.getComponent(i);
                if (each instanceof Icon) {
                    each.setBounds(0, 0, each.getWidth(), each.getHeight());
                    continue;
                }
                each.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    public static interface CursorAware {
    }

    private class LoadingLayer
    extends JPanel {
        private final JLabel myText;
        private BufferedImage mySnapshot;
        private Color mySnapshotBg;
        private final AsyncProcessIcon myProgress;
        private boolean myVisible;
        private float myCurrentAlpha;
        private final NonOpaquePanel myTextComponent;

        private LoadingLayer(AsyncProcessIcon processIcon) {
            if (processIcon == null) {
                LoadingLayer.$$$reportNull$$$0(0);
            }
            this.myText = new JLabel("", 0);
            this.setOpaque(false);
            this.setVisible(false);
            this.myProgress = processIcon;
            this.myProgress.setOpaque(false);
            this.myTextComponent = LoadingDecorator.this.customizeLoadingLayer(this, this.myText, this.myProgress);
            this.myProgress.suspend();
        }

        public void setVisible(boolean visible, boolean takeSnapshot) {
            if (this.myVisible == visible) {
                return;
            }
            if (this.myVisible && !visible && this.myCurrentAlpha != -1.0f) {
                return;
            }
            this.myVisible = visible;
            LoadingDecorator.this.myFadeOutAnimator.reset();
            if (this.myVisible) {
                this.setVisible(this.myVisible);
                this.myCurrentAlpha = -1.0f;
                if (takeSnapshot && this.getWidth() > 0 && this.getHeight() > 0) {
                    this.mySnapshot = UIUtil.createImage((Graphics)this.getGraphics(), (int)this.getWidth(), (int)this.getHeight(), (int)1);
                    Graphics2D g = this.mySnapshot.createGraphics();
                    LoadingDecorator.this.myPane.paint(g);
                    Component opaque = UIUtil.findNearestOpaque((Component)this);
                    this.mySnapshotBg = opaque != null ? opaque.getBackground() : UIUtil.getPanelBackground();
                    g.dispose();
                }
                this.myProgress.resume();
                LoadingDecorator.this.myFadeOutAnimator.suspend();
            } else {
                this.disposeSnapshot();
                this.myProgress.suspend();
                LoadingDecorator.this.myFadeOutAnimator.resume();
            }
        }

        public boolean isLoading() {
            return this.myVisible;
        }

        private void disposeSnapshot() {
            if (this.mySnapshot != null) {
                this.mySnapshot.flush();
                this.mySnapshot = null;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.mySnapshot != null) {
                if (this.mySnapshot.getWidth() == this.getWidth() && this.mySnapshot.getHeight() == this.getHeight()) {
                    g.drawImage(this.mySnapshot, 0, 0, this.getWidth(), this.getHeight(), null);
                    g.setColor(new Color(200, 200, 200, 240));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    return;
                }
                this.disposeSnapshot();
            }
            if (this.mySnapshotBg != null) {
                g.setColor(this.mySnapshotBg);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public void setAlpha(float alpha) {
            this.myCurrentAlpha = alpha;
            this.paintImmediately(this.myTextComponent.getBounds());
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (this.myCurrentAlpha != -1.0f) {
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, this.myCurrentAlpha));
            }
            super.paintChildren(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processIcon", "com/intellij/openapi/ui/LoadingDecorator$LoadingLayer", "<init>"));
        }
    }
}

