/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturingProcessHandler
extends OSProcessHandler {
    private static final Logger LOG = Logger.getInstance(CapturingProcessHandler.class);
    private final ProcessOutput myOutput;

    public CapturingProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            CapturingProcessHandler.$$$reportNull$$$0(0);
        }
        super(commandLine);
        this.myOutput = new ProcessOutput();
        this.addProcessListener((ProcessListener)this.createProcessAdapter(this.myOutput));
    }

    @Deprecated
    public CapturingProcessHandler(@NotNull Process process) {
        if (process == null) {
            CapturingProcessHandler.$$$reportNull$$$0(1);
        }
        this(process, null, "");
    }

    @Deprecated
    public CapturingProcessHandler(@NotNull Process process, @Nullable Charset charset) {
        if (process == null) {
            CapturingProcessHandler.$$$reportNull$$$0(2);
        }
        this(process, charset, "");
    }

    public CapturingProcessHandler(@NotNull Process process, @Nullable Charset charset, String commandLine) {
        if (process == null) {
            CapturingProcessHandler.$$$reportNull$$$0(3);
        }
        super(process, commandLine, charset);
        this.myOutput = new ProcessOutput();
        this.addProcessListener((ProcessListener)this.createProcessAdapter(this.myOutput));
    }

    protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
        return new CapturingProcessAdapter(processOutput);
    }

    @NotNull
    public ProcessOutput runProcess() {
        this.startNotify();
        if (this.waitFor()) {
            this.setErrorCodeIfNotYetSet();
        } else {
            LOG.info("runProcess: exit value unavailable");
        }
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(4);
        }
        return processOutput;
    }

    private void setErrorCodeIfNotYetSet() {
        if (!this.myOutput.isExitCodeSet()) {
            this.myOutput.setExitCode(this.getProcess().exitValue());
        }
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds) {
        return this.runProcess(timeoutInMilliseconds, true);
    }

    public ProcessOutput runProcess(int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (timeoutInMilliseconds <= 0) {
            return this.runProcess();
        }
        this.startNotify();
        if (this.waitFor(timeoutInMilliseconds)) {
            this.setErrorCodeIfNotYetSet();
        } else {
            if (destroyOnTimeout) {
                this.destroyProcess();
            }
            this.myOutput.setTimeout();
        }
        return this.myOutput;
    }

    public Charset getCharset() {
        return this.myCharset != null ? this.myCharset : super.getCharset();
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CapturingProcessHandler.$$$reportNull$$$0(5);
        }
        ProcessOutput processOutput = this.runProcessWithProgressIndicator(indicator, -1);
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(6);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds) {
        if (indicator == null) {
            CapturingProcessHandler.$$$reportNull$$$0(7);
        }
        ProcessOutput processOutput = this.runProcessWithProgressIndicator(indicator, timeoutInMilliseconds, true);
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(8);
        }
        return processOutput;
    }

    @NotNull
    public ProcessOutput runProcessWithProgressIndicator(@NotNull ProgressIndicator indicator, int timeoutInMilliseconds, boolean destroyOnTimeout) {
        if (indicator == null) {
            CapturingProcessHandler.$$$reportNull$$$0(9);
        }
        if (timeoutInMilliseconds <= 0) {
            timeoutInMilliseconds = Integer.MAX_VALUE;
        }
        int WAIT_INTERVAL = 100;
        int waitingTime = 0;
        boolean setExitCode = true;
        this.startNotify();
        while (!this.waitFor(100L)) {
            boolean destroying;
            boolean timeout = (waitingTime += 100) >= timeoutInMilliseconds;
            boolean canceled = indicator.isCanceled();
            if (!canceled && !timeout) continue;
            setExitCode = destroying = canceled || destroyOnTimeout;
            if (destroying && !this.isProcessTerminating() && !this.isProcessTerminated()) {
                this.destroyProcess();
            }
            if (canceled) {
                this.myOutput.setCancelled();
                break;
            }
            this.myOutput.setTimeout();
            break;
        }
        if (setExitCode) {
            if (this.waitFor()) {
                this.setErrorCodeIfNotYetSet();
            } else {
                LOG.info("runProcess: exit value unavailable");
            }
        }
        ProcessOutput processOutput = this.myOutput;
        if (processOutput == null) {
            CapturingProcessHandler.$$$reportNull$$$0(10);
        }
        return processOutput;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/CapturingProcessHandler";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/CapturingProcessHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressIndicator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

