/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels.code;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ipnb.configuration.IpnbConnectionManager;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbHideOutputAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeOutputPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbCodeSourcePanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbErrorPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbHtmlPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbImagePanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbLatexPanel;
import org.jetbrains.plugins.ipnb.editor.panels.code.IpnbStreamPanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbErrorOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbHtmlOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbImageOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbLatexOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbOutputCell;
import org.jetbrains.plugins.ipnb.format.cells.output.IpnbStreamOutputCell;

public class IpnbCodePanel
extends IpnbEditablePanel<JComponent, IpnbCodeCell> {
    private final Project myProject;
    @NotNull
    private final IpnbFileEditor myParent;
    private static final String COLLAPSED_METADATA = "collapsed";
    private IpnbCodeSourcePanel myCodeSourcePanel;
    private HideableOutputPanel myHideableOutputPanel;
    private boolean mySelectNext;
    private JComponent myLastAddedPanel;

    public IpnbCodePanel(@NotNull Project project, @NotNull IpnbFileEditor parent, @NotNull IpnbCodeCell cell) {
        if (project == null) {
            IpnbCodePanel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            IpnbCodePanel.$$$reportNull$$$0(1);
        }
        if (cell == null) {
            IpnbCodePanel.$$$reportNull$$$0(2);
        }
        super(cell, new BorderLayout());
        this.myProject = project;
        this.myParent = parent;
        this.myViewPanel = this.createViewPanel();
        this.add(this.myViewPanel);
        this.addRightClickMenu();
        this.addKeyListener((KeyListener)new KeyStrokeAdapter(){

            public void keyPressed(KeyEvent event) {
                IpnbCodePanel.this.myParent.getIpnbFilePanel().processKeyPressed(event);
            }
        });
        this.setBorder(BorderFactory.createLineBorder(IpnbEditorUtil.getBackground()));
    }

    @NotNull
    public IpnbFileEditor getFileEditor() {
        IpnbFileEditor ipnbFileEditor = this.myParent;
        if (ipnbFileEditor == null) {
            IpnbCodePanel.$$$reportNull$$$0(3);
        }
        return ipnbFileEditor;
    }

    public Editor getEditor() {
        return this.myCodeSourcePanel.getEditor();
    }

    @Override
    public void addPromptPanel(@NotNull JComponent parent, Integer promptNumber, @NotNull IpnbEditorUtil.PromptType promptType, @NotNull JComponent component) {
        if (parent == null) {
            IpnbCodePanel.$$$reportNull$$$0(4);
        }
        if (promptType == null) {
            IpnbCodePanel.$$$reportNull$$$0(5);
        }
        if (component == null) {
            IpnbCodePanel.$$$reportNull$$$0(6);
        }
        super.addPromptPanel(parent, promptNumber, promptType, component);
        this.myLastAddedPanel = component;
    }

    @Override
    protected JComponent createViewPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0));
        panel.setBackground(IpnbEditorUtil.getBackground());
        panel.add(this.createCodeComponent());
        this.myHideableOutputPanel = new HideableOutputPanel();
        panel.add((Component)((Object)this.myHideableOutputPanel));
        return panel;
    }

    @Override
    protected void addRightClickMenu() {
        this.myHideableOutputPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                    ListPopup menu = IpnbCodePanel.this.createPopupMenu(new DefaultActionGroup(new AnAction[]{new IpnbHideOutputAction(IpnbCodePanel.this)}));
                    menu.show(RelativePoint.fromScreen((Point)e.getLocationOnScreen()));
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.myLastAddedPanel = null;
        this.myCodeSourcePanel.dispose();
        this.myCodeSourcePanel = null;
        this.myHideableOutputPanel.removeAll();
        this.myHideableOutputPanel = null;
        this.myViewPanel.removeAll();
        this.myViewPanel = null;
    }

    @NotNull
    private JPanel createCodeComponent() {
        this.myCodeSourcePanel = new IpnbCodeSourcePanel(this.myProject, this, (IpnbCodeCell)this.myCell);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(IpnbEditorUtil.getBackground());
        this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), IpnbEditorUtil.PromptType.In, this.myCodeSourcePanel);
        JPanel topComponent = new JPanel(new BorderLayout());
        topComponent.add((Component)panel, "First");
        JPanel jPanel = topComponent;
        if (jPanel == null) {
            IpnbCodePanel.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createOutputPanel() {
        JPanel outputPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, true, false));
        outputPanel.setBackground(IpnbEditorUtil.getBackground());
        for (IpnbOutputCell outputCell : ((IpnbCodeCell)this.myCell).getCellOutputs()) {
            this.addOutputPanel(outputPanel, outputCell, outputCell instanceof IpnbOutOutputCell);
        }
        JPanel jPanel = outputPanel;
        if (jPanel == null) {
            IpnbCodePanel.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public void hideOutputPanel() {
        this.myHideableOutputPanel.hideOutputPanel();
    }

    @NotNull
    private MouseAdapter createShowOutputListener(final OnePixelSplitter splitter, final JPanel secondPanel, final JLabel label) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                    this.showOutputPanel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.updateBackground(UIUtil.getListSelectionBackground());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.updateBackground(IpnbEditorUtil.getBackground());
            }

            private void updateBackground(Color background) {
                secondPanel.setBackground(background);
                label.setBackground(background);
            }

            private void showOutputPanel() {
                IpnbCodePanel.this.setOutputStateInCell(false);
                this.updateBackground(IpnbEditorUtil.getBackground());
                splitter.setFirstComponent(null);
                JPanel outputPanel = IpnbCodePanel.this.createOutputPanel();
                splitter.setSecondComponent((JComponent)outputPanel);
            }
        };
        if (mouseAdapter == null) {
            IpnbCodePanel.$$$reportNull$$$0(9);
        }
        return mouseAdapter;
    }

    private void setOutputStateInCell(boolean isCollapsed) {
        Map<String, Object> metadata = ((IpnbCodeCell)this.myCell).getMetadata();
        if (!metadata.containsKey(COLLAPSED_METADATA) && !isCollapsed) {
            return;
        }
        metadata.put(COLLAPSED_METADATA, isCollapsed);
    }

    private JPanel createToggleBar(OnePixelSplitter splitter) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(AllIcons.Actions.Down);
        panel.setBackground(IpnbEditorUtil.getBackground());
        label.setBackground(IpnbEditorUtil.getBackground());
        panel.add((Component)label, "Center");
        panel.addMouseListener(this.createShowOutputListener(splitter, panel, label));
        return panel;
    }

    private void addOutputPanel(@NotNull JComponent mainPanel, @NotNull IpnbOutputCell outputCell, boolean addPrompt) {
        if (mainPanel == null) {
            IpnbCodePanel.$$$reportNull$$$0(10);
        }
        if (outputCell == null) {
            IpnbCodePanel.$$$reportNull$$$0(11);
        }
        IpnbEditorUtil.PromptType promptType = addPrompt ? IpnbEditorUtil.PromptType.Out : IpnbEditorUtil.PromptType.None;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(IpnbEditorUtil.getBackground());
        if (outputCell instanceof IpnbImageOutputCell) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbImagePanel((IpnbImageOutputCell)outputCell, this));
        } else if (outputCell instanceof IpnbHtmlOutputCell) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbHtmlPanel((IpnbHtmlOutputCell)outputCell, this.myParent.getIpnbFilePanel(), this));
        } else if (outputCell instanceof IpnbLatexOutputCell) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbLatexPanel((IpnbLatexOutputCell)outputCell, this.myParent.getIpnbFilePanel(), this));
        } else if (outputCell instanceof IpnbErrorOutputCell) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbErrorPanel((IpnbErrorOutputCell)outputCell, this));
        } else if (outputCell instanceof IpnbStreamOutputCell) {
            if (this.myLastAddedPanel instanceof IpnbStreamPanel) {
                ((IpnbStreamPanel)this.myLastAddedPanel).addOutput(outputCell);
                return;
            }
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), IpnbEditorUtil.PromptType.None, new IpnbStreamPanel((IpnbStreamOutputCell)outputCell, this));
        } else if (outputCell.getSourceAsString() != null) {
            this.addPromptPanel(panel, ((IpnbCodeCell)this.myCell).getPromptNumber(), promptType, new IpnbCodeOutputPanel<IpnbOutputCell>(outputCell, this.myParent.getIpnbFilePanel(), this));
        }
        mainPanel.add(panel);
    }

    @Override
    public void switchToEditing() {
        this.setEditing(true);
        IdeFocusManager.findInstance().requestFocus((Component)this.myCodeSourcePanel.getEditor().getContentComponent(), true);
    }

    @Override
    public void runCell(boolean selectNext) {
        this.mySelectNext = selectNext;
        this.updateCellSource();
        this.updatePrompt();
        IpnbConnectionManager connectionManager = IpnbConnectionManager.getInstance(this.myProject);
        connectionManager.executeCell(this);
        this.setEditing(false);
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void updateCellSource() {
        Document document = this.myCodeSourcePanel.getEditor().getDocument();
        String text = document.getText();
        if (StringUtil.isEmpty((String)text) && ((IpnbCodeCell)this.myCell).getSource().isEmpty()) {
            return;
        }
        ((IpnbCodeCell)this.myCell).setSource(Arrays.asList(StringUtil.splitByLinesKeepSeparators((String)text)));
    }

    public void updatePrompt() {
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> {
            ((IpnbCodeCell)this.myCell).setPromptNumber(-1);
            String promptText = IpnbEditorUtil.prompt(((IpnbCodeCell)this.myCell).getPromptNumber(), IpnbEditorUtil.PromptType.In);
            this.myPromptLabel.setText(promptText);
        }, ModalityState.stateForComponent((Component)this));
    }

    public void finishExecution() {
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> {
            String promptText = IpnbEditorUtil.prompt(((IpnbCodeCell)this.myCell).getPromptNumber(), IpnbEditorUtil.PromptType.In);
            this.myPromptLabel.setText(promptText);
            IpnbFilePanel filePanel = this.myParent.getIpnbFilePanel();
            this.setEditing(false);
            IdeFocusManager.findInstance().requestFocus((Component)filePanel, true);
            if (this.mySelectNext) {
                filePanel.selectNext(this, true);
            }
            if (this.myOnFinish != null) {
                this.myOnFinish.run();
                this.myOnFinish = null;
            }
        }, ModalityState.stateForComponent((Component)this));
    }

    public void updatePanel(@Nullable String replacementContent, @Nullable IpnbOutputCell outputContent) {
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> {
            if (replacementContent == null && outputContent == null) {
                ((IpnbCodeCell)this.myCell).removeCellOutputs();
                this.myViewPanel.removeAll();
                application.runReadAction(() -> {
                    JComponent panel = this.createViewPanel();
                    this.myViewPanel.add(panel);
                    String prompt = IpnbEditorUtil.prompt(-1, IpnbEditorUtil.PromptType.In);
                    this.myPromptLabel.setText(prompt);
                });
            }
            if (replacementContent != null) {
                if (replacementContent.isEmpty() || ((IpnbCodeCell)this.myCell).getSource().isEmpty()) {
                    ((IpnbCodeCell)this.myCell).setSource(Arrays.asList(StringUtil.splitByLinesKeepSeparators((String)replacementContent)));
                }
                String prompt = IpnbEditorUtil.prompt(null, IpnbEditorUtil.PromptType.In);
                ((IpnbCodeCell)this.myCell).setPromptNumber(null);
                this.myPromptLabel.setText(prompt);
                application.runWriteAction(() -> this.myCodeSourcePanel.getEditor().getDocument().setText((CharSequence)replacementContent));
            }
            if (outputContent != null) {
                ((IpnbCodeCell)this.myCell).addCellOutput(outputContent);
                JComponent component = this.myHideableOutputPanel.getSecondComponent();
                if (component != null) {
                    this.addOutputPanel(component, outputContent, outputContent instanceof IpnbOutOutputCell);
                }
            }
        }, ModalityState.stateForComponent((Component)this));
    }

    @Override
    public void updateCellView() {
        this.myViewPanel.removeAll();
        JComponent panel = this.createViewPanel();
        this.myViewPanel.add(panel);
    }

    @Override
    public int getCaretPosition() {
        return this.myCodeSourcePanel.getEditor().getCaretModel().getOffset();
    }

    @Override
    @Nullable
    public String getText(int from, int to) {
        return this.myCodeSourcePanel.getEditor().getDocument().getText(new TextRange(from, to));
    }

    @Override
    public String getText(int from) {
        return this.getText(from, this.myCodeSourcePanel.getEditor().getDocument().getTextLength());
    }

    @Override
    protected Object clone() {
        return new IpnbCodePanel(this.myProject, this.myParent, (IpnbCodeCell)((IpnbCodeCell)this.myCell).clone());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promptType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/panels/code/IpnbCodePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOutputPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createShowOutputListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPromptPanel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addOutputPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class HideableOutputPanel
    extends OnePixelSplitter {
        final JPanel myToggleBar;
        final JPanel myOutputComponent;

        public HideableOutputPanel() {
            boolean isCollapsed;
            super(true);
            this.myToggleBar = IpnbCodePanel.this.createToggleBar(this);
            this.myOutputComponent = IpnbCodePanel.this.createOutputPanel();
            Map<String, Object> metadata = ((IpnbCodeCell)IpnbCodePanel.this.myCell).getMetadata();
            if (metadata.containsKey(IpnbCodePanel.COLLAPSED_METADATA) && (isCollapsed = ((Boolean)metadata.get(IpnbCodePanel.COLLAPSED_METADATA)).booleanValue()) && !((IpnbCodeCell)IpnbCodePanel.this.myCell).getCellOutputs().isEmpty()) {
                this.setFirstComponent(this.myToggleBar);
                return;
            }
            this.setSecondComponent(this.myOutputComponent);
        }

        public void hideOutputPanel() {
            IpnbCodePanel.this.setOutputStateInCell(true);
            this.setFirstComponent(this.myToggleBar);
            this.setSecondComponent(null);
        }
    }
}

