/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.actions.IpnbRunCellBaseAction;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;

public class IpnbRunAllCellsAction
extends IpnbRunCellBaseAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        DataContext context;
        IpnbFileEditor ipnbEditor;
        if (event == null) {
            IpnbRunAllCellsAction.$$$reportNull$$$0(0);
        }
        if ((ipnbEditor = (IpnbFileEditor)((Object)IpnbFileEditor.DATA_KEY.getData(context = event.getDataContext()))) != null) {
            IpnbFilePanel ipnbFilePanel = ipnbEditor.getIpnbFilePanel();
            List<IpnbEditablePanel> cells = ipnbFilePanel.getIpnbPanels();
            if (cells.isEmpty()) {
                return;
            }
            IpnbRunAllCellsAction.runCells(Collections.unmodifiableList(cells), ipnbFilePanel);
        }
    }

    private static void runCells(List<IpnbEditablePanel> cells, IpnbFilePanel ipnbFilePanel) {
        for (int i = 0; i < cells.size(); ++i) {
            IpnbEditablePanel cell = cells.get(i);
            int nextIndex = i + 1;
            if (nextIndex >= cells.size()) continue;
            IpnbEditablePanel nextCell = cells.get(nextIndex);
            cell.onFinishExecutionAction(() -> nextCell.runCell(nextIndex != cells.size() - 1));
        }
        IpnbEditablePanel firstPanel = cells.get(0);
        ipnbFilePanel.setSelectedCell(firstPanel, false);
        firstPanel.runCell(true);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)ipnbFilePanel, true));
    }

    public void update(AnActionEvent e) {
        DataContext context = e.getDataContext();
        IpnbFileEditor ipnbEditor = (IpnbFileEditor)((Object)IpnbFileEditor.DATA_KEY.getData(context));
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(ipnbEditor != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ipnb/editor/actions/IpnbRunAllCellsAction", "actionPerformed"));
    }
}

