/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.configuration;

import com.intellij.ide.DataManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.UI;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.configuration.PyActiveSdkModuleConfigurable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.configuration.IpnbConnectionManager;
import org.jetbrains.plugins.ipnb.configuration.IpnbSettings;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;

public class IpnbConfigurable
implements SearchableConfigurable {
    private JPanel myMainPanel;
    private JBTextField myUsernameField;
    private JLabel myInterpreterSetupLinkLabel;
    private JPasswordField myPasswordField;
    private JPanel myProPanel;
    private JCheckBox myMarkdownCheckBox;
    private final Project myProject;
    private static final String DEFAULT_USERNAME_TEXT = "Leave empty for a single-user notebook";

    public IpnbConfigurable(@NotNull Project project) {
        if (project == null) {
            IpnbConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myProPanel.setVisible(PlatformUtils.isPyCharmPro() || PlatformUtils.isIdeaUltimate());
        this.myInterpreterSetupLinkLabel.setForeground(UI.getColor((String)"link.foreground"));
        this.myInterpreterSetupLinkLabel.setCursor(new Cursor(12));
        this.createNavigateToInterpreterSettingsListener().installOn((Component)this.myInterpreterSetupLinkLabel);
        this.myUsernameField.addFocusListener((FocusListener)IpnbConfigurable.createInitialTextFocusAdapter(this.myUsernameField, DEFAULT_USERNAME_TEXT));
        IpnbConfigurable.setInitialText(this.myUsernameField, IpnbSettings.getInstance(this.myProject).getUsername(), DEFAULT_USERNAME_TEXT);
    }

    @Nls
    public String getDisplayName() {
        return "Jupyter Notebook";
    }

    public String getHelpTopic() {
        return "reference-ipnb";
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    @NotNull
    public String getId() {
        if ("IpnbConfigurable" == null) {
            IpnbConfigurable.$$$reportNull$$$0(1);
        }
        return "IpnbConfigurable";
    }

    @NotNull
    private ClickListener createNavigateToInterpreterSettingsListener() {
        ClickListener clickListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                Settings settings;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)IpnbConfigurable.this.myMainPanel))) != null) {
                    settings.select(settings.find(PyActiveSdkModuleConfigurable.class.getName()));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ipnb/configuration/IpnbConfigurable$1", "onClick"));
            }
        };
        if (clickListener == null) {
            IpnbConfigurable.$$$reportNull$$$0(2);
        }
        return clickListener;
    }

    public void apply() {
        IpnbSettings ipnbSettings = IpnbSettings.getInstance(this.myProject);
        ipnbSettings.setHasFx(this.myMarkdownCheckBox.isSelected());
        for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors()) {
            if (!(editor instanceof IpnbFileEditor)) continue;
            VirtualFile file = ((IpnbFileEditor)editor).getVirtualFile();
            FileEditorManager.getInstance((Project)this.myProject).closeFile(file);
            FileEditorManager.getInstance((Project)this.myProject).openFile(file, false);
        }
        if (this.myProPanel.isVisible()) {
            String oldUsername = ipnbSettings.getUsername();
            String oldPassword = ipnbSettings.getPassword(this.myProject.getLocationHash());
            String newUsername = this.getUsername();
            String newPassword = String.valueOf(this.myPasswordField.getPassword());
            if (!oldUsername.equals(newUsername) || !oldPassword.equals(newPassword)) {
                IpnbConnectionManager.getInstance(this.myProject).shutdownKernels();
                ipnbSettings.setUsername(newUsername);
                ipnbSettings.setPassword(newPassword, this.myProject.getLocationHash());
            }
        }
    }

    public void reset() {
        IpnbSettings ipnbSettings = IpnbSettings.getInstance(this.myProject);
        boolean hasFx = ipnbSettings.hasFx();
        this.myMarkdownCheckBox.setSelected(hasFx);
        if (this.myProPanel.isVisible()) {
            String savedUsername = ipnbSettings.getUsername();
            IpnbConfigurable.setInitialText(this.myUsernameField, savedUsername, DEFAULT_USERNAME_TEXT);
            String savedPassword = ipnbSettings.getPassword(this.myProject.getLocationHash());
            this.myPasswordField.setText(savedPassword);
        }
    }

    public boolean isModified() {
        IpnbSettings ipnbSettings = IpnbSettings.getInstance(this.myProject);
        boolean hasFx = ipnbSettings.hasFx();
        if (hasFx != this.myMarkdownCheckBox.isSelected()) {
            return true;
        }
        if (this.myProPanel.isVisible()) {
            String oldUsername = ipnbSettings.getUsername();
            String oldPassword = ipnbSettings.getPassword(this.myProject.getLocationHash());
            String newPassword = String.valueOf(this.myPasswordField.getPassword());
            String newUsername = this.getUsername();
            return !oldPassword.equals(newPassword) || !oldUsername.equals(newUsername);
        }
        return false;
    }

    private String getUsername() {
        String usernameText = this.myUsernameField.getText();
        return DEFAULT_USERNAME_TEXT.equals(usernameText) ? "" : usernameText;
    }

    @NotNull
    private static FocusAdapter createInitialTextFocusAdapter(final @NotNull JBTextField field, final @NotNull String initialText) {
        if (field == null) {
            IpnbConfigurable.$$$reportNull$$$0(3);
        }
        if (initialText == null) {
            IpnbConfigurable.$$$reportNull$$$0(4);
        }
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (field.getText().equals(initialText)) {
                    field.setForeground(UIUtil.getActiveTextColor());
                    field.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (field.getText().isEmpty()) {
                    field.setForeground(UIUtil.getInactiveTextColor());
                    field.setText(initialText);
                }
            }
        };
        if (focusAdapter == null) {
            IpnbConfigurable.$$$reportNull$$$0(5);
        }
        return focusAdapter;
    }

    private static void setInitialText(@NotNull JBTextField field, @NotNull String savedValue, @NotNull String defaultText) {
        if (field == null) {
            IpnbConfigurable.$$$reportNull$$$0(6);
        }
        if (savedValue == null) {
            IpnbConfigurable.$$$reportNull$$$0(7);
        }
        if (defaultText == null) {
            IpnbConfigurable.$$$reportNull$$$0(8);
        }
        if (savedValue.isEmpty()) {
            field.setForeground(UIUtil.getInactiveTextColor());
            field.setText(defaultText);
        } else {
            field.setForeground(UIUtil.getActiveTextColor());
            field.setText(savedValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/configuration/IpnbConfigurable";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "savedValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/configuration/IpnbConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigateToInterpreterSettingsListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialTextFocusAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInitialTextFocusAdapter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setInitialText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JPasswordField jPasswordField;
        JBTextField jBTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myProPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 4, 2, 1, 1, 3, 3, null, null, null));
        this.myUsernameField = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Username:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Password:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myInterpreterSetupLinkLabel = jLabel = new JLabel();
        jLabel.setText("Configure remote interpreter");
        jPanel.add((Component)jLabel, new GridConstraints(2, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myMarkdownCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Markdown cells rendering enabled");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

