/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Template;
import org.msgpack.unpacker.Unpacker;

public class MapTemplate<K, V>
extends AbstractTemplate<Map<K, V>> {
    private Template<K> keyTemplate;
    private Template<V> valueTemplate;

    public MapTemplate(Template<K> keyTemplate, Template<V> valueTemplate) {
        this.keyTemplate = keyTemplate;
        this.valueTemplate = valueTemplate;
    }

    @Override
    public void write(Packer pk, Map<K, V> target, boolean required) throws IOException {
        if (!(target instanceof Map)) {
            if (target == null) {
                if (required) {
                    throw new MessageTypeException("Attempted to write null");
                }
                pk.writeNil();
                return;
            }
            throw new MessageTypeException("Target is not a Map but " + target.getClass());
        }
        Map<K, V> map = target;
        pk.writeMapBegin(map.size());
        for (Map.Entry<K, V> pair : map.entrySet()) {
            this.keyTemplate.write(pk, pair.getKey());
            this.valueTemplate.write(pk, pair.getValue());
        }
        pk.writeMapEnd();
    }

    @Override
    public Map<K, V> read(Unpacker u, Map<K, V> to, boolean required) throws IOException {
        Map<K, V> map;
        if (!required && u.trySkipNil()) {
            return null;
        }
        int n = u.readMapBegin();
        if (to != null) {
            map = to;
            map.clear();
        } else {
            map = new HashMap(n);
        }
        for (int i = 0; i < n; ++i) {
            Object key = this.keyTemplate.read(u, null);
            Object value = this.valueTemplate.read(u, null);
            map.put(key, value);
        }
        u.readMapEnd();
        return map;
    }
}

