/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.jruby.embed.jsr223.ServiceFinder;

public class JRubyScriptEngineManager {
    static final String SERVICE = "META-INF/services/javax.script.ScriptEngineFactory";
    private final Collection<ScriptEngineFactory> factories;
    private final Map<String, ScriptEngineFactory> nameMap = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> extensionMap = new HashMap<String, ScriptEngineFactory>();
    private final Map<String, ScriptEngineFactory> mimetypeMap = new HashMap<String, ScriptEngineFactory>();
    private Bindings globalMap = new SimpleBindings();

    public JRubyScriptEngineManager() throws ScriptException {
        this(null);
    }

    public JRubyScriptEngineManager(ClassLoader loader) throws ScriptException {
        try {
            this.factories = new ServiceFinder(SERVICE, loader).getServices();
            if (this.factories.isEmpty()) {
                System.err.println("no factory");
            }
            this.prepareMaps();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ScriptException(e);
        }
    }

    private void prepareMaps() {
        for (ScriptEngineFactory factory : this.factories) {
            List<String> names2 = factory.getNames();
            for (String name2 : names2) {
                this.nameMap.put(name2, factory);
            }
            List<String> extensions = factory.getExtensions();
            for (String extension : extensions) {
                this.extensionMap.put(extension, factory);
            }
            List<String> mimeTypes = factory.getMimeTypes();
            for (String mimeType : mimeTypes) {
                this.mimetypeMap.put(mimeType, factory);
            }
        }
    }

    public void setBindings(Bindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("Null bindings");
        }
        this.globalMap = bindings;
    }

    public Bindings getBindings() {
        return this.globalMap;
    }

    public void put(String key2, Object value2) {
        this.globalMap.put(key2, value2);
    }

    public Object get(String key2) {
        return this.globalMap.get(key2);
    }

    public ScriptEngine getEngineByName(String shortName) {
        if (shortName == null) {
            throw new NullPointerException("Null shortName");
        }
        ScriptEngineFactory factory = this.nameMap.get(shortName);
        if (factory == null) {
            throw new IllegalArgumentException("No engine for " + shortName);
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.getContext().setBindings(this.globalMap, 200);
        return engine;
    }

    public ScriptEngine getEngineByExtension(String extension) {
        if (extension == null) {
            throw new NullPointerException("Null extension");
        }
        ScriptEngineFactory factory = this.extensionMap.get(extension);
        if (factory == null) {
            throw new IllegalArgumentException("No engine for " + extension);
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.getContext().setBindings(this.globalMap, 200);
        return engine;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("Null mimeType");
        }
        ScriptEngineFactory factory = this.mimetypeMap.get(mimeType);
        if (factory == null) {
            throw new IllegalArgumentException("No engine for " + mimeType);
        }
        ScriptEngine engine = factory.getScriptEngine();
        engine.getContext().setBindings(this.globalMap, 200);
        return engine;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        return Collections.unmodifiableList(new ArrayList<ScriptEngineFactory>(this.factories));
    }

    public void registerEngineName(String name2, ScriptEngineFactory factory) {
        if (name2 == null || factory == null) {
            throw new NullPointerException("name and/or factory is null.");
        }
        this.nameMap.put(name2, factory);
    }

    public void registerEngineMimeType(String type2, ScriptEngineFactory factory) {
        if (type2 == null || factory == null) {
            throw new NullPointerException("type and/or factory is null.");
        }
        this.mimetypeMap.put(type2, factory);
    }

    public void registerEngineExtension(String extension, ScriptEngineFactory factory) {
        if (extension == null || factory == null) {
            throw new NullPointerException("extension and/or factory is null.");
        }
        this.extensionMap.put(extension, factory);
    }
}

