/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import nokogiri.NokogiriService;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFloat;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.NodeList;

public class NokogiriXPathFunction
implements XPathFunction {
    private static NokogiriXPathFunction xpathFunction;
    private IRubyObject handler;
    private String name;
    private int arity;

    public static NokogiriXPathFunction create(IRubyObject iRubyObject, String string, int n) {
        if (xpathFunction == null) {
            xpathFunction = new NokogiriXPathFunction();
        }
        try {
            NokogiriXPathFunction nokogiriXPathFunction = (NokogiriXPathFunction)xpathFunction.clone();
            nokogiriXPathFunction.init(iRubyObject, string, n);
            return nokogiriXPathFunction;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            NokogiriXPathFunction nokogiriXPathFunction = new NokogiriXPathFunction();
            nokogiriXPathFunction.init(iRubyObject, string, n);
            return nokogiriXPathFunction;
        }
    }

    private void init(IRubyObject iRubyObject, String string, int n) {
        this.handler = iRubyObject;
        this.name = string;
        this.arity = n;
    }

    private NokogiriXPathFunction() {
    }

    public Object evaluate(List list) throws XPathFunctionException {
        if (list.size() != this.arity) {
            throw new XPathFunctionException("arity does not match");
        }
        Ruby ruby = this.handler.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        IRubyObject iRubyObject = RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.handler, (String)this.name, (IRubyObject[])this.fromObjectToRubyArgs(list));
        return this.fromRubyToObject(iRubyObject);
    }

    private IRubyObject[] fromObjectToRubyArgs(List list) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            iRubyObjectArray[i] = this.fromObjectToRuby(list.get(i));
        }
        return iRubyObjectArray;
    }

    private IRubyObject fromObjectToRuby(Object object) {
        Ruby ruby = this.handler.getRuntime();
        if (object instanceof NodeList) {
            XmlNodeSet xmlNodeSet = (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::NodeSet"));
            xmlNodeSet.setNodeList((NodeList)object);
            return xmlNodeSet;
        }
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)ruby, (Object)object);
    }

    private Object fromRubyToObject(IRubyObject iRubyObject) {
        Ruby ruby = this.handler.getRuntime();
        if (iRubyObject instanceof RubyString) {
            return iRubyObject.toJava(String.class);
        }
        if (iRubyObject instanceof RubyFloat) {
            return iRubyObject.toJava(Double.class);
        }
        if (iRubyObject instanceof RubyBoolean) {
            return iRubyObject.toJava(Boolean.class);
        }
        if (iRubyObject instanceof XmlNodeSet) {
            return (NodeList)iRubyObject;
        }
        if (iRubyObject instanceof RubyArray) {
            XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(ruby.getCurrentContext(), (RubyArray)iRubyObject);
            return xmlNodeSet;
        }
        return ((XmlNode)iRubyObject).getNode();
    }
}

