/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import com.sun.star.wiki.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    private static Settings m_instance;
    private final XComponentContext m_xContext;
    private final List<Map<String, String>> m_WikiConnections = new ArrayList<Map<String, String>>();
    private final List<Map<String, Object>> m_aWikiDocs = new ArrayList<Map<String, Object>>();

    private Settings(XComponentContext xComponentContext) {
        this.m_xContext = xComponentContext;
        this.loadConfiguration();
    }

    public static synchronized Settings getSettings(XComponentContext xComponentContext) {
        if (m_instance == null) {
            m_instance = new Settings(xComponentContext);
        }
        return m_instance;
    }

    public void addWikiCon(Map<String, String> map) {
        this.m_WikiConnections.add(map);
    }

    private String getWikiConUrlByNumber(int n) {
        String string = "";
        if (n >= 0 && n < this.m_WikiConnections.size()) {
            Map<String, String> map = this.m_WikiConnections.get(n);
            string = map.get("Url");
        }
        return string;
    }

    public void addWikiDoc(Map<String, Object> map) {
        String string = (String)map.get("CompleteUrl");
        Map<String, Object> map2 = this.getDocByCompleteUrl(string);
        if (map2 != null) {
            this.m_aWikiDocs.remove(map2);
        } else if (this.m_aWikiDocs.size() > 10) {
            this.m_aWikiDocs.remove(0);
        }
        this.m_aWikiDocs.add(map);
    }

    public Object[] getWikiDocList(int n) {
        String string = this.getWikiConUrlByNumber(n);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{};
        for (int i = 0; i < this.m_aWikiDocs.size(); ++i) {
            Map<String, Object> map = this.m_aWikiDocs.get(i);
            String string2 = (String)map.get("Url");
            if (!string2.equals(string)) continue;
            arrayList.add((String)map.get("Doc"));
        }
        return arrayList.toArray(stringArray);
    }

    public String[] getWikiURLs() {
        String[] stringArray = new String[this.m_WikiConnections.size()];
        for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
            Map<String, String> map = this.m_WikiConnections.get(i);
            stringArray[i] = map.get("Url");
        }
        return stringArray;
    }

    public Map<String, String> getSettingByUrl(String string) {
        Map<String, String> map = null;
        for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
            Map<String, String> map2 = this.m_WikiConnections.get(i);
            String string2 = map2.get("Url");
            if (!string2.equals(string)) continue;
            map = map2;
            try {
                String[] stringArray;
                String string3 = map.get("Username");
                String string4 = map.get("Password");
                if (string3 == null || string3.length() <= 0 || string4 != null && string4.length() != 0 || (stringArray = Helper.GetPasswordsForURLAndUser(this.m_xContext, string, string3)) == null || stringArray.length <= 0) break;
                map.put("Password", stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break;
        }
        return map;
    }

    private Map<String, Object> getDocByCompleteUrl(String string) {
        Map<String, Object> map = null;
        for (int i = 0; i < this.m_aWikiDocs.size(); ++i) {
            Map<String, Object> map2 = this.m_aWikiDocs.get(i);
            String string2 = (String)map2.get("CompleteUrl");
            if (!string2.equals(string)) continue;
            map = map2;
        }
        return map;
    }

    public void removeSettingByUrl(String string) {
        for (int i = 0; i < this.m_WikiConnections.size(); ++i) {
            Map<String, String> map = this.m_WikiConnections.get(i);
            String string2 = map.get("Url");
            if (!string2.equals(string)) continue;
            this.m_WikiConnections.remove(i);
        }
    }

    public void storeConfiguration() {
        try {
            Object object;
            XSingleServiceFactory xSingleServiceFactory;
            XNameContainer xNameContainer = Helper.GetConfigNameContainer(this.m_xContext, "org.openoffice.Office.Custom.WikiExtension/ConnectionList");
            for (String object2 : xSingleServiceFactory = xNameContainer.getElementNames()) {
                xNameContainer.removeByName(object2);
            }
            XSingleServiceFactory xSingleServiceFactory2 = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xNameContainer);
            for (Map<String, String> map : this.m_WikiConnections) {
                Object object2 = xSingleServiceFactory2.createInstance();
                object = (XNameReplace)UnoRuntime.queryInterface(XNameReplace.class, (Object)object2);
                if (object != null) {
                    object.replaceByName("UserName", (Object)map.get("Username"));
                }
                xNameContainer.insertByName(map.get("Url"), object);
            }
            XChangesBatch xChangesBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)xNameContainer);
            xChangesBatch.commitChanges();
            xNameContainer = Helper.GetConfigNameContainer(this.m_xContext, "org.openoffice.Office.Custom.WikiExtension/RecentDocs");
            for (String string : xSingleServiceFactory = xNameContainer.getElementNames()) {
                xNameContainer.removeByName(string);
            }
            xSingleServiceFactory2 = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xNameContainer);
            int n = 0;
            for (Map<String, Object> map : this.m_aWikiDocs) {
                object = xSingleServiceFactory2.createInstance();
                XNameReplace xNameReplace = (XNameReplace)UnoRuntime.queryInterface(XNameReplace.class, (Object)object);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    xNameReplace.replaceByName(entry.getKey(), entry.getValue());
                }
                xNameContainer.insertByName("d" + n++, (Object)xNameReplace);
            }
            XChangesBatch xChangesBatch2 = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)xNameContainer);
            xChangesBatch2.commitChanges();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadConfiguration() {
        block7: {
            this.m_WikiConnections.clear();
            try {
                String[] stringArray;
                String[] stringArray2;
                XNameAccess xNameAccess = Helper.GetConfigNameAccess(this.m_xContext, "org.openoffice.Office.Custom.WikiExtension");
                if (xNameAccess == null) break block7;
                Object object = xNameAccess.getByName("ConnectionList");
                XNameAccess xNameAccess2 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object);
                for (String string : stringArray2 = xNameAccess2.getElementNames()) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("Url", string);
                    hashMap.put("Username", "");
                    hashMap.put("Password", "");
                    try {
                        String string2;
                        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xNameAccess2.getByName(string));
                        if (xPropertySet != null && (string2 = AnyConverter.toString((Object)xPropertySet.getPropertyValue("UserName"))) != null && string2.length() > 0) {
                            hashMap.put("Username", string2);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.addWikiCon(hashMap);
                }
                Object object2 = xNameAccess.getByName("RecentDocs");
                XNameAccess xNameAccess3 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object2);
                for (String string2 : stringArray = xNameAccess3.getElementNames()) {
                    Object object3 = xNameAccess3.getByName(string2);
                    XNameAccess xNameAccess4 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)object3);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("Url", xNameAccess4.getByName("Url"));
                    hashMap.put("CompleteUrl", xNameAccess4.getByName("CompleteUrl"));
                    hashMap.put("Doc", xNameAccess4.getByName("Doc"));
                    this.addWikiDoc(hashMap);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

