/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.docprovider.formatters.formatters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.runtime.Boot;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.Formatter;

public abstract class ReplacingTextFormatter
implements Formatter {
    public static String backupVersion;
    public static final Pattern BOLD_OPEN_PATTERN;
    public static final Pattern BOLD_CLOSE_PATTERN;

    @Override
    public String process(String s1) {
        Matcher m1 = BOLD_OPEN_PATTERN.matcher(s1);
        String s2 = m1.replaceAll(this.getBoldOpening());
        Matcher m2 = BOLD_CLOSE_PATTERN.matcher(s2);
        return m2.replaceAll(this.getBoldClosing());
    }

    protected String localizeTitle(String s) {
        return Translator.R("man" + s);
    }

    @Override
    public String getBold(String s) {
        return this.getBoldOpening() + s + this.getBoldClosing();
    }

    @Override
    public String getUrl(String url) {
        return this.getUrl(url, url);
    }

    @Override
    public String getUrl(String url, String look) {
        if (look == null || look.trim().length() == 0 || url.equals(look)) {
            return url;
        }
        return look + " (" + url + ")";
    }

    public String getVersion() {
        if (Boot.version == null) {
            if (backupVersion == null) {
                return "unknown version";
            }
            return backupVersion;
        }
        return Boot.version;
    }

    @Override
    public String getNewLine(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(this.getNewLine());
        }
        return sb.toString();
    }

    static {
        BOLD_OPEN_PATTERN = Pattern.compile("<\\s*[Bb]\\s*>");
        BOLD_CLOSE_PATTERN = Pattern.compile("<\\s*/\\s*[Bb]\\s*>");
    }
}

