/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javax.realtime.MemoryArea;
import javolution.context.Context;
import javolution.context.ObjectPool;
import javolution.context.RealtimeObject;
import javolution.lang.ClassInitializer;
import javolution.lang.Configurable;
import javolution.lang.Reflection;
import javolution.util.FastTable;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectFactory<T> {
    public static final Configurable<Integer> COUNT = new Configurable(new Integer(256)){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyChange() {
            Object object = LOCK;
            synchronized (object) {
                final int n = COUNT.get();
                if (_Count >= n) {
                    throw new UnsupportedOperationException("Already " + _Count + " factories, cannot reduce to " + n);
                }
                MemoryArea.getMemoryArea(_Instances).executeInArea(new Runnable(){

                    public void run() {
                        ObjectFactory[] objectFactoryArray = new ObjectFactory[n];
                        System.arraycopy(_Instances, 0, objectFactoryArray, 0, _Count);
                        _Instances = objectFactoryArray;
                    }
                });
            }
        }
    };
    private static final Object LOCK = new Object();
    static ObjectFactory[] _Instances = new ObjectFactory[COUNT.get().intValue()];
    static int _Count;
    final int _index;
    private boolean _doCleanup = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectFactory() {
        Object object = LOCK;
        synchronized (object) {
            if (_Count >= _Instances.length) {
                throw new UnsupportedOperationException("Configuration setting of a maximum " + _Instances.length + " factories has been reached");
            }
            Class<?> clazz = this.getClass();
            for (int i = 0; i < _Count; ++i) {
                if (clazz != _Instances[i].getClass()) continue;
                throw new UnsupportedOperationException(clazz + "  cannot have more than one instance");
            }
            this._index = _Count++;
            ObjectFactory._Instances[this._index] = this;
        }
    }

    protected abstract T create();

    public T object() {
        return this.currentPool().next();
    }

    public void recycle(T t) {
        this.currentPool().recycle(t);
    }

    public final ObjectPool<T> currentPool() {
        Context context = Context.current();
        ObjectPool objectPool = context._poolsShortcut[this._index];
        return objectPool != null && objectPool._user != null ? objectPool : context.getPool(this._index, true);
    }

    protected void cleanup(T t) {
        this._doCleanup = false;
    }

    protected final boolean doCleanup() {
        return this._doCleanup;
    }

    protected ObjectPool newStackPool() {
        return new StackPool(this);
    }

    protected ObjectPool newHeapPool() {
        return new HeapPool(this);
    }

    static ObjectFactory getInstance(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(36);
        if (n > 0) {
            ClassInitializer.initialize(string.substring(0, n));
        }
        ClassInitializer.initialize(clazz);
        for (int i = 0; i < _Count; ++i) {
            if (!_Instances[i].getClass().equals(clazz)) continue;
            return _Instances[i];
        }
        return null;
    }

    private static final class StackPool
    extends ObjectPool
    implements Runnable {
        static final XMLFormat XML = new XMLFormat((Class)new StackPool(null).getClass()){

            public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
                Class clazz2;
                try {
                    clazz2 = Reflection.getClass(inputElement.getAttribute("factory"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new XMLStreamException(classNotFoundException);
                }
                RealtimeObject.Factory factory = (RealtimeObject.Factory)ObjectFactory.getInstance(clazz2);
                return new StackPool(factory);
            }

            public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
                StackPool stackPool = (StackPool)object;
                ObjectPool.XML.read(inputElement, stackPool);
            }

            public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
                StackPool stackPool = (StackPool)object;
                ObjectPool.XML.write(stackPool, outputElement);
            }
        };
        private final FastTable _objects = new FastTable();
        private final ObjectFactory _factory;
        private int _index;
        private Object _tmpObject;

        private StackPool(ObjectFactory objectFactory) {
            this._factory = objectFactory;
        }

        public ObjectFactory getFactory() {
            return this._factory;
        }

        public int getSize() {
            return this._objects.size();
        }

        public void setSize(int n) {
            for (int i = this.getSize(); i < n; ++i) {
                this._objects.addLast(this._factory.create());
            }
        }

        public Object next() {
            return this._index < this._objects.size() ? this._objects.get(this._index++) : this.newObject();
        }

        private Object newObject() {
            MemoryArea.getMemoryArea(this).executeInArea(this);
            this._objects.add(this._tmpObject);
            ++this._index;
            return this._tmpObject;
        }

        public void recycle(Object object) {
            this._factory.cleanup(object);
            int n = this._index;
            while (--n >= 0) {
                if (this._objects.get(n) != object) continue;
                Object e = this._objects.get(--this._index);
                this._objects.set(n, e);
                this._objects.set(this._index, object);
                return;
            }
            throw new IllegalArgumentException("Object not in the pool");
        }

        protected void recycleAll() {
            for (int i = 0; i < this._index && this._factory._doCleanup; ++i) {
                Object e = this._objects.get(i);
                this._factory.cleanup(e);
            }
            this._index = 0;
        }

        protected void clearAll() {
            this._objects.clear();
            this._index = 0;
        }

        public void run() {
            this._tmpObject = this._factory.create();
        }
    }

    private static final class HeapPool
    extends ObjectPool {
        static final XMLFormat XML = new XMLFormat((Class)new HeapPool(null).getClass()){

            public Object newInstance(Class clazz, XMLFormat.InputElement inputElement) throws XMLStreamException {
                Class clazz2;
                try {
                    clazz2 = Reflection.getClass(inputElement.getAttribute("factory"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new XMLStreamException(classNotFoundException);
                }
                RealtimeObject.Factory factory = (RealtimeObject.Factory)ObjectFactory.getInstance(clazz2);
                return new HeapPool(factory);
            }

            public void read(XMLFormat.InputElement inputElement, Object object) throws XMLStreamException {
                HeapPool heapPool = (HeapPool)object;
                ObjectPool.XML.read(inputElement, heapPool);
            }

            public void write(Object object, XMLFormat.OutputElement outputElement) throws XMLStreamException {
                HeapPool heapPool = (HeapPool)object;
                ObjectPool.XML.write(heapPool, outputElement);
            }
        };
        private final FastTable _objects = new FastTable();
        private final ObjectFactory _factory;

        private HeapPool(ObjectFactory objectFactory) {
            this._factory = objectFactory;
        }

        public ObjectFactory getFactory() {
            return this._factory;
        }

        public int getSize() {
            return this._objects.size();
        }

        public void setSize(int n) {
            for (int i = this.getSize(); i < n; ++i) {
                this._objects.addLast(this._factory.create());
            }
        }

        public Object next() {
            return this._objects.isEmpty() ? this._factory.create() : this._objects.removeLast();
        }

        public void recycle(Object object) {
            this._factory.cleanup(object);
            if (MemoryArea.getMemoryArea(object) != MemoryArea.getMemoryArea(this)) {
                return;
            }
            this._objects.addLast(object);
        }

        protected void recycleAll() {
        }

        protected void clearAll() {
            this._objects.clear();
        }
    }
}

