/* Copyright (C) 1997,1998,1999,2000,2001,2006 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
   02110-1301 USA.  */

/*
 *	ISO C99: 7.18 Integer types <stdint.h>
 */

/*
 * ISSUE:
 * This file is based on the system stdint.h for ia32
 */
#ifndef _STDINT_IA32_H
#define _STDINT_IA32_H	1

#include "custom_limits.h"

/* Exact integral types.  */

/* Signed.  */

/* There is some amount of overlap with <sys/types.h> as known by inet code */
typedef signed char		int8_t;
typedef short int		int16_t;
typedef int			int32_t;
#ifndef NO_LONGLONG
typedef long long int		int64_t;
#endif

/* Unsigned.  */
typedef unsigned char		uint8_t;
typedef unsigned short int	uint16_t;
typedef unsigned int		uint32_t;
#ifndef NO_LONGLONG
typedef unsigned long long int	uint64_t;
#endif

#endif /* stdint_ia32.h */
