/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.jhotdraw.geom.BezierPath;

public class BezierPathIterator
implements PathIterator {
    private int index = 0;
    private BezierPath path;
    private AffineTransform affine;
    private static final int[] curvesize = new int[]{2, 2, 4, 6, 0};

    public BezierPathIterator(BezierPath bezierPath) {
        this(bezierPath, null);
    }

    public BezierPathIterator(BezierPath bezierPath, AffineTransform affineTransform) {
        this.path = bezierPath;
        this.affine = affineTransform;
    }

    @Override
    public int getWindingRule() {
        return this.path.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.index >= this.path.size() + (this.path.isClosed() ? 2 : 0);
    }

    @Override
    public void next() {
        if (!this.isDone()) {
            ++this.index;
        }
    }

    @Override
    public int currentSegment(float[] fArray) {
        int n = 0;
        int n2 = 0;
        if (this.index == this.path.size()) {
            if (this.path.size() > 1) {
                BezierPath.Node node = (BezierPath.Node)this.path.get(this.path.size() - 1);
                BezierPath.Node node2 = (BezierPath.Node)this.path.get(0);
                if ((node.mask & 2) == 0) {
                    if ((node2.mask & 1) == 0) {
                        n = 1;
                        n2 = 1;
                        fArray[0] = (float)node2.x[0];
                        fArray[1] = (float)node2.y[0];
                    } else {
                        n = 2;
                        n2 = 2;
                        fArray[0] = (float)node2.x[1];
                        fArray[1] = (float)node2.y[1];
                        fArray[2] = (float)node2.x[0];
                        fArray[3] = (float)node2.y[0];
                    }
                } else if ((node2.mask & 1) == 0) {
                    n = 2;
                    n2 = 2;
                    fArray[0] = (float)node.x[2];
                    fArray[1] = (float)node.y[2];
                    fArray[2] = (float)node2.x[0];
                    fArray[3] = (float)node2.y[0];
                } else {
                    n = 3;
                    n2 = 3;
                    fArray[0] = (float)node.x[2];
                    fArray[1] = (float)node.y[2];
                    fArray[2] = (float)node2.x[1];
                    fArray[3] = (float)node2.y[1];
                    fArray[4] = (float)node2.x[0];
                    fArray[5] = (float)node2.y[0];
                }
            }
        } else {
            if (this.index > this.path.size()) {
                return 4;
            }
            if (this.index == 0) {
                BezierPath.Node node = (BezierPath.Node)this.path.get(this.index);
                fArray[0] = (float)node.x[0];
                fArray[1] = (float)node.y[0];
                n = 1;
                n2 = 0;
            } else if (this.index < this.path.size()) {
                BezierPath.Node node = (BezierPath.Node)this.path.get(this.index);
                BezierPath.Node node3 = (BezierPath.Node)this.path.get(this.index - 1);
                if ((node3.mask & 2) == 0) {
                    if ((node.mask & 1) == 0) {
                        n = 1;
                        n2 = 1;
                        fArray[0] = (float)node.x[0];
                        fArray[1] = (float)node.y[0];
                    } else {
                        n = 2;
                        n2 = 2;
                        fArray[0] = (float)node.x[1];
                        fArray[1] = (float)node.y[1];
                        fArray[2] = (float)node.x[0];
                        fArray[3] = (float)node.y[0];
                    }
                } else if ((node.mask & 1) == 0) {
                    n = 2;
                    n2 = 2;
                    fArray[0] = (float)node3.x[2];
                    fArray[1] = (float)node3.y[2];
                    fArray[2] = (float)node.x[0];
                    fArray[3] = (float)node.y[0];
                } else {
                    n = 3;
                    n2 = 3;
                    fArray[0] = (float)node3.x[2];
                    fArray[1] = (float)node3.y[2];
                    fArray[2] = (float)node.x[1];
                    fArray[3] = (float)node.y[1];
                    fArray[4] = (float)node.x[0];
                    fArray[5] = (float)node.y[0];
                }
            }
        }
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, n);
        }
        return n2;
    }

    @Override
    public int currentSegment(double[] dArray) {
        int n = 0;
        int n2 = 0;
        if (this.index == this.path.size()) {
            if (this.path.size() > 1) {
                BezierPath.Node node = (BezierPath.Node)this.path.get(this.path.size() - 1);
                BezierPath.Node node2 = (BezierPath.Node)this.path.get(0);
                if ((node.mask & 2) == 0) {
                    if ((node2.mask & 1) == 0) {
                        n = 1;
                        n2 = 1;
                        dArray[0] = node2.x[0];
                        dArray[1] = node2.y[0];
                    } else {
                        n = 2;
                        n2 = 2;
                        dArray[0] = node2.x[1];
                        dArray[1] = node2.y[1];
                        dArray[2] = node2.x[0];
                        dArray[3] = node2.y[0];
                    }
                } else if ((node2.mask & 1) == 0) {
                    n = 2;
                    n2 = 2;
                    dArray[0] = node.x[2];
                    dArray[1] = node.y[2];
                    dArray[2] = node2.x[0];
                    dArray[3] = node2.y[0];
                } else {
                    n = 3;
                    n2 = 3;
                    dArray[0] = node.x[2];
                    dArray[1] = node.y[2];
                    dArray[2] = node2.x[1];
                    dArray[3] = node2.y[1];
                    dArray[4] = node2.x[0];
                    dArray[5] = node2.y[0];
                }
            }
        } else {
            if (this.index > this.path.size()) {
                return 4;
            }
            if (this.index == 0) {
                BezierPath.Node node = (BezierPath.Node)this.path.get(this.index);
                dArray[0] = node.x[0];
                dArray[1] = node.y[0];
                n = 1;
                n2 = 0;
            } else if (this.index < this.path.size()) {
                BezierPath.Node node = (BezierPath.Node)this.path.get(this.index);
                BezierPath.Node node3 = (BezierPath.Node)this.path.get(this.index - 1);
                if ((node3.mask & 2) == 0) {
                    if ((node.mask & 1) == 0) {
                        n = 1;
                        n2 = 1;
                        dArray[0] = node.x[0];
                        dArray[1] = node.y[0];
                    } else {
                        n = 2;
                        n2 = 2;
                        dArray[0] = node.x[1];
                        dArray[1] = node.y[1];
                        dArray[2] = node.x[0];
                        dArray[3] = node.y[0];
                    }
                } else if ((node.mask & 1) == 0) {
                    n = 2;
                    n2 = 2;
                    dArray[0] = node3.x[2];
                    dArray[1] = node3.y[2];
                    dArray[2] = node.x[0];
                    dArray[3] = node.y[0];
                } else {
                    n = 3;
                    n2 = 3;
                    dArray[0] = node3.x[2];
                    dArray[1] = node3.y[2];
                    dArray[2] = node.x[1];
                    dArray[3] = node.y[1];
                    dArray[4] = node.x[0];
                    dArray[5] = node.y[0];
                }
            }
        }
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, n);
        } else {
            System.arraycopy(dArray, 0, dArray, 0, n);
        }
        return n2;
    }
}

