"""Generated message classes for containeranalysis version v1alpha1.

An API to insert and retrieve annotations on container resources.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'containeranalysis'


class AliasContext(_messages.Message):
  """An alias to a repo revision.

  Enums:
    KindValueValuesEnum: The alias kind.

  Fields:
    kind: The alias kind.
    name: The alias name.
  """

  class KindValueValuesEnum(_messages.Enum):
    """The alias kind.

    Values:
      ANY: Do not use.
      FIXED: Git tag
      MOVABLE: Git branch
      OTHER: OTHER is used to specify non-standard aliases, those not of the
        kinds above. For example, if a Git repo has a ref named
        "refs/foo/bar", it is considered to be of kind OTHER.
    """
    ANY = 0
    FIXED = 1
    MOVABLE = 2
    OTHER = 3

  kind = _messages.EnumField('KindValueValuesEnum', 1)
  name = _messages.StringField(2)


class Artifact(_messages.Message):
  """Artifact destribes a build product.

  Fields:
    checksum: Hash or checksum value of a binary, or Docker Registry 2.0
      digest of a container.
    id: Artifact ID, if any; for container images, this will be a URL by
      digest like gcr.io/projectID/imagename@sha256:123456
    name: Name of the artifact. This may be the path to a binary or jar file,
      or in the case of a container build, the name used to push the container
      image to Google Container Registry, as presented to `docker push`.  This
      field is deprecated in favor of the plural `names` field; it continues
      to exist here to allow existing BuildProvenance serialized to json in
      google.devtools.containeranalysis.v1alpha1.BuildDetails.provenance_bytes
      to deserialize back into proto.
    names: Related artifact names. This may be the path to a binary or jar
      file, or in the case of a container build, the name used to push the
      container image to Google Container Registry, as presented to `docker
      push`. Note that a single Artifact ID can have multiple names, for
      example if two tags are applied to one image.
  """

  checksum = _messages.StringField(1)
  id = _messages.StringField(2)
  name = _messages.StringField(3)
  names = _messages.StringField(4, repeated=True)


class AuditConfig(_messages.Message):
  """Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
      Next ID: 4
    exemptedMembers: A string attribute.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  exemptedMembers = _messages.StringField(2, repeated=True)
  service = _messages.StringField(3)


class AuditLogConfig(_messages.Message):
  """Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    """The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class Basis(_messages.Message):
  """Basis describes the base image portion (Note) of the DockerImage
  relationship.  Linked occurrences are derived from this or an equivalent
  image via:   FROM <Basis.resource_url> Or an equivalent reference, e.g. a
  tag of the resource_url.

  Fields:
    fingerprint: The fingerprint of the base image
    resourceUrl: The resource_url for the resource representing the basis of
      associated occurrence images.
  """

  fingerprint = _messages.MessageField('Fingerprint', 1)
  resourceUrl = _messages.StringField(2)


class Binding(_messages.Message):
  """Associates `members` with a `role`.

  Fields:
    condition: The condition that is associated with this binding. NOTE: an
      unsatisfied condition will not allow user access via current binding.
      Different bindings, including their conditions, are examined
      independently. This field is GOOGLE_INTERNAL.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      or `joe@example.com`.   * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class BuildDetails(_messages.Message):
  """Message encapsulating build provenance details

  Fields:
    provenance: The actual provenance
    provenanceBytes: Serialized json representation of the provenance, used in
      generating the BuildSignature in the corresponding Result. After
      verifying the signature, provenance_bytes can be unmarshalled and
      compared to the provenance to confirm that it is unchanged. A
      base64-encoded string representation of the provenance bytes is used for
      the signature in order to interoperate with openssl which expects this
      format for signature verification.  The serialized form is captured both
      to avoid ambiguity in how the provenance is marshalled to json as well
      to prevent incompatibilities with future changes.
  """

  provenance = _messages.MessageField('BuildProvenance', 1)
  provenanceBytes = _messages.StringField(2)


class BuildProvenance(_messages.Message):
  """Provenance of a build. Contains all information needed to verify the full
  details about the build from source to completion.

  Messages:
    BuildOptionsValue: Special options applied to this build. This is a catch-
      all field where build providers can enter any desired additional
      details.

  Fields:
    buildOptions: Special options applied to this build. This is a catch-all
      field where build providers can enter any desired additional details.
    builderVersion: Version string of the builder at the time this build was
      executed.
    builtArtifacts: Output of the build.
    commands: Commands requested by the build.
    createTime: Time at which the build was created.
    creator: E-mail address of the user who initiated this build. Note that
      this was the user's e-mail address at the time the build was initiated;
      this address may not represent the same end-user for all time.
    finishTime: Time at whihc execution of the build was finished.
    id: Unique identifier of the build.
    logsBucket: Google Cloud Storage bucket where logs were written.
    projectId: ID of the project.
    sourceProvenance: Details of the Source input to the build.
    startTime: Time at which execution of the build was started.
    triggerId: Trigger identifier if the build was triggered automatically;
      empty if not.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BuildOptionsValue(_messages.Message):
    """Special options applied to this build. This is a catch-all field where
    build providers can enter any desired additional details.

    Messages:
      AdditionalProperty: An additional property for a BuildOptionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type BuildOptionsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a BuildOptionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  buildOptions = _messages.MessageField('BuildOptionsValue', 1)
  builderVersion = _messages.StringField(2)
  builtArtifacts = _messages.MessageField('Artifact', 3, repeated=True)
  commands = _messages.MessageField('Command', 4, repeated=True)
  createTime = _messages.StringField(5)
  creator = _messages.StringField(6)
  finishTime = _messages.StringField(7)
  id = _messages.StringField(8)
  logsBucket = _messages.StringField(9)
  projectId = _messages.StringField(10)
  sourceProvenance = _messages.MessageField('Source', 11)
  startTime = _messages.StringField(12)
  triggerId = _messages.StringField(13)


class BuildSignature(_messages.Message):
  """Message encapsulating signature of the verified build

  Enums:
    KeyTypeValueValuesEnum: The type of the key, either stored in `public_key`
      or referenced in `key_id`

  Fields:
    keyId: An ID for the key used to sign.  This could be either an ID for the
      key stored in `public_key` (e.g., the ID or fingerprint for a PGP key,
      or the CN for a cert), or a reference to an external key (e.g., a
      reference to a key in Cloud KMS).
    keyType: The type of the key, either stored in `public_key` or referenced
      in `key_id`
    publicKey: Public key of the builder which can be used to verify that
      related Findings are valid and unchanged.  If `key_type` is empty this
      defaults to PEM encoded public keys.  This field may be empty if
      `key_id` references an external key.  For Cloud Container Builder based
      signatures this is a PEM encoded public key. To verify the Cloud
      Container Builder signature, place the contents of this field into a
      file (public.pem). The signature field is base64-decoded into its binary
      representation in signature.bin, and the provenance bytes from
      BuildDetails are base64-decoded into a binary representation in
      signed.bin. OpenSSL can then verify the signature: `openssl sha256
      -verify public.pem -signature signature.bin signed.bin`
    signature: Signature of the related BuildProvenance, encoded in a base64
      string.
  """

  class KeyTypeValueValuesEnum(_messages.Enum):
    """The type of the key, either stored in `public_key` or referenced in
    `key_id`

    Values:
      UNSET: KeyType is not set.
      PGP_ASCII_ARMORED: PGP ASCII Armored public key.
      PKIX_PEM: PKIX PEM public key.
    """
    UNSET = 0
    PGP_ASCII_ARMORED = 1
    PKIX_PEM = 2

  keyId = _messages.StringField(1)
  keyType = _messages.EnumField('KeyTypeValueValuesEnum', 2)
  publicKey = _messages.StringField(3)
  signature = _messages.StringField(4)


class BuildType(_messages.Message):
  """Note holding the version of the provider's builder and the signature of
  the provenance message in linked BuildDetails.

  Fields:
    builderVersion: Version of the builder which produced this Note.
    signature: Signature of the build in Occurrences pointing to the Note
      containing this BuilderDetails.
  """

  builderVersion = _messages.StringField(1)
  signature = _messages.MessageField('BuildSignature', 2)


class CloudAuditOptions(_messages.Message):
  """Write a Cloud Audit log

  Enums:
    LogNameValueValuesEnum: The log_name to populate in the Cloud Audit
      Record.

  Fields:
    logName: The log_name to populate in the Cloud Audit Record.
  """

  class LogNameValueValuesEnum(_messages.Enum):
    """The log_name to populate in the Cloud Audit Record.

    Values:
      UNSPECIFIED_LOG_NAME: Default. Should not be used.
      ADMIN_ACTIVITY: Corresponds to "cloudaudit.googleapis.com/activity"
      DATA_ACCESS: Corresponds to "cloudaudit.googleapis.com/data_access"
    """
    UNSPECIFIED_LOG_NAME = 0
    ADMIN_ACTIVITY = 1
    DATA_ACCESS = 2

  logName = _messages.EnumField('LogNameValueValuesEnum', 1)


class CloudRepoSourceContext(_messages.Message):
  """A CloudRepoSourceContext denotes a particular revision in a cloud repo (a
  repo hosted by the Google Cloud Platform).

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    aliasName: The name of an alias (branch, tag, etc.).
    repoId: The ID of the repo.
    revisionId: A revision ID.
  """

  aliasContext = _messages.MessageField('AliasContext', 1)
  aliasName = _messages.StringField(2)
  repoId = _messages.MessageField('RepoId', 3)
  revisionId = _messages.StringField(4)


class CloudWorkspaceId(_messages.Message):
  """A CloudWorkspaceId is a unique identifier for a cloud workspace. A cloud
  workspace is a place associated with a repo where modified files can be
  stored before they are committed.

  Fields:
    name: The unique name of the workspace within the repo.  This is the name
      chosen by the client in the Source API's CreateWorkspace method.
    repoId: The ID of the repo containing the workspace.
  """

  name = _messages.StringField(1)
  repoId = _messages.MessageField('RepoId', 2)


class CloudWorkspaceSourceContext(_messages.Message):
  """A CloudWorkspaceSourceContext denotes a workspace at a particular
  snapshot.

  Fields:
    snapshotId: The ID of the snapshot. An empty snapshot_id refers to the
      most recent snapshot.
    workspaceId: The ID of the workspace.
  """

  snapshotId = _messages.StringField(1)
  workspaceId = _messages.MessageField('CloudWorkspaceId', 2)


class Command(_messages.Message):
  """Command describes a step performed as part of the build pipeline.

  Fields:
    args: Command-line arguments used when executing this Command.
    dir: Working directory (relative to project source root) used when running
      this Command.
    env: Environment variables set before running this Command.
    id: Optional unique identifier for this Command, used in wait_for to
      reference this Command as a dependency.
    name: Name of the command, as presented on the command line, or if the
      command is packaged as a Docker container, as presented to `docker
      pull`.
    waitFor: The ID(s) of the Command(s) that this Command depends on.
  """

  args = _messages.StringField(1, repeated=True)
  dir = _messages.StringField(2)
  env = _messages.StringField(3, repeated=True)
  id = _messages.StringField(4)
  name = _messages.StringField(5)
  waitFor = _messages.StringField(6, repeated=True)


class Condition(_messages.Message):
  """A condition to be met.

  Enums:
    IamValueValuesEnum: Trusted attributes supplied by the IAM system.
    OpValueValuesEnum: An operator to apply the subject with.
    SysValueValuesEnum: Trusted attributes supplied by any service that owns
      resources and uses the IAM system for access control.

  Fields:
    iam: Trusted attributes supplied by the IAM system.
    op: An operator to apply the subject with.
    svc: Trusted attributes discharged by the service.
    sys: Trusted attributes supplied by any service that owns resources and
      uses the IAM system for access control.
    value: DEPRECATED. Use 'values' instead.
    values: The objects of the condition. This is mutually exclusive with
      'value'.
  """

  class IamValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by the IAM system.

    Values:
      NO_ATTR: Default non-attribute.
      AUTHORITY: Either principal or (if present) authority selector.
      ATTRIBUTION: The principal (even if an authority selector is present),
        which must only be used for attribution, not authorization.
      APPROVER: An approver (distinct from the requester) that has authorized
        this request. When used with IN, the condition indicates that one of
        the approvers associated with the request matches the specified
        principal, or is a member of the specified group. Approvers can only
        grant additional access, and are thus only used in a strictly positive
        context (e.g. ALLOW/IN or DENY/NOT_IN).
      JUSTIFICATION_TYPE: What types of justifications have been supplied with
        this request. String values should match enum names from
        tech.iam.JustificationType, e.g. "MANUAL_STRING". It is not permitted
        to grant access based on the *absence* of a justification, so
        justification conditions can only be used in a "positive" context
        (e.g., ALLOW/IN or DENY/NOT_IN).  Multiple justifications, e.g., a
        Buganizer ID and a manually-entered reason, are normal and supported.
    """
    NO_ATTR = 0
    AUTHORITY = 1
    ATTRIBUTION = 2
    APPROVER = 3
    JUSTIFICATION_TYPE = 4

  class OpValueValuesEnum(_messages.Enum):
    """An operator to apply the subject with.

    Values:
      NO_OP: Default no-op.
      EQUALS: DEPRECATED. Use IN instead.
      NOT_EQUALS: DEPRECATED. Use NOT_IN instead.
      IN: The condition is true if the subject (or any element of it if it is
        a set) matches any of the supplied values.
      NOT_IN: The condition is true if the subject (or every element of it if
        it is a set) matches none of the supplied values.
      DISCHARGED: Subject is discharged
    """
    NO_OP = 0
    EQUALS = 1
    NOT_EQUALS = 2
    IN = 3
    NOT_IN = 4
    DISCHARGED = 5

  class SysValueValuesEnum(_messages.Enum):
    """Trusted attributes supplied by any service that owns resources and uses
    the IAM system for access control.

    Values:
      NO_ATTR: Default non-attribute type
      REGION: Region of the resource
      SERVICE: Service name
      NAME: Resource name
      IP: IP address of the caller
    """
    NO_ATTR = 0
    REGION = 1
    SERVICE = 2
    NAME = 3
    IP = 4

  iam = _messages.EnumField('IamValueValuesEnum', 1)
  op = _messages.EnumField('OpValueValuesEnum', 2)
  svc = _messages.StringField(3)
  sys = _messages.EnumField('SysValueValuesEnum', 4)
  value = _messages.StringField(5)
  values = _messages.StringField(6, repeated=True)


class ContaineranalysisProjectsAcknowledgmentsGetIamPolicyRequest(_messages.Message):
  """A ContaineranalysisProjectsAcknowledgmentsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProjectsAcknowledgmentsSetIamPolicyRequest(_messages.Message):
  """A ContaineranalysisProjectsAcknowledgmentsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProjectsNotesCreateRequest(_messages.Message):
  """A ContaineranalysisProjectsNotesCreateRequest object.

  Fields:
    name: The name of the project. Should be of the form
      "providers/{provider_id}". @Deprecated
    note: A Note resource to be passed as the request body.
    noteId: The ID to use for this note.
    parent: This field contains the projectId for example:
      "project/{project_id}
  """

  name = _messages.StringField(1)
  note = _messages.MessageField('Note', 2)
  noteId = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class ContaineranalysisProjectsNotesDeleteRequest(_messages.Message):
  """A ContaineranalysisProjectsNotesDeleteRequest object.

  Fields:
    name: The name of the note in the form
      "providers/{provider_id}/notes/{note_id}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsNotesGetIamPolicyRequest(_messages.Message):
  """A ContaineranalysisProjectsNotesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProjectsNotesGetRequest(_messages.Message):
  """A ContaineranalysisProjectsNotesGetRequest object.

  Fields:
    name: The name of the note in the form
      "providers/{provider_id}/notes/{note_id}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsNotesListRequest(_messages.Message):
  """A ContaineranalysisProjectsNotesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name field will contain the projectId for example:
      "providers/{provider_id} @Deprecated
    pageSize: Number of notes to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: This field contains the projectId for example:
      "project/{project_id}
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ContaineranalysisProjectsNotesOccurrencesListRequest(_messages.Message):
  """A ContaineranalysisProjectsNotesOccurrencesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name field will contain the note name for example:
      "provider/{provider_id}/notes/{note_id}"
    pageSize: Number of notes to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ContaineranalysisProjectsNotesSetIamPolicyRequest(_messages.Message):
  """A ContaineranalysisProjectsNotesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProjectsNotesTestIamPermissionsRequest(_messages.Message):
  """A ContaineranalysisProjectsNotesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ContaineranalysisProjectsOccurrencesCreateRequest(_messages.Message):
  """A ContaineranalysisProjectsOccurrencesCreateRequest object.

  Fields:
    name: The name of the project.  Should be of the form
      "projects/{project_id}". @Deprecated
    occurrence: A Occurrence resource to be passed as the request body.
    parent: This field contains the projectId for example:
      "projects/{project_id}"
  """

  name = _messages.StringField(1)
  occurrence = _messages.MessageField('Occurrence', 2)
  parent = _messages.StringField(3, required=True)


class ContaineranalysisProjectsOccurrencesDeleteRequest(_messages.Message):
  """A ContaineranalysisProjectsOccurrencesDeleteRequest object.

  Fields:
    name: The name of the occurrence in the form
      "projects/{project_id}/occurrences/{occurrence_id}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetIamPolicyRequest(_messages.Message):
  """A ContaineranalysisProjectsOccurrencesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProjectsOccurrencesGetNotesRequest(_messages.Message):
  """A ContaineranalysisProjectsOccurrencesGetNotesRequest object.

  Fields:
    name: The name of the occurrence in the form
      "projects/{project_id}/occurrences/{occurrence_id}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesGetRequest(_messages.Message):
  """A ContaineranalysisProjectsOccurrencesGetRequest object.

  Fields:
    name: The name of the occurrence in the form
      "projects/{project_id}/occurrences/{occurrence_id}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProjectsOccurrencesListRequest(_messages.Message):
  """A ContaineranalysisProjectsOccurrencesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name field will contain the projectId for example:
      "projects/{project_id} @Deprecated
    pageSize: Number of occurrences to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: This contains the projectId for example: projects/{project_id}
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ContaineranalysisProjectsOccurrencesSetIamPolicyRequest(_messages.Message):
  """A ContaineranalysisProjectsOccurrencesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest(_messages.Message):
  """A ContaineranalysisProjectsOccurrencesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ContaineranalysisProvidersNotesCreateRequest(_messages.Message):
  """A ContaineranalysisProvidersNotesCreateRequest object.

  Fields:
    name: The name of the project. Should be of the form
      "providers/{provider_id}". @Deprecated
    note: A Note resource to be passed as the request body.
    noteId: The ID to use for this note.
    parent: This field contains the projectId for example:
      "project/{project_id}
  """

  name = _messages.StringField(1, required=True)
  note = _messages.MessageField('Note', 2)
  noteId = _messages.StringField(3)
  parent = _messages.StringField(4)


class ContaineranalysisProvidersNotesDeleteRequest(_messages.Message):
  """A ContaineranalysisProvidersNotesDeleteRequest object.

  Fields:
    name: The name of the note in the form
      "providers/{provider_id}/notes/{note_id}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProvidersNotesGetIamPolicyRequest(_messages.Message):
  """A ContaineranalysisProvidersNotesGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class ContaineranalysisProvidersNotesGetRequest(_messages.Message):
  """A ContaineranalysisProvidersNotesGetRequest object.

  Fields:
    name: The name of the note in the form
      "providers/{provider_id}/notes/{note_id}"
  """

  name = _messages.StringField(1, required=True)


class ContaineranalysisProvidersNotesListRequest(_messages.Message):
  """A ContaineranalysisProvidersNotesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name field will contain the projectId for example:
      "providers/{provider_id} @Deprecated
    pageSize: Number of notes to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
    parent: This field contains the projectId for example:
      "project/{project_id}
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5)


class ContaineranalysisProvidersNotesOccurrencesListRequest(_messages.Message):
  """A ContaineranalysisProvidersNotesOccurrencesListRequest object.

  Fields:
    filter: The filter expression.
    name: The name field will contain the note name for example:
      "provider/{provider_id}/notes/{note_id}"
    pageSize: Number of notes to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ContaineranalysisProvidersNotesSetIamPolicyRequest(_messages.Message):
  """A ContaineranalysisProvidersNotesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ContaineranalysisProvidersNotesTestIamPermissionsRequest(_messages.Message):
  """A ContaineranalysisProvidersNotesTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CounterOptions(_messages.Message):
  """Options for counters

  Fields:
    field: The field value to attribute.
    metric: The metric to update.
  """

  field = _messages.StringField(1)
  metric = _messages.StringField(2)


class DataAccessOptions(_messages.Message):
  """Write a Data Access (Gin) log"""


class Derived(_messages.Message):
  """Derived describes the derived image portion (Occurrence) of the
  DockerImage relationship.  This image would be produced from a Dockerfile
  with FROM <DockerImage.Basis in attached Note>.

  Fields:
    baseResourceUrl: This contains the base image url for the derived image
      Occurrence @OutputOnly
    distance: The number of layers by which this image differs from the
      associated image basis. @OutputOnly
    fingerprint: The fingerprint of the derived image
    layerInfo: This contains layer-specific metadata, if populated it has
      length \u201cdistance\u201d and is ordered with [distance] being the layer
      immediately following the base image and [1] being the final layer.
  """

  baseResourceUrl = _messages.StringField(1)
  distance = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  fingerprint = _messages.MessageField('Fingerprint', 3)
  layerInfo = _messages.MessageField('Layer', 4, repeated=True)


class Detail(_messages.Message):
  """Identifies all occurences of this vulnerability in the package for a
  specific distro/location For example: glibc in cpe:/o:debian:debian_linux:8
  for versions 2.1 - 2.2

  Fields:
    cpeUri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/)
      in which the vulnerability manifests.  Examples include distro or
      storage location for vulnerable jar. This field can be used as a filter
      in list requests.
    description: A vendor-specific description of this note.
    fixedLocation: The fix for this specific package version.
    maxAffectedVersion: The max version of the package in which the
      vulnerability exists. This field can be used as a filter in list
      requests.
    minAffectedVersion: The min version of the package in which the
      vulnerability exists.
    package: The name of the package where the vulnerability was found. This
      field can be used as a filter in list requests.
    severityName: The severity (eg: distro assigned severity) for this
      vulnerability.
  """

  cpeUri = _messages.StringField(1)
  description = _messages.StringField(2)
  fixedLocation = _messages.MessageField('VulnerabilityLocation', 3)
  maxAffectedVersion = _messages.MessageField('Version', 4)
  minAffectedVersion = _messages.MessageField('Version', 5)
  package = _messages.StringField(6)
  severityName = _messages.StringField(7)


class Distribution(_messages.Message):
  """This represents a particular channel of distribution for a given package.
  e.g. Debian's jessie-backports dpkg mirror

  Enums:
    ArchitectureValueValuesEnum: The CPU architecture for which packages in
      this distribution channel were built

  Fields:
    architecture: The CPU architecture for which packages in this distribution
      channel were built
    cpeUri: The cpe_uri in [cpe format](https://cpe.mitre.org/specification/)
      denoting the package manager version distributing a package.
    description: The distribution channel-specific description of this
      package.
    latestVersion: The latest available version of this package in this
      distribution channel.
    maintainer: A freeform string denoting the maintainer of this package.
    url: The distribution channel-specific homepage for this package.
  """

  class ArchitectureValueValuesEnum(_messages.Enum):
    """The CPU architecture for which packages in this distribution channel
    were built

    Values:
      UNKNOWN: Unknown architecture
      X86: X86 architecture
      X64: x64 architecture
    """
    UNKNOWN = 0
    X86 = 1
    X64 = 2

  architecture = _messages.EnumField('ArchitectureValueValuesEnum', 1)
  cpeUri = _messages.StringField(2)
  description = _messages.StringField(3)
  latestVersion = _messages.MessageField('Version', 4)
  maintainer = _messages.StringField(5)
  url = _messages.StringField(6)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  """Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class ExtendedSourceContext(_messages.Message):
  """An ExtendedSourceContext is a SourceContext combined with additional
  details describing the context.

  Messages:
    LabelsValue: Labels with user defined metadata.

  Fields:
    context: Any source context.
    labels: Labels with user defined metadata.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """Labels with user defined metadata.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  context = _messages.MessageField('SourceContext', 1)
  labels = _messages.MessageField('LabelsValue', 2)


class FileHashes(_messages.Message):
  """Container message for hashes of byte content of files, used in Source
  messages to verify integrity of source input to the build.

  Fields:
    fileHash: Collection of file hashes.
  """

  fileHash = _messages.MessageField('Hash', 1, repeated=True)


class Fingerprint(_messages.Message):
  """A set of properties that uniquely identify a given Docker image.

  Fields:
    v1Name: The layer-id of the final layer in the Docker image\u2019s v1
      representation. This field can be used as a filter in list requests.
    v2Blob: The ordered list of v2 blobs that represent a given image.
    v2Name: The name of the image\u2019s v2 blobs computed via:   [bottom] :=
      v2_blobbottom := sha256(v2_blob[N] + \u201c \u201d + v2_name[N+1]) Only the name
      of the final blob is kept. This field can be used as a filter in list
      requests. @OutputOnly
  """

  v1Name = _messages.StringField(1)
  v2Blob = _messages.StringField(2, repeated=True)
  v2Name = _messages.StringField(3)


class GerritSourceContext(_messages.Message):
  """A SourceContext referring to a Gerrit project.

  Fields:
    aliasContext: An alias, which may be a branch or tag.
    aliasName: The name of an alias (branch, tag, etc.).
    gerritProject: The full project name within the host. Projects may be
      nested, so "project/subproject" is a valid project name. The "repo name"
      is hostURI/project.
    hostUri: The URI of a running Gerrit instance.
    revisionId: A revision (commit) ID.
  """

  aliasContext = _messages.MessageField('AliasContext', 1)
  aliasName = _messages.StringField(2)
  gerritProject = _messages.StringField(3)
  hostUri = _messages.StringField(4)
  revisionId = _messages.StringField(5)


class GetIamPolicyRequest(_messages.Message):
  """Request message for `GetIamPolicy` method."""


class GitSourceContext(_messages.Message):
  """A GitSourceContext denotes a particular revision in a third party Git
  repository (e.g. GitHub).

  Fields:
    revisionId: Git commit hash. required.
    url: Git repository URL.
  """

  revisionId = _messages.StringField(1)
  url = _messages.StringField(2)


class Hash(_messages.Message):
  """Container message for hash values.

  Enums:
    TypeValueValuesEnum: The type of hash that was performed.

  Fields:
    type: The type of hash that was performed.
    value: The hash value.
  """

  class TypeValueValuesEnum(_messages.Enum):
    """The type of hash that was performed.

    Values:
      NONE: No hash requested.
      SHA256: A sha256 hash.
    """
    NONE = 0
    SHA256 = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)
  value = _messages.BytesField(2)


class Installation(_messages.Message):
  """This represents how a particular software package may be installed on a
  system.

  Fields:
    location: All of the places within the filesystem versions of this package
      have been found.
    name: The name of the installed package. @OutputOnly
  """

  location = _messages.MessageField('Location', 1, repeated=True)
  name = _messages.StringField(2)


class Layer(_messages.Message):
  """Layer holds metadata specific to a layer of a Docker image.

  Enums:
    DirectiveValueValuesEnum: The recovered Dockerfile directive used to
      construct this layer.

  Fields:
    arguments: The recovered arguments to the Dockerfile directive.
    directive: The recovered Dockerfile directive used to construct this
      layer.
  """

  class DirectiveValueValuesEnum(_messages.Enum):
    """The recovered Dockerfile directive used to construct this layer.

    Values:
      UNKNOWN_DIRECTIVE: Default value for unsupported/missing directive
      MAINTAINER: https://docs.docker.com/reference/builder/#maintainer
      RUN: https://docs.docker.com/reference/builder/#run
      CMD: https://docs.docker.com/reference/builder/#cmd
      LABEL: https://docs.docker.com/reference/builder/#label
      EXPOSE: https://docs.docker.com/reference/builder/#expose
      ENV: https://docs.docker.com/reference/builder/#env
      ADD: https://docs.docker.com/reference/builder/#add
      COPY: https://docs.docker.com/reference/builder/#copy
      ENTRYPOINT: https://docs.docker.com/reference/builder/#entrypoint
      VOLUME: https://docs.docker.com/reference/builder/#volume
      USER: https://docs.docker.com/reference/builder/#user
      WORKDIR: https://docs.docker.com/reference/builder/#workdir
      ARG: https://docs.docker.com/reference/builder/#arg
      ONBUILD: https://docs.docker.com/reference/builder/#onbuild
      STOPSIGNAL: https://docs.docker.com/reference/builder/#stopsignal
      HEALTHCHECK: https://docs.docker.com/reference/builder/#healthcheck
      SHELL: https://docs.docker.com/reference/builder/#shell
    """
    UNKNOWN_DIRECTIVE = 0
    MAINTAINER = 1
    RUN = 2
    CMD = 3
    LABEL = 4
    EXPOSE = 5
    ENV = 6
    ADD = 7
    COPY = 8
    ENTRYPOINT = 9
    VOLUME = 10
    USER = 11
    WORKDIR = 12
    ARG = 13
    ONBUILD = 14
    STOPSIGNAL = 15
    HEALTHCHECK = 16
    SHELL = 17

  arguments = _messages.StringField(1)
  directive = _messages.EnumField('DirectiveValueValuesEnum', 2)


class ListNoteOccurrencesResponse(_messages.Message):
  """Response including listed occurrences for a note.

  Fields:
    nextPageToken: Token to receive the next page of notes.
    occurrences: The occurrences attached to the specified note.
  """

  nextPageToken = _messages.StringField(1)
  occurrences = _messages.MessageField('Occurrence', 2, repeated=True)


class ListNotesResponse(_messages.Message):
  """Response including listed notes.

  Fields:
    nextPageToken: The next pagination token in the List response. It should
      be used as page_token for the following request. An empty value means no
      more result.
    notes: The occurrences requested
  """

  nextPageToken = _messages.StringField(1)
  notes = _messages.MessageField('Note', 2, repeated=True)


class ListOccurrencesResponse(_messages.Message):
  """Response including listed active occurrences.

  Fields:
    nextPageToken: The next pagination token in the List response. It should
      be used as page_token for the following request. An empty value means no
      more results.
    occurrences: The occurrences requested.
  """

  nextPageToken = _messages.StringField(1)
  occurrences = _messages.MessageField('Occurrence', 2, repeated=True)


class Location(_messages.Message):
  """An occurrence of a particular package installation found within a
  system's filesystem. e.g. glibc was found in /var/lib/dpkg/status

  Fields:
    cpeUri: The cpe_uri in [cpe format](https://cpe.mitre.org/specification/)
      denoting the package manager version distributing a package.
    path: The path from which we gathered that this package/version is
      installed.
    version: The version installed at this location.
  """

  cpeUri = _messages.StringField(1)
  path = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class LogConfig(_messages.Message):
  """Specifies what kind of log the caller must write Increment a streamz
  counter with the specified metric and field names.  Metric names should
  start with a '/', generally be lowercase-only, and end in "_count". Field
  names should not contain an initial slash. The actual exported metric names
  will have "/iam/policy" prepended.  Field names correspond to IAM request
  parameters and field values are their respective values.  At present the
  only supported field names are    - "iam_principal", corresponding to
  IAMContext.principal;    - "" (empty string), resulting in one aggretated
  counter with no field.  Examples:   counter { metric: "/debug_access_count"
  field: "iam_principal" }   ==> increment counter
  /iam/policy/backend_debug_access_count
  {iam_principal=[value of IAMContext.principal]}  At this time we do not
  support: * multiple field names (though this may be supported in the future)
  * decrementing the counter * incrementing it by anything other than 1

  Fields:
    cloudAudit: Cloud audit options.
    counter: Counter options.
    dataAccess: Data access options.
  """

  cloudAudit = _messages.MessageField('CloudAuditOptions', 1)
  counter = _messages.MessageField('CounterOptions', 2)
  dataAccess = _messages.MessageField('DataAccessOptions', 3)


class Note(_messages.Message):
  """Note provides a detailed description of a note using information from the
  provider of the note.

  Enums:
    KindValueValuesEnum: This explicitly denotes which kind of note is
      specified. This field can be used as a filter in list requests.
      @OutputOnly

  Fields:
    baseImage: A note describing a base image.
    buildType: Build provenance type for a verifiable build.
    createTime: The time this note was created. This field can be used as a
      filter in list requests. @OutputOnly
    expirationTime: Time of expiration for this Note, null if Note currently
      does not expire.
    kind: This explicitly denotes which kind of note is specified. This field
      can be used as a filter in list requests. @OutputOnly
    longDescription: A detailed description of this note
    name: The name of the note in the form
      "providers/{provider_id}/notes/{note_id}"
    package: A note describing a package hosted by various package managers.
    relatedUrl: Urls associated with this note
    shortDescription: A one sentence description of this note
    updateTime: The time this note was last updated. This field can be used as
      a filter in list requests. @OutputOnly
    vulnerabilityType: A package vulnerability type of note.
  """

  class KindValueValuesEnum(_messages.Enum):
    """This explicitly denotes which kind of note is specified. This field can
    be used as a filter in list requests. @OutputOnly

    Values:
      UNKNOWN: Unknown
      PACKAGE_VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD_DETAILS: The note and occurrence assert build provenance.
      IMAGE_BASIS: This represents an image basis relationship.
      PACKAGE_MANAGER: This represents a package installed via a package
        manager.
    """
    UNKNOWN = 0
    PACKAGE_VULNERABILITY = 1
    BUILD_DETAILS = 2
    IMAGE_BASIS = 3
    PACKAGE_MANAGER = 4

  baseImage = _messages.MessageField('Basis', 1)
  buildType = _messages.MessageField('BuildType', 2)
  createTime = _messages.StringField(3)
  expirationTime = _messages.StringField(4)
  kind = _messages.EnumField('KindValueValuesEnum', 5)
  longDescription = _messages.StringField(6)
  name = _messages.StringField(7)
  package = _messages.MessageField('Package', 8)
  relatedUrl = _messages.MessageField('RelatedUrl', 9, repeated=True)
  shortDescription = _messages.StringField(10)
  updateTime = _messages.StringField(11)
  vulnerabilityType = _messages.MessageField('VulnerabilityType', 12)


class Occurrence(_messages.Message):
  """Occurrence includes information about analysis occurrences for an image.
  ``

  Enums:
    KindValueValuesEnum: This explicitly denotes which of the occurrence
      details is specified. This field can be used as a filter in list
      requests. @OutputOnly

  Fields:
    buildDetails: Build details for a verifiable build.
    createTime: The time this occurrence was created. @OutputOnly
    derivedImage: Describes how this resource derives from the basis in the
      associated note.
    installation: Describes the installation of a package on the linked
      resource.
    kind: This explicitly denotes which of the occurrence details is
      specified. This field can be used as a filter in list requests.
      @OutputOnly
    name: The name of the occurrence in the form
      "projects/{project_id}/occurrences/{occurrence_id}" @OutputOnly
    noteName: An analysis note associated with this image, in the form
      "providers/{provider_id}/notes/{note_id}" This field can be used as a
      filter in list requests.
    remediation: A description of actions that can be taken to remedy the note
    resourceUrl: The unique url of the image or container for which the
      occurrence applies. Example: https://gcr.io/project/image@sha256:foo
      This field can be used as a filter in list requests.
    updateTime: The time this occurrence was last updated. @OutputOnly
    vulnerabilityDetails: Details of a security vulnerability note.
  """

  class KindValueValuesEnum(_messages.Enum):
    """This explicitly denotes which of the occurrence details is specified.
    This field can be used as a filter in list requests. @OutputOnly

    Values:
      UNKNOWN: Unknown
      PACKAGE_VULNERABILITY: The note and occurrence represent a package
        vulnerability.
      BUILD_DETAILS: The note and occurrence assert build provenance.
      IMAGE_BASIS: This represents an image basis relationship.
      PACKAGE_MANAGER: This represents a package installed via a package
        manager.
    """
    UNKNOWN = 0
    PACKAGE_VULNERABILITY = 1
    BUILD_DETAILS = 2
    IMAGE_BASIS = 3
    PACKAGE_MANAGER = 4

  buildDetails = _messages.MessageField('BuildDetails', 1)
  createTime = _messages.StringField(2)
  derivedImage = _messages.MessageField('Derived', 3)
  installation = _messages.MessageField('Installation', 4)
  kind = _messages.EnumField('KindValueValuesEnum', 5)
  name = _messages.StringField(6)
  noteName = _messages.StringField(7)
  remediation = _messages.StringField(8)
  resourceUrl = _messages.StringField(9)
  updateTime = _messages.StringField(10)
  vulnerabilityDetails = _messages.MessageField('VulnerabilityDetails', 11)


class Package(_messages.Message):
  """This represents a particular package that is distributed over various
  channels. e.g. glibc (aka libc6) is distributed by many, at various
  versions.

  Fields:
    distribution: The various channels by which a package is distributed.
    name: The name of the package.
  """

  distribution = _messages.MessageField('Distribution', 1, repeated=True)
  name = _messages.StringField(2)


class PackageIssue(_messages.Message):
  """This message wraps a location affected by a vulnerability and its
  associated fix (if one is available).

  Fields:
    affectedLocation: The location of the vulnerability.
    fixedLocation: The location of the available fix for vulnerability.
  """

  affectedLocation = _messages.MessageField('VulnerabilityLocation', 1)
  fixedLocation = _messages.MessageField('VulnerabilityLocation', 2)


class Policy(_messages.Message):
  """Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `Binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com",           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  For a description of IAM and its features, see the [IAM
  developer's guide](https://cloud.google.com/iam).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    iamOwned: A boolean attribute.
    rules: If more than one rule is specified, the rules are applied in the
      following manner: - All matching LOG rules are always applied. - If any
      DENY/DENY_WITH_LOG rule matches, permission is denied.   Logging will be
      applied if one or more matching rule requires logging. - Otherwise, if
      any ALLOW/ALLOW_WITH_LOG rule matches, permission is   granted.
      Logging will be applied if one or more matching rule requires logging. -
      Otherwise, if no rule applies, permission is denied.
    version: Version of the `Policy`. The default version is 0.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  iamOwned = _messages.BooleanField(4)
  rules = _messages.MessageField('Rule', 5, repeated=True)
  version = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class ProjectRepoId(_messages.Message):
  """Selects a repo using a Google Cloud Platform project ID (e.g. winged-
  cargo-31) and a repo name within that project.

  Fields:
    projectId: The ID of the project.
    repoName: The name of the repo. Leave empty for the default repo.
  """

  projectId = _messages.StringField(1)
  repoName = _messages.StringField(2)


class RelatedUrl(_messages.Message):
  """Metadata for any related url information

  Fields:
    label: Label to describe usage of the url
    url: Specific url to associate with the note
  """

  label = _messages.StringField(1)
  url = _messages.StringField(2)


class RepoId(_messages.Message):
  """A unique identifier for a cloud repo.

  Fields:
    projectRepoId: A combination of a project ID and a repo name.
    uid: A server-assigned, globally unique identifier.
  """

  projectRepoId = _messages.MessageField('ProjectRepoId', 1)
  uid = _messages.StringField(2)


class RepoSource(_messages.Message):
  """RepoSource describes the location of the source in a Google Cloud Source
  Repository.

  Fields:
    branchName: Name of the branch to build.
    commitSha: Explicit commit SHA to build.
    projectId: ID of the project that owns the repo.
    repoName: Name of the repo.
    tagName: Name of the tag to build.
  """

  branchName = _messages.StringField(1)
  commitSha = _messages.StringField(2)
  projectId = _messages.StringField(3)
  repoName = _messages.StringField(4)
  tagName = _messages.StringField(5)


class Rule(_messages.Message):
  """A rule to be applied in a Policy.

  Enums:
    ActionValueValuesEnum: Required

  Fields:
    action: Required
    conditions: Additional restrictions that must be met
    description: Human-readable description of the rule.
    in_: If one or more 'in' clauses are specified, the rule matches if the
      PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
    logConfig: The config returned to callers of tech.iam.IAM.CheckPolicy for
      any entries that match the LOG action.
    notIn: If one or more 'not_in' clauses are specified, the rule matches if
      the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format
      for in and not_in entries is the same as for members in a Binding (see
      google/iam/v1/policy.proto).
    permissions: A permission is a string of form '<service>.<resource
      type>.<verb>' (e.g., 'storage.buckets.list'). A value of '*' matches all
      permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches
      all verbs.
  """

  class ActionValueValuesEnum(_messages.Enum):
    """Required

    Values:
      NO_ACTION: Default no action.
      ALLOW: Matching 'Entries' grant access.
      ALLOW_WITH_LOG: Matching 'Entries' grant access and the caller promises
        to log the request per the returned log_configs.
      DENY: Matching 'Entries' deny access.
      DENY_WITH_LOG: Matching 'Entries' deny access and the caller promises to
        log the request per the returned log_configs.
      LOG: Matching 'Entries' tell IAM.Check callers to generate logs.
    """
    NO_ACTION = 0
    ALLOW = 1
    ALLOW_WITH_LOG = 2
    DENY = 3
    DENY_WITH_LOG = 4
    LOG = 5

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  conditions = _messages.MessageField('Condition', 2, repeated=True)
  description = _messages.StringField(3)
  in_ = _messages.StringField(4, repeated=True)
  logConfig = _messages.MessageField('LogConfig', 5, repeated=True)
  notIn = _messages.StringField(6, repeated=True)
  permissions = _messages.StringField(7, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  """Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class Source(_messages.Message):
  """Source describes the location of the source used for the build.

  Messages:
    FileHashesValue: Hash(es) of the build source, which can be used to verify
      that the original source integrity was maintained in the build.  The
      keys to this map are file paths used as build source and the values
      contain the hash values for those files.  If the build source came in a
      single package such as a gzipped tarfile (.tar.gz), the FileHash will be
      for the single path to that file.

  Fields:
    additionalSourceContexts: If provided, some of the source code used for
      the build may be found in these locations, in the case where the source
      repository had multiple remotes or submodules. This list will not
      include the context specified in the source_context field.
    artifactStorageSource: If provided, the input binary artifacts for the
      build came from this location.
    fileHashes: Hash(es) of the build source, which can be used to verify that
      the original source integrity was maintained in the build.  The keys to
      this map are file paths used as build source and the values contain the
      hash values for those files.  If the build source came in a single
      package such as a gzipped tarfile (.tar.gz), the FileHash will be for
      the single path to that file.
    repoSource: If provided, get source from this location in a Cloud Repo.
    sourceContext: If provided, the source code used for the build came from
      this location.
    storageSource: If provided, get the source from this location in in Google
      Cloud Storage.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FileHashesValue(_messages.Message):
    """Hash(es) of the build source, which can be used to verify that the
    original source integrity was maintained in the build.  The keys to this
    map are file paths used as build source and the values contain the hash
    values for those files.  If the build source came in a single package such
    as a gzipped tarfile (.tar.gz), the FileHash will be for the single path
    to that file.

    Messages:
      AdditionalProperty: An additional property for a FileHashesValue object.

    Fields:
      additionalProperties: Additional properties of type FileHashesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a FileHashesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileHashes attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileHashes', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  additionalSourceContexts = _messages.MessageField('ExtendedSourceContext', 1, repeated=True)
  artifactStorageSource = _messages.MessageField('StorageSource', 2)
  fileHashes = _messages.MessageField('FileHashesValue', 3)
  repoSource = _messages.MessageField('RepoSource', 4)
  sourceContext = _messages.MessageField('ExtendedSourceContext', 5)
  storageSource = _messages.MessageField('StorageSource', 6)


class SourceContext(_messages.Message):
  """A SourceContext is a reference to a tree of files. A SourceContext
  together with a path point to a unique revision of a single file or
  directory.

  Fields:
    cloudRepo: A SourceContext referring to a revision in a cloud repo.
    cloudWorkspace: A SourceContext referring to a snapshot in a cloud
      workspace.
    gerrit: A SourceContext referring to a Gerrit project.
    git: A SourceContext referring to any third party Git repo (e.g. GitHub).
  """

  cloudRepo = _messages.MessageField('CloudRepoSourceContext', 1)
  cloudWorkspace = _messages.MessageField('CloudWorkspaceSourceContext', 2)
  gerrit = _messages.MessageField('GerritSourceContext', 3)
  git = _messages.MessageField('GitSourceContext', 4)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class StorageSource(_messages.Message):
  """StorageSource describes the location of the source in an archive file in
  Google Cloud Storage.

  Fields:
    bucket: Google Cloud Storage bucket containing source (see [Bucket Name
      Requirements] (https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).
    generation: Google Cloud Storage generation for the object.
    object: Google Cloud Storage object containing source.
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  """Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  """Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Version(_messages.Message):
  """Version contains structured information about the version of the package.
  For a discussion of this in Debian/Ubuntu:
  http://serverfault.com/questions/604541/debian-packages-version-convention
  For a discussion of this in Redhat/Fedora/Centos:
  http://blog.jasonantman.com/2014/07/how-yum-and-rpm-compare-versions/

  Enums:
    KindValueValuesEnum: Distinguish between sentinel MIN/MAX versions and
      normal versions. If kind is not NORMAL, then the other fields are
      ignored.

  Fields:
    epoch: Used to correct mistakes in the version numbering scheme.
    kind: Distinguish between sentinel MIN/MAX versions and normal versions.
      If kind is not NORMAL, then the other fields are ignored.
    name: The main part of the version name.
    revision: The iteration of the package build from the above version.
  """

  class KindValueValuesEnum(_messages.Enum):
    """Distinguish between sentinel MIN/MAX versions and normal versions. If
    kind is not NORMAL, then the other fields are ignored.

    Values:
      NORMAL: A standard package version, defined by the other fields.
      MINIMUM: A special version representing negative infinity, other fields
        are ignored.
      MAXIMUM: A special version representing positive infinity, other fields
        are ignored.
    """
    NORMAL = 0
    MINIMUM = 1
    MAXIMUM = 2

  epoch = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  kind = _messages.EnumField('KindValueValuesEnum', 2)
  name = _messages.StringField(3)
  revision = _messages.StringField(4)


class VulnerabilityDetails(_messages.Message):
  """Used by Occurrence to point to where the vulnerability exists and how to
  fix it.

  Enums:
    SeverityValueValuesEnum: The note provider assigned Severity of the
      vulnerability. @OutputOnly

  Fields:
    cvssScore: The CVSS score of this vulnerability. CVSS score is on a scale
      of 0-10 where 0 indicates low severity and 10 indicates high severity.
      @OutputOnly
    packageIssue: The set of affected locations and their fixes (if available)
      within the associated resource.
    severity: The note provider assigned Severity of the vulnerability.
      @OutputOnly
    type: The type of package; whether native or non native(ruby gems, node.js
      packages etc)
  """

  class SeverityValueValuesEnum(_messages.Enum):
    """The note provider assigned Severity of the vulnerability. @OutputOnly

    Values:
      UNKNOWN: Unknown Impact
      MINIMAL: Minimal Impact
      LOW: Low Impact
      MEDIUM: Medium Impact
      HIGH: High Impact
      CRITICAL: Critical Impact
    """
    UNKNOWN = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  cvssScore = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  packageIssue = _messages.MessageField('PackageIssue', 2, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 3)
  type = _messages.StringField(4)


class VulnerabilityLocation(_messages.Message):
  """The location of the vulnerability

  Fields:
    cpeUri: The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/)
      format. Examples include distro or storage location for vulnerable jar.
      This field can be used as a filter in list requests.
    package: The package being described.
    version: The version of the package being described. This field can be
      used as a filter in list requests.
  """

  cpeUri = _messages.StringField(1)
  package = _messages.StringField(2)
  version = _messages.MessageField('Version', 3)


class VulnerabilityType(_messages.Message):
  """VulnerabilityType provides metadata about a security vulnerability.

  Enums:
    SeverityValueValuesEnum: Note provider assigned impact of the
      vulnerability

  Fields:
    cvssScore: The CVSS score for this Vulnerability.
    details: All information about the package to specifically identify this
      vulnerability. One entry per (version range and cpe_uri) the package
      vulnerability has manifested in.
    severity: Note provider assigned impact of the vulnerability
  """

  class SeverityValueValuesEnum(_messages.Enum):
    """Note provider assigned impact of the vulnerability

    Values:
      UNKNOWN: Unknown Impact
      MINIMAL: Minimal Impact
      LOW: Low Impact
      MEDIUM: Medium Impact
      HIGH: High Impact
      CRITICAL: Critical Impact
    """
    UNKNOWN = 0
    MINIMAL = 1
    LOW = 2
    MEDIUM = 3
    HIGH = 4
    CRITICAL = 5

  cvssScore = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  details = _messages.MessageField('Detail', 2, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 3)


encoding.AddCustomJsonFieldMapping(
    Rule, 'in_', 'in',
    package=u'containeranalysis')
encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'containeranalysis')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'containeranalysis')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'containeranalysis')
