# This file was automatically generated by bifcl from /pobj/bro-2.5.1/bro-2.5.1/src/analyzer/protocol/ssl/events.bif (plugin mode).

## Generated for an SSL/TLS client's initial *hello* message.  SSL/TLS sessions
## start with an unencrypted handshake, and Bro extracts as much information out
## of that as it can. This event provides access to the initial information
## sent by the client.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## version: The protocol version as extracted from the client's message.  The
##          values are standardized as part of the SSL/TLS protocol. The
##          :bro:id:`SSL::version_strings` table maps them to descriptive names.
##
## possible_ts: The current time as sent by the client. Note that SSL/TLS does
##              not require clocks to be set correctly, so treat with care.
##
## session_id: The session ID sent by the client (if any).
##
## client_random: The random value sent by the client. For version 2 connections,
##		  the client challenge is returned.
##
## ciphers: The list of ciphers the client offered to use. The values are
##          standardized as part of the SSL/TLS protocol. The
##          :bro:id:`SSL::cipher_desc` table maps them to descriptive names.
##
## .. bro:see:: ssl_alert ssl_established ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake x509_certificate ssl_handshake_message
##    ssl_change_cipher_spec
export {
global ssl_client_hello: event(c: connection , version: count , possible_ts: time , client_random: string , session_id: string , ciphers: index_vec );


## Generated for an SSL/TLS server's initial *hello* message. SSL/TLS sessions
## start with an unencrypted handshake, and Bro extracts as much information out
## of that as it can. This event provides access to the initial information
## sent by the client.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## version: The protocol version as extracted from the server's message.
##          The values are standardized as part of the SSL/TLS protocol. The
##          :bro:id:`SSL::version_strings` table maps them to descriptive names.
##
## possible_ts: The current time as sent by the server. Note that SSL/TLS does
##              not require clocks to be set correctly, so treat with care. This value
##              is not sent in TLSv1.3.
##
## session_id: The session ID as sent back by the server (if any). This value is not
##             sent in TLSv1.3.
##
## server_random: The random value sent by the server. For version 2 connections,
##		  the connection-id is returned.
##
## cipher: The cipher chosen by the server.  The values are standardized as part
##         of the SSL/TLS protocol. The :bro:id:`SSL::cipher_desc` table maps
##         them to descriptive names.
##
## comp_method: The compression method chosen by the client. The values are
##              standardized as part of the SSL/TLS protocol. This value is not
##              sent in TLSv1.3.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_extension
##    ssl_session_ticket_handshake x509_certificate ssl_server_curve
##    ssl_dh_server_params ssl_handshake_message ssl_change_cipher_spec
global ssl_server_hello: event(c: connection , version: count , possible_ts: time , server_random: string , session_id: string , cipher: count , comp_method: count );


## Generated for SSL/TLS extensions seen in an initial handshake.  SSL/TLS
## sessions start with an unencrypted handshake, and Bro extracts as much
## information out of that as it can. This event provides access to any
## extensions either side sends as part of an extended *hello* message.
##
## Note that Bro offers more specialized events for a few extensions.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## code: The numerical code of the extension.  The values are standardized as
##       part of the SSL/TLS protocol. The :bro:id:`SSL::extensions` table maps
##       them to descriptive names.
##
## val: The raw extension value that was sent in the message.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension_ec_point_formats
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_extension_signature_algorithm ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
global ssl_extension: event(c: connection , is_orig: bool , code: count , val: string );


## Generated for an SSL/TLS Elliptic Curves extension. This TLS extension is
## defined in :rfc:`4492` and sent by the client in the initial handshake. It
## gives the list of elliptic curves supported by the client.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## curves: List of supported elliptic curves.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_ec_point_formats ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_server_curve ssl_extension_signature_algorithm
##    ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
global ssl_extension_elliptic_curves: event(c: connection , is_orig: bool , curves: index_vec );


## Generated for an SSL/TLS Supported Point Formats extension. This TLS extension
## is defined in :rfc:`4492` and sent by the client and/or server in the initial
## handshake. It gives the list of elliptic curve point formats supported by the
## client.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## point_formats: List of supported point formats.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_server_curve ssl_extension_signature_algorithm
##    ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
global ssl_extension_ec_point_formats: event(c: connection , is_orig: bool , point_formats: index_vec );


## Generated for an Signature Algorithms extension. This TLS extension
## is defined in :rfc:`5246` and sent by the client in the initial
## handshake. It gives the list of signature and hash algorithms supported by the
## client.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## signature_algorithms: List of supported signature and hash algorithm pairs.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_server_curve ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
global ssl_extension_signature_algorithm: event(c: connection , is_orig: bool , signature_algorithms: signature_and_hashalgorithm_vec );


## Generated for a Key Share extension. This TLS extension is defined in TLS1.3-draft16
## and sent by the client and the server in the initial handshake. It gives the list of
## named groups supported by the client and chosen by the server.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## curves: List of supported/chosen named groups.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_server_curve
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
global ssl_extension_key_share: event(c: connection , is_orig: bool , curves: index_vec );


## Generated if a named curve is chosen by the server for an SSL/TLS connection.
## The curve is sent by the server in the ServerKeyExchange message as defined
## in :rfc:`4492`, in case an ECDH or ECDHE cipher suite is chosen.
##
## c: The connection.
##
## curve: The curve.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_server_name ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
global ssl_server_curve: event(c: connection , curve: count );


## Generated if a server uses a DH-anon or DHE cipher suite. This event contains
## the server DH parameters, which are sent in the ServerKeyExchange message as
## defined in :rfc:`5246`.
##
## c: The connection.
##
## p: The DH prime modulus.
##
## q: The DH generator.
##
## Ys: The server's DH public key.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_server_curve
global ssl_dh_server_params: event(c: connection , p: string , q: string , Ys: string );


## Generated for an SSL/TLS Application-Layer Protocol Negotiation extension.
## This TLS extension is defined in draft-ietf-tls-applayerprotoneg and sent in
## the initial handshake. It contains the list of client supported application
## protocols by the client or the server, respectively.
##
## At the moment it is mostly used to negotiate the use of SPDY / HTTP2-drafts.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## protocols: List of supported application layer protocols.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_server_name ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
global ssl_extension_application_layer_protocol_negotiation: event(c: connection , is_orig: bool , protocols: string_vec );


## Generated for an SSL/TLS Server Name extension. This SSL/TLS extension is
## defined in :rfc:`3546` and sent by the client in the initial handshake. It
## contains the name of the server it is contacting. This information can be
## used by the server to choose the correct certificate for the host the client
## wants to contact.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## names: A list of server names (DNS hostnames).
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_key_share
##    ssl_extension_psk_key_exchange_modes ssl_extension_supported_versions
global ssl_extension_server_name: event(c: connection , is_orig: bool , names: string_vec );


## Generated for an TLS Supported Versions extension. This TLS extension
## is defined in the TLS 1.3 rfc and sent by the client in the initial handshake.
## It contains the TLS versions that it supports. This informaion can be used by
## the server to choose the best TLS version o use.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## versions: List of supported TLS versions.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_key_share ssl_extension_server_name
##    ssl_extension_psk_key_exchange_modes
global ssl_extension_supported_versions: event(c: connection , is_orig: bool , versions: index_vec );


## Generated for an TLS Pre-Shared Key Exchange Modes extension. This TLS extension is defined
## in the TLS 1.3 rfc and sent by the client in the initial handshake. It contains the
## list of Pre-Shared Key Exchange Modes that it supports.
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## versions: List of supported Pre-Shared Key Exchange Modes.
##
## .. bro:see:: ssl_alert ssl_client_hello ssl_established ssl_server_hello
##    ssl_session_ticket_handshake ssl_extension
##    ssl_extension_elliptic_curves ssl_extension_ec_point_formats
##    ssl_extension_application_layer_protocol_negotiation
##    ssl_extension_key_share ssl_extension_server_name
##    ssl_extension_supported_versions
global ssl_extension_psk_key_exchange_modes: event(c: connection , is_orig: bool , modes: index_vec );


## Generated at the end of an SSL/TLS handshake. SSL/TLS sessions start with
## an unencrypted handshake, and Bro extracts as much information out of that
## as it can. This event signals the time when an SSL/TLS has finished the
## handshake and its endpoints consider it as fully established. Typically,
## everything from now on will be encrypted.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## .. bro:see:: ssl_alert ssl_client_hello  ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake x509_certificate
global ssl_established: event(c: connection );


## Generated for SSL/TLS alert records. SSL/TLS sessions start with an
## unencrypted handshake, and Bro extracts as much information out of that as
## it can. If during that handshake, an endpoint encounters a fatal error, it
## sends an *alert* record, that in turn triggers this event. After an *alert*,
## any endpoint may close the connection immediately.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## level: The severity level, as sent in the *alert*. The values are defined as
##        part of the SSL/TLS protocol.
##
## desc: A numerical value identifying the cause of the *alert*. The values are
##       defined as part of the SSL/TLS protocol.
##
## .. bro:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake
global ssl_alert: event(c: connection , is_orig: bool , level: count , desc: count );


## Generated for SSL/TLS handshake messages that are a part of the
## stateless-server session resumption mechanism. SSL/TLS sessions start with
## an unencrypted handshake, and Bro extracts as much information out of that
## as it can. This event is raised when an SSL/TLS server passes a session
## ticket to the client that can later be used for resuming the session. The
## mechanism is described in :rfc:`4507`.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Transport_Layer_Security>`__ for
## more information about the SSL/TLS protocol.
##
## c: The connection.
##
## ticket_lifetime_hint: A hint from the server about how long the ticket
##                       should be stored by the client.
##
## ticket: The raw ticket data.
##
## .. bro:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_alert
global ssl_session_ticket_handshake: event(c: connection , ticket_lifetime_hint: count , ticket: string );


## Generated for SSL/TLS heartbeat messages that are sent before session
## encryption starts. Generally heartbeat messages should rarely be seen in
## normal TLS traffic. Heartbeats are described in :rfc:`6520`.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## length: length of the entire heartbeat message.
##
## heartbeat_type: type of the heartbeat message. Per RFC, 1 = request, 2 = response.
##
## payload_length: length of the payload of the heartbeat message, according to
##                 packet field.
##
## payload: payload contained in the heartbeat message. Size can differ from
##          payload_length, if payload_length and actual packet length disagree.
##
## .. bro:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_alert ssl_encrypted_data
global ssl_heartbeat: event(c: connection , is_orig: bool , length: count , heartbeat_type: count , payload_length: count , payload: string );


## Generated for non-handshake SSL/TLS application_data messages that are sent before
## full encryption starts. For TLS 1.2 and lower, this event should not be raised. For TLS 1.3,
## it is used by Bro internally to determine if the connection has been completely setup.
## This is necessary as TLS 1.3 does not have CCS anymore.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## content_type: message type as reported by TLS session layer.
##
## length: length of the entire heartbeat message.
##
## .. bro:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_alert ssl_heartbeat
global ssl_application_data: event(c: connection , is_orig: bool , length: count );


## Generated for SSL/TLS messages that are sent after session encryption
## started.
##
## Note that :bro:id:`SSL::disable_analyzer_after_detection` has to be changed
## from its default to false for this event to be generated.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## content_type: message type as reported by TLS session layer.
##
## length: length of the entire heartbeat message.
##
## .. bro:see::  ssl_client_hello ssl_established ssl_extension ssl_server_hello
##    ssl_alert ssl_heartbeat
global ssl_encrypted_data: event(c: connection , is_orig: bool , content_type: count , length: count );


## This event contains the OCSP response contained in a Certificate Status Request
## message, when the client requested OCSP stapling and the server supports it.
## See description in :rfc:`6066`.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## response: OCSP data.
global ssl_stapled_ocsp: event(c: connection , is_orig: bool , response: string );


## This event is raised for each unencrypted SSL/TLS handshake message.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## msg_type: Type of the handshake message that was seen.
##
## length: Length of the handshake message that was seen.
##
## .. bro:see:: ssl_alert ssl_established ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake x509_certificate ssl_client_hello
##    ssl_change_cipher_spec
global ssl_handshake_message: event(c: connection , is_orig: bool , msg_type: count , length: count );


## This event is raised when a SSL/TLS ChangeCipherSpec message is encountered
## before encryption begins. Traffic will be encrypted following this message.
##
## c: The connection.
##
## is_orig: True if event is raised for originator side of the connection.
##
## .. bro:see:: ssl_alert ssl_established ssl_extension ssl_server_hello
##    ssl_session_ticket_handshake x509_certificate ssl_client_hello
##    ssl_handshake_message
global ssl_change_cipher_spec: event(c: connection , is_orig: bool );

} # end of export section
module GLOBAL;
